/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.spanner;

import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spring.autoconfigure.core.GcpContextAutoConfiguration;
import com.google.cloud.spring.autoconfigure.spanner.GcpSpannerAutoConfiguration;
import com.google.cloud.spring.autoconfigure.spanner.GcpSpannerProperties;
import com.google.cloud.spring.autoconfigure.spanner.SpannerOptionsCustomizer;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import java.io.IOException;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={GcpSpannerAutoConfiguration.class, GcpContextAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpSpannerProperties.class})
@ConditionalOnProperty(prefix="spring.cloud.gcp.spanner.emulator", name={"enabled"}, havingValue="true")
public class GcpSpannerEmulatorAutoConfiguration {
    private final GcpSpannerProperties properties;
    private final String projectId;
    private final CredentialsProvider credentialsProvider;

    public GcpSpannerEmulatorAutoConfiguration(GcpSpannerProperties properties, GcpProjectIdProvider projectIdProvider) {
        this.projectId = properties.getProjectId() != null ? properties.getProjectId() : projectIdProvider.getProjectId();
        this.properties = properties;
        this.credentialsProvider = NoCredentials::getInstance;
    }

    @Bean
    @ConditionalOnMissingBean
    public CredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerOptions spannerOptions(Optional<SpannerOptionsCustomizer> customizer) throws IOException {
        Assert.notNull((Object)this.properties.getEmulatorHost(), (String)"`spring.cloud.gcp.spanner.emulator-host` must be set.");
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        ((SpannerOptions.Builder)((SpannerOptions.Builder)builder.setProjectId(this.projectId)).setCredentials(this.credentialsProvider.getCredentials())).setEmulatorHost(this.properties.getEmulatorHost());
        customizer.ifPresent(c -> c.apply(builder));
        return builder.build();
    }
}

