/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1.CreateDeploymentResourcePoolOperationMetadata;
import com.google.cloud.aiplatform.v1.CreateDeploymentResourcePoolRequest;
import com.google.cloud.aiplatform.v1.DeleteDeploymentResourcePoolRequest;
import com.google.cloud.aiplatform.v1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1.DeployedModel;
import com.google.cloud.aiplatform.v1.DeploymentResourcePool;
import com.google.cloud.aiplatform.v1.DeploymentResourcePoolName;
import com.google.cloud.aiplatform.v1.DeploymentResourcePoolServiceSettings;
import com.google.cloud.aiplatform.v1.GetDeploymentResourcePoolRequest;
import com.google.cloud.aiplatform.v1.ListDeploymentResourcePoolsRequest;
import com.google.cloud.aiplatform.v1.ListDeploymentResourcePoolsResponse;
import com.google.cloud.aiplatform.v1.LocationName;
import com.google.cloud.aiplatform.v1.ProjectName;
import com.google.cloud.aiplatform.v1.QueryDeployedModelsRequest;
import com.google.cloud.aiplatform.v1.QueryDeployedModelsResponse;
import com.google.cloud.aiplatform.v1.stub.DeploymentResourcePoolServiceStub;
import com.google.cloud.aiplatform.v1.stub.DeploymentResourcePoolServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeploymentResourcePoolServiceClient
implements BackgroundResource {
    private final DeploymentResourcePoolServiceSettings settings;
    private final DeploymentResourcePoolServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DeploymentResourcePoolServiceClient create() throws IOException {
        return DeploymentResourcePoolServiceClient.create(DeploymentResourcePoolServiceSettings.newBuilder().build());
    }

    public static final DeploymentResourcePoolServiceClient create(DeploymentResourcePoolServiceSettings settings) throws IOException {
        return new DeploymentResourcePoolServiceClient(settings);
    }

    public static final DeploymentResourcePoolServiceClient create(DeploymentResourcePoolServiceStub stub) {
        return new DeploymentResourcePoolServiceClient(stub);
    }

    protected DeploymentResourcePoolServiceClient(DeploymentResourcePoolServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeploymentResourcePoolServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected DeploymentResourcePoolServiceClient(DeploymentResourcePoolServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DeploymentResourcePoolServiceSettings getSettings() {
        return this.settings;
    }

    public DeploymentResourcePoolServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolAsync(LocationName parent, DeploymentResourcePool deploymentResourcePool, String deploymentResourcePoolId) {
        CreateDeploymentResourcePoolRequest request = CreateDeploymentResourcePoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeploymentResourcePool(deploymentResourcePool).setDeploymentResourcePoolId(deploymentResourcePoolId).build();
        return this.createDeploymentResourcePoolAsync(request);
    }

    public final OperationFuture<DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolAsync(String parent, DeploymentResourcePool deploymentResourcePool, String deploymentResourcePoolId) {
        CreateDeploymentResourcePoolRequest request = CreateDeploymentResourcePoolRequest.newBuilder().setParent(parent).setDeploymentResourcePool(deploymentResourcePool).setDeploymentResourcePoolId(deploymentResourcePoolId).build();
        return this.createDeploymentResourcePoolAsync(request);
    }

    public final OperationFuture<DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolAsync(CreateDeploymentResourcePoolRequest request) {
        return this.createDeploymentResourcePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDeploymentResourcePoolRequest, DeploymentResourcePool, CreateDeploymentResourcePoolOperationMetadata> createDeploymentResourcePoolOperationCallable() {
        return this.stub.createDeploymentResourcePoolOperationCallable();
    }

    public final UnaryCallable<CreateDeploymentResourcePoolRequest, Operation> createDeploymentResourcePoolCallable() {
        return this.stub.createDeploymentResourcePoolCallable();
    }

    public final DeploymentResourcePool getDeploymentResourcePool(DeploymentResourcePoolName name) {
        GetDeploymentResourcePoolRequest request = GetDeploymentResourcePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeploymentResourcePool(request);
    }

    public final DeploymentResourcePool getDeploymentResourcePool(String name) {
        GetDeploymentResourcePoolRequest request = GetDeploymentResourcePoolRequest.newBuilder().setName(name).build();
        return this.getDeploymentResourcePool(request);
    }

    public final DeploymentResourcePool getDeploymentResourcePool(GetDeploymentResourcePoolRequest request) {
        return (DeploymentResourcePool)this.getDeploymentResourcePoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentResourcePoolRequest, DeploymentResourcePool> getDeploymentResourcePoolCallable() {
        return this.stub.getDeploymentResourcePoolCallable();
    }

    public final ListDeploymentResourcePoolsPagedResponse listDeploymentResourcePools(ProjectName parent) {
        ListDeploymentResourcePoolsRequest request = ListDeploymentResourcePoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeploymentResourcePools(request);
    }

    public final ListDeploymentResourcePoolsPagedResponse listDeploymentResourcePools(String parent) {
        ListDeploymentResourcePoolsRequest request = ListDeploymentResourcePoolsRequest.newBuilder().setParent(parent).build();
        return this.listDeploymentResourcePools(request);
    }

    public final ListDeploymentResourcePoolsPagedResponse listDeploymentResourcePools(ListDeploymentResourcePoolsRequest request) {
        return (ListDeploymentResourcePoolsPagedResponse)((Object)this.listDeploymentResourcePoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsPagedResponse> listDeploymentResourcePoolsPagedCallable() {
        return this.stub.listDeploymentResourcePoolsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse> listDeploymentResourcePoolsCallable() {
        return this.stub.listDeploymentResourcePoolsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolAsync(DeploymentResourcePoolName name) {
        DeleteDeploymentResourcePoolRequest request = DeleteDeploymentResourcePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDeploymentResourcePoolAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolAsync(String name) {
        DeleteDeploymentResourcePoolRequest request = DeleteDeploymentResourcePoolRequest.newBuilder().setName(name).build();
        return this.deleteDeploymentResourcePoolAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolAsync(DeleteDeploymentResourcePoolRequest request) {
        return this.deleteDeploymentResourcePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDeploymentResourcePoolRequest, Empty, DeleteOperationMetadata> deleteDeploymentResourcePoolOperationCallable() {
        return this.stub.deleteDeploymentResourcePoolOperationCallable();
    }

    public final UnaryCallable<DeleteDeploymentResourcePoolRequest, Operation> deleteDeploymentResourcePoolCallable() {
        return this.stub.deleteDeploymentResourcePoolCallable();
    }

    public final QueryDeployedModelsPagedResponse queryDeployedModels(String deploymentResourcePool) {
        QueryDeployedModelsRequest request = QueryDeployedModelsRequest.newBuilder().setDeploymentResourcePool(deploymentResourcePool).build();
        return this.queryDeployedModels(request);
    }

    public final QueryDeployedModelsPagedResponse queryDeployedModels(QueryDeployedModelsRequest request) {
        return (QueryDeployedModelsPagedResponse)((Object)this.queryDeployedModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryDeployedModelsRequest, QueryDeployedModelsPagedResponse> queryDeployedModelsPagedCallable() {
        return this.stub.queryDeployedModelsPagedCallable();
    }

    public final UnaryCallable<QueryDeployedModelsRequest, QueryDeployedModelsResponse> queryDeployedModelsCallable() {
        return this.stub.queryDeployedModelsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryDeployedModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel, QueryDeployedModelsPage, QueryDeployedModelsFixedSizeCollection> {
        private QueryDeployedModelsFixedSizeCollection(List<QueryDeployedModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryDeployedModelsFixedSizeCollection createEmptyCollection() {
            return new QueryDeployedModelsFixedSizeCollection(null, 0);
        }

        protected QueryDeployedModelsFixedSizeCollection createCollection(List<QueryDeployedModelsPage> pages, int collectionSize) {
            return new QueryDeployedModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryDeployedModelsPage
    extends AbstractPage<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel, QueryDeployedModelsPage> {
        private QueryDeployedModelsPage(PageContext<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel> context, QueryDeployedModelsResponse response) {
            super(context, (Object)response);
        }

        private static QueryDeployedModelsPage createEmptyPage() {
            return new QueryDeployedModelsPage(null, null);
        }

        protected QueryDeployedModelsPage createPage(PageContext<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel> context, QueryDeployedModelsResponse response) {
            return new QueryDeployedModelsPage(context, response);
        }

        public ApiFuture<QueryDeployedModelsPage> createPageAsync(PageContext<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel> context, ApiFuture<QueryDeployedModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryDeployedModelsPagedResponse
    extends AbstractPagedListResponse<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel, QueryDeployedModelsPage, QueryDeployedModelsFixedSizeCollection> {
        public static ApiFuture<QueryDeployedModelsPagedResponse> createAsync(PageContext<QueryDeployedModelsRequest, QueryDeployedModelsResponse, DeployedModel> context, ApiFuture<QueryDeployedModelsResponse> futureResponse) {
            ApiFuture<QueryDeployedModelsPage> futurePage = QueryDeployedModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryDeployedModelsPagedResponse((QueryDeployedModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryDeployedModelsPagedResponse(QueryDeployedModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryDeployedModelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeploymentResourcePoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool, ListDeploymentResourcePoolsPage, ListDeploymentResourcePoolsFixedSizeCollection> {
        private ListDeploymentResourcePoolsFixedSizeCollection(List<ListDeploymentResourcePoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentResourcePoolsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentResourcePoolsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentResourcePoolsFixedSizeCollection createCollection(List<ListDeploymentResourcePoolsPage> pages, int collectionSize) {
            return new ListDeploymentResourcePoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentResourcePoolsPage
    extends AbstractPage<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool, ListDeploymentResourcePoolsPage> {
        private ListDeploymentResourcePoolsPage(PageContext<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool> context, ListDeploymentResourcePoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentResourcePoolsPage createEmptyPage() {
            return new ListDeploymentResourcePoolsPage(null, null);
        }

        protected ListDeploymentResourcePoolsPage createPage(PageContext<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool> context, ListDeploymentResourcePoolsResponse response) {
            return new ListDeploymentResourcePoolsPage(context, response);
        }

        public ApiFuture<ListDeploymentResourcePoolsPage> createPageAsync(PageContext<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool> context, ApiFuture<ListDeploymentResourcePoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentResourcePoolsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool, ListDeploymentResourcePoolsPage, ListDeploymentResourcePoolsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentResourcePoolsPagedResponse> createAsync(PageContext<ListDeploymentResourcePoolsRequest, ListDeploymentResourcePoolsResponse, DeploymentResourcePool> context, ApiFuture<ListDeploymentResourcePoolsResponse> futureResponse) {
            ApiFuture<ListDeploymentResourcePoolsPage> futurePage = ListDeploymentResourcePoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentResourcePoolsPagedResponse((ListDeploymentResourcePoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentResourcePoolsPagedResponse(ListDeploymentResourcePoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentResourcePoolsFixedSizeCollection.createEmptyCollection());
        }
    }
}

