/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage.oauth;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

final class URLFetchUtils {
    private URLFetchUtils() {
    }

    static String describeRequest(HTTPRequest req) {
        StringBuilder b = new StringBuilder(req.getMethod() + " " + req.getURL());
        for (HTTPHeader h : req.getHeaders()) {
            b.append("\n" + h.getName() + ": " + h.getValue());
        }
        b.append("\n\n");
        if (req.getPayload() == null) {
            b.append("no content");
        } else {
            b.append(req.getPayload().length + " bytes of content");
        }
        return b + "\n";
    }

    static String describeResponse(HTTPResponse resp, boolean includeBody) {
        StringBuilder b = new StringBuilder(resp.getResponseCode() + " with " + resp.getContent().length + " bytes of content");
        for (HTTPHeader h : resp.getHeadersUncombined()) {
            b.append("\n" + h.getName() + ": " + h.getValue());
        }
        if (includeBody) {
            b.append("\n" + new String(resp.getContent(), Charsets.UTF_8));
        } else {
            b.append("\n<content elided>");
        }
        return b + "\n";
    }

    static String describeRequestAndResponse(HTTPRequest req, HTTPResponse resp, boolean includeResponseBody) {
        return "Request: " + URLFetchUtils.describeRequest(req) + "\nResponse: " + URLFetchUtils.describeResponse(resp, includeResponseBody);
    }

    static List<String> getHeaders(HTTPResponse resp, String headerName) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (HTTPHeader h : resp.getHeadersUncombined()) {
            if (!headerName.equalsIgnoreCase(h.getName())) continue;
            b.add((Object)h.getValue());
        }
        return b.build();
    }

    static String getSingleHeader(HTTPResponse resp, String headerName) {
        return (String)Iterables.getOnlyElement(URLFetchUtils.getHeaders(resp, headerName));
    }

    static HTTPRequest copyRequest(HTTPRequest in) {
        HTTPRequest out = new HTTPRequest(in.getURL(), in.getMethod(), in.getFetchOptions());
        for (HTTPHeader h : in.getHeaders()) {
            out.addHeader(h);
        }
        out.setPayload(in.getPayload());
        return out;
    }
}

