/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage.oauth;

import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.tools.cloudstorage.oauth.AbstractOAuthURLFetchService;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class AppIdentityOAuthURLFetchService
extends AbstractOAuthURLFetchService {
    private final List<String> oauthScopes;

    AppIdentityOAuthURLFetchService(List<String> oauthScopes) {
        this.oauthScopes = ImmutableList.copyOf(oauthScopes);
    }

    @Override
    protected String getAuthorization() {
        String accessToken = AppIdentityServiceFactory.getAppIdentityService().getAccessToken(this.oauthScopes).getAccessToken();
        if (SystemProperty.environment.value() == SystemProperty.Environment.Value.Development) {
            throw new RuntimeException(this + ": The access token from the development environment won't work: " + accessToken);
        }
        return "Bearer " + accessToken;
    }
}

