/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage.oauth;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.tools.cloudstorage.oauth.OAuthURLFetchService;
import com.google.appengine.tools.cloudstorage.oauth.URLFetchUtils;
import java.io.IOException;
import java.util.concurrent.Future;

abstract class AbstractOAuthURLFetchService
implements OAuthURLFetchService {
    private static final URLFetchService URLFETCH = URLFetchServiceFactory.getURLFetchService();

    AbstractOAuthURLFetchService() {
    }

    protected abstract String getAuthorization();

    private HTTPRequest authorizeRequest(HTTPRequest req) {
        req = URLFetchUtils.copyRequest(req);
        req.setHeader(new HTTPHeader("Authorization", this.getAuthorization()));
        return req;
    }

    @Override
    public HTTPResponse fetch(HTTPRequest req) throws IOException {
        return URLFETCH.fetch(this.authorizeRequest(req));
    }

    @Override
    public Future<HTTPResponse> fetchAsync(HTTPRequest req) {
        return URLFETCH.fetchAsync(this.authorizeRequest(req));
    }
}

