/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage.dev;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import com.google.appengine.api.files.FileStat;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.api.files.GSFileOptions;
import com.google.appengine.tools.cloudstorage.BadRangeException;
import com.google.appengine.tools.cloudstorage.GcsFileMetadata;
import com.google.appengine.tools.cloudstorage.GcsFileOptions;
import com.google.appengine.tools.cloudstorage.GcsFilename;
import com.google.appengine.tools.cloudstorage.RawGcsService;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Future;

final class LocalRawGcsService
implements RawGcsService {
    static final int CHUNK_ALIGNMENT_BYTES = 262144;
    private static final DatastoreService DATASTORE = DatastoreServiceFactory.getDatastoreService();
    private static final FileService FILES = FileServiceFactory.getFileService();
    private static final String ENTITY_KIND_PREFIX = "_ah_FakeCloudStorage__";
    private static final String OPTIONS_PROP = "options";

    LocalRawGcsService() {
    }

    @Override
    public Token beginObjectCreation(GcsFilename filename, GcsFileOptions options, long timeoutMillis) throws IOException {
        return new Token(filename, options, 0L, FILES.createNewGSFile(this.gcsOptsToGsOpts(filename, options)));
    }

    private GSFileOptions gcsOptsToGsOpts(GcsFilename filename, GcsFileOptions options) {
        GSFileOptions.GSFileOptionsBuilder builder = new GSFileOptions.GSFileOptionsBuilder();
        builder.setBucket(filename.getBucketName());
        builder.setKey(filename.getObjectName());
        if (options.getAcl() != null) {
            builder.setAcl(options.getAcl());
        }
        if (options.getCacheControl() != null) {
            builder.setCacheControl(options.getCacheControl());
        }
        if (options.getContentDisposition() != null) {
            builder.setContentDisposition(options.getContentDisposition());
        }
        if (options.getContentEncoding() != null) {
            builder.setContentEncoding(options.getContentEncoding());
        }
        if (options.getMimeType() != null) {
            builder.setMimeType(options.getMimeType());
        }
        for (Map.Entry<String, String> entry : options.getUserMetadata().entrySet()) {
            builder.addUserMetadata(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token append(RawGcsService.RawGcsCreationToken token, ByteBuffer chunk) throws IOException {
        Token t = (Token)token;
        FileWriteChannel ch = FILES.openWriteChannel(t.file, false);
        int n = chunk.remaining();
        try {
            int r = ch.write(chunk);
            Preconditions.checkState((r == n ? 1 : 0) != 0, (String)"%s: Bad write: %s != %s", (Object[])new Object[]{this, r, n});
        }
        finally {
            ch.close();
        }
        return new Token(t.filename, t.options, t.offset + (long)n, t.file);
    }

    @Override
    public RawGcsService.RawGcsCreationToken continueObjectCreation(RawGcsService.RawGcsCreationToken token, ByteBuffer chunk, long timeoutMillis) throws IOException {
        return this.append(token, chunk);
    }

    private Key makeKey(GcsFilename filename) {
        return KeyFactory.createKey((String)(ENTITY_KIND_PREFIX + filename.getBucketName()), (String)filename.getObjectName());
    }

    @Override
    public void finishObjectCreation(RawGcsService.RawGcsCreationToken token, ByteBuffer chunk, long timeoutMillis) throws IOException {
        Token t = this.append(token, chunk);
        FILES.openWriteChannel(t.file, true).closeFinally();
        Entity e = new Entity(this.makeKey(t.filename));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(t.options);
        oout.close();
        e.setUnindexedProperty(OPTIONS_PROP, (Object)new Blob(bout.toByteArray()));
        DATASTORE.put(null, e);
    }

    private AppEngineFile nameToAppEngineFile(GcsFilename filename) {
        return new AppEngineFile(AppEngineFile.FileSystem.GS, filename.getBucketName() + "/" + filename.getObjectName());
    }

    @Override
    public GcsFileMetadata getObjectMetadata(GcsFilename filename, long timeoutMillis) throws IOException {
        GcsFileOptions options;
        Entity e;
        try {
            e = DATASTORE.get(null, this.makeKey(filename));
        }
        catch (EntityNotFoundException ex) {
            return null;
        }
        AppEngineFile file = this.nameToAppEngineFile(filename);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(((Blob)e.getProperty(OPTIONS_PROP)).getBytes()));
        try {
            options = (GcsFileOptions)in.readObject();
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            in.close();
        }
        FileStat stat = FILES.stat(file);
        return new GcsFileMetadata(filename, options, null, FILES.stat(file).getLength());
    }

    @Override
    public Future<GcsFileMetadata> readObjectAsync(ByteBuffer dst, GcsFilename filename, long offset, long timeoutMillis) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"%s: offset must be non-negative: %s", (Object[])new Object[]{this, offset});
        try {
            GcsFileMetadata meta = this.getObjectMetadata(filename, timeoutMillis);
            if (meta == null) {
                return Futures.immediateFailedFuture((Throwable)new FileNotFoundException(this + ": No such file: " + filename));
            }
            if (offset >= meta.getLength()) {
                return Futures.immediateFailedFuture((Throwable)new BadRangeException("The requested range cannot be satisfied. bytes=" + Long.toString(offset) + "-" + Long.toString(offset + (long)dst.remaining()) + " the file is only " + meta.getLength()));
            }
            AppEngineFile file = this.nameToAppEngineFile(filename);
            FileReadChannel readChannel = FILES.openReadChannel(file, false);
            readChannel.position(offset);
            int read = 0;
            while (read != -1 && dst.hasRemaining()) {
                read = readChannel.read(dst);
            }
            return Futures.immediateFuture((Object)meta);
        }
        catch (IOException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public boolean deleteObject(GcsFilename filename, long timeoutMillis) throws IOException {
        AppEngineFile file = this.nameToAppEngineFile(filename);
        if (file == null) {
            return false;
        }
        DATASTORE.delete((Transaction)null, new Key[]{this.makeKey(filename)});
        FILES.delete(new AppEngineFile[]{file});
        return true;
    }

    @Override
    public int getChunkSizeBytes() {
        return 262144;
    }

    static final class Token
    implements RawGcsService.RawGcsCreationToken {
        private static final long serialVersionUID = 954846981243798905L;
        private final GcsFilename filename;
        private final GcsFileOptions options;
        private final long offset;
        private final AppEngineFile file;

        Token(GcsFilename filename, GcsFileOptions options, long offset, AppEngineFile file) {
            this.options = options;
            this.filename = (GcsFilename)Preconditions.checkNotNull((Object)filename, (Object)"Null filename");
            this.offset = offset;
            this.file = (AppEngineFile)Preconditions.checkNotNull((Object)file, (Object)"Null file");
        }

        @Override
        public GcsFilename getFilename() {
            return this.filename;
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.filename + ", " + this.offset + ")";
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token other = (Token)o;
            return this.offset == other.offset && Objects.equal((Object)this.filename, (Object)other.filename) && Objects.equal((Object)this.options, (Object)other.options);
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.filename, this.offset, this.options});
        }
    }
}

