/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.appengine.tools.cloudstorage.BadRangeException;
import com.google.appengine.tools.cloudstorage.GcsFileMetadata;
import com.google.appengine.tools.cloudstorage.GcsFilename;
import com.google.appengine.tools.cloudstorage.GcsInputChannel;
import com.google.appengine.tools.cloudstorage.GcsServiceFactory;
import com.google.appengine.tools.cloudstorage.RawGcsService;
import com.google.appengine.tools.cloudstorage.RetryHelper;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;

final class SimpleGcsInputChannelImpl
implements GcsInputChannel {
    private static final long serialVersionUID = -5076387489828467162L;
    private transient Object lock = new Object();
    private transient RawGcsService raw;
    private final GcsFilename filename;
    private long position;
    private boolean closed = false;
    private boolean eofHit = false;
    private final RetryParams retryParams;

    SimpleGcsInputChannelImpl(RawGcsService raw, GcsFilename filename, long startPosition, RetryParams retryParams) {
        this.raw = (RawGcsService)Preconditions.checkNotNull((Object)raw, (Object)"Null raw");
        this.filename = (GcsFilename)Preconditions.checkNotNull((Object)filename, (Object)"Null filename");
        Preconditions.checkArgument((startPosition >= 0L ? 1 : 0) != 0, (Object)"Start position cannot be negitive");
        this.position = startPosition;
        this.retryParams = retryParams;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.lock = new Object();
        this.raw = GcsServiceFactory.createRawGcsService();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int read(final ByteBuffer dst) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            if (this.eofHit) {
                return -1;
            }
            Preconditions.checkArgument((dst.remaining() > 0 ? 1 : 0) != 0, (Object)"Requested to read data into a full buffer");
            try {
                return RetryHelper.runWithRetries(new RetryHelper.Body<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        try {
                            int n = dst.remaining();
                            GcsFileMetadata gcsFileMetadata = SimpleGcsInputChannelImpl.this.raw.readObjectAsync(dst, SimpleGcsInputChannelImpl.this.filename, SimpleGcsInputChannelImpl.this.position, SimpleGcsInputChannelImpl.this.retryParams.getRequestTimeoutMillis()).get();
                            int r = n - dst.remaining();
                            SimpleGcsInputChannelImpl.this.position += r;
                            if (SimpleGcsInputChannelImpl.this.position >= gcsFileMetadata.getLength()) {
                                SimpleGcsInputChannelImpl.this.eofHit = true;
                            }
                            return r == 0 ? -1 : r;
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof BadRangeException) {
                                SimpleGcsInputChannelImpl.this.eofHit = true;
                                return -1;
                            }
                            if (e.getCause() instanceof IOException) {
                                throw (IOException)e.getCause();
                            }
                            throw new RuntimeException(this + ": Unexpected cause of ExecutionException", e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            SimpleGcsInputChannelImpl.this.closed = true;
                            throw new ClosedByInterruptException();
                        }
                    }
                }, this.retryParams);
            }
            catch (RetryHelper.RetryInteruptedException e) {
                Thread.currentThread().interrupt();
                this.closed = true;
                throw new ClosedByInterruptException();
            }
        }
    }
}

