/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import java.io.Serializable;

public class RetryParams
implements Serializable {
    private static final long serialVersionUID = -8492751576749007700L;
    public static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = 5000L;
    public static final int DEFAULT_RETRY_MIN_ATTEMPTS = 3;
    public static final int DEFAULT_RETRY_MAX_ATTEMPTS = 6;
    public static final long DEFAULT_INITIAL_RETRY_DELAY_MILLIS = 100L;
    public static final long DEFAULT_MAX_RETRY_DELAY_MILLIS = 10000L;
    public static final double DEFAULT_RETRY_DELAY_BACKOFF_FACTOR = 2.0;
    public static final long DEFAULT_TOTAL_RETRY_PERIOD_MILLIS = 30000L;
    private final long requestTimeoutMillis;
    private final int retryMinAttempts;
    private final int retryMaxAttempts;
    private final long initialRetryDelayMillis;
    private final long maxRetryDelayMillis;
    private final double retryDelayBackoffFactor;
    private final long totalRetryPeriodMillis;
    private static final RetryParams DEFAULT_INSTANCE = new RetryParams(new Builder());

    private RetryParams(Builder builder) {
        this.requestTimeoutMillis = builder.requestTimeoutMillis;
        this.retryMinAttempts = builder.retryMinAttempts;
        this.retryMaxAttempts = builder.retryMaxAttempts;
        this.initialRetryDelayMillis = builder.initialRetryDelayMillis;
        this.maxRetryDelayMillis = builder.maxRetryDelayMillis;
        this.retryDelayBackoffFactor = builder.retryDelayBackoffFactor;
        this.totalRetryPeriodMillis = builder.totalRetryPeriodMillis;
    }

    public static RetryParams getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public int getRetryMinAttempts() {
        return this.retryMinAttempts;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public long getInitialRetryDelayMillis() {
        return this.initialRetryDelayMillis;
    }

    public long getMaxRetryDelayMillis() {
        return this.maxRetryDelayMillis;
    }

    public double getRetryDelayBackoffFactor() {
        return this.retryDelayBackoffFactor;
    }

    public long getTotalRetryPeriodMillis() {
        return this.totalRetryPeriodMillis;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public static final class Builder {
        private long requestTimeoutMillis = 5000L;
        private int retryMinAttempts = 3;
        private int retryMaxAttempts = 6;
        private long initialRetryDelayMillis = 100L;
        private long maxRetryDelayMillis = 10000L;
        private double retryDelayBackoffFactor = 2.0;
        private long totalRetryPeriodMillis = 30000L;

        public Builder retryMinAttempts(int retryMinAttempts) {
            this.retryMinAttempts = retryMinAttempts;
            return this;
        }

        public Builder retryMaxAttempts(int retryMaxAttempts) {
            this.retryMaxAttempts = retryMaxAttempts;
            return this;
        }

        public Builder initialRetryDelayMillis(long initialRetryDelayMillis) {
            this.initialRetryDelayMillis = initialRetryDelayMillis;
            return this;
        }

        public Builder maxRetryDelayMillis(long maxRetryDelayMillis) {
            this.maxRetryDelayMillis = maxRetryDelayMillis;
            return this;
        }

        public Builder retryDelayBackoffFactor(double retryDelayBackoffFactor) {
            this.retryDelayBackoffFactor = retryDelayBackoffFactor;
            return this;
        }

        public Builder totalRetryPeriodMillis(long totalRetryPeriodMillis) {
            this.totalRetryPeriodMillis = totalRetryPeriodMillis;
            return this;
        }

        public Builder requestTimeoutMillis(long requestTimeoutMillis) {
            this.requestTimeoutMillis = requestTimeoutMillis;
            return this;
        }

        public RetryParams build() {
            return new RetryParams(this);
        }
    }
}

