/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.appengine.tools.cloudstorage.RetriesExhaustedException;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.apphosting.api.ApiProxy;
import com.google.common.base.Stopwatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class RetryHelper<V> {
    private static final Logger log = Logger.getLogger(RetryHelper.class.getName());
    private final Stopwatch stopwatch;
    private int attemptsSoFar = 0;
    private final Body<V> body;
    private final RetryParams retryParams;

    private static String messageChain(Throwable t) {
        StringBuilder resultMessage = new StringBuilder("" + t);
        for (t = t.getCause(); t != null; t = t.getCause()) {
            resultMessage.append("\n -- caused by: " + t);
        }
        return "" + resultMessage;
    }

    private RetryHelper(Body<V> body, RetryParams parms) {
        this(body, parms, new Stopwatch());
    }

    private RetryHelper(Body<V> body, RetryParams parms, Stopwatch stopwatch) {
        this.body = body;
        this.retryParams = parms;
        this.stopwatch = stopwatch;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.stopwatch + ", " + this.attemptsSoFar + " attempts, " + this.body + ")";
    }

    private V doRetry() throws IOException {
        this.stopwatch.start();
        while (true) {
            Throwable exception;
            ++this.attemptsSoFar;
            try {
                V value = this.body.run();
                if (this.attemptsSoFar > 1) {
                    log.info(this + ": retry successful");
                }
                return value;
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException || e instanceof MalformedURLException || e instanceof ClosedByInterruptException) {
                    throw e;
                }
                exception = e;
            }
            catch (ApiProxy.ApiProxyException e) {
                exception = e;
            }
            long sleepDurationMillis = RetryHelper.getSleepDuration(this.retryParams, this.attemptsSoFar);
            log.warning(this + ": Attempt " + this.attemptsSoFar + " failed, sleeping for " + sleepDurationMillis + " ms: " + RetryHelper.messageChain(exception));
            if (this.attemptsSoFar >= this.retryParams.getRetryMaxAttempts() || this.attemptsSoFar >= this.retryParams.getRetryMinAttempts() && this.stopwatch.elapsed(TimeUnit.MILLISECONDS) >= this.retryParams.getTotalRetryPeriodMillis()) {
                throw new RetriesExhaustedException(this + ": Too many failures, giving up", exception);
            }
            try {
                Thread.sleep(sleepDurationMillis);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new RetryInteruptedException();
            }
        }
    }

    static long getSleepDuration(RetryParams retryParams, int attemptsSoFar) {
        return (long)((Math.random() / 2.0 + 0.5) * Math.min((double)retryParams.getMaxRetryDelayMillis(), Math.pow(retryParams.getRetryDelayBackoffFactor(), attemptsSoFar - 1) * (double)retryParams.getInitialRetryDelayMillis()));
    }

    public static <V> V runWithRetries(Body<V> body) throws IOException {
        return super.doRetry();
    }

    public static <V> V runWithRetries(Body<V> body, RetryParams parms) throws IOException {
        return super.doRetry();
    }

    static <V> V runWithRetries(Body<V> body, RetryParams parms, Stopwatch stopwatch) throws IOException {
        return super.doRetry();
    }

    static class RetryInteruptedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        RetryInteruptedException() {
        }
    }

    static interface Body<V> {
        public V run() throws IOException;
    }
}

