/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.appengine.tools.cloudstorage.BadRangeException;
import com.google.appengine.tools.cloudstorage.GcsFileMetadata;
import com.google.appengine.tools.cloudstorage.GcsFilename;
import com.google.appengine.tools.cloudstorage.GcsInputChannel;
import com.google.appengine.tools.cloudstorage.GcsServiceFactory;
import com.google.appengine.tools.cloudstorage.RawGcsService;
import com.google.appengine.tools.cloudstorage.RetryHelper;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

final class PrefetchingGcsInputChannelImpl
implements GcsInputChannel {
    private static final long serialVersionUID = 5119437751884637172L;
    private static final Logger log = Logger.getLogger(PrefetchingGcsInputChannelImpl.class.getName());
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private transient Object lock = new Object();
    private transient RawGcsService raw;
    private final GcsFilename filename;
    private final int blockSizeBytes;
    private boolean closed = false;
    private transient boolean eofHit = false;
    private long readPosition;
    private long length = -1L;
    private transient long fetchPosition;
    private transient Future<GcsFileMetadata> pendingFetch = null;
    private transient ByteBuffer current = EMPTY_BUFFER;
    private transient ByteBuffer next;
    private final RetryParams retryParams;

    PrefetchingGcsInputChannelImpl(RawGcsService raw, GcsFilename filename, int blockSizeBytes, long startPosition, RetryParams retryParams) {
        this.raw = (RawGcsService)Preconditions.checkNotNull((Object)raw, (Object)"Null raw");
        this.filename = (GcsFilename)Preconditions.checkNotNull((Object)filename, (Object)"Null filename");
        Preconditions.checkArgument((blockSizeBytes >= 1024 ? 1 : 0) != 0, (Object)("Block size must be at least 1kb. Was: " + blockSizeBytes));
        this.blockSizeBytes = blockSizeBytes;
        this.retryParams = retryParams;
        Preconditions.checkArgument((startPosition >= 0L ? 1 : 0) != 0, (Object)"Start position cannot be negitive");
        this.readPosition = startPosition;
        this.fetchPosition = startPosition;
        this.next = ByteBuffer.allocate(blockSizeBytes);
        this.pendingFetch = raw.readObjectAsync(this.next, filename, this.fetchPosition, retryParams.getRequestTimeoutMillis());
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.lock = new Object();
        this.raw = GcsServiceFactory.createRawGcsService();
        this.fetchPosition = this.readPosition;
        this.current = EMPTY_BUFFER;
        boolean bl = this.eofHit = this.length != -1L && this.readPosition >= this.length;
        if (!this.closed) {
            this.next = ByteBuffer.allocate(this.blockSizeBytes);
            this.pendingFetch = this.raw.readObjectAsync(this.next, this.filename, this.fetchPosition, this.retryParams.getRequestTimeoutMillis());
        }
    }

    public String toString() {
        return "PrefetchingGcsInputChannelImpl [filename=" + this.filename + ", blockSizeBytes=" + this.blockSizeBytes + ", closed=" + this.closed + ", eofHit=" + this.eofHit + ", length=" + this.length + ", fetchPosition=" + this.fetchPosition + ", pendingFetch=" + this.pendingFetch + ", retryParams=" + this.retryParams + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
        }
    }

    private void waitForFetchWithRetry() throws IOException {
        try {
            RetryHelper.runWithRetries(new RetryHelper.Body<Void>(){

                @Override
                public Void run() throws IOException {
                    PrefetchingGcsInputChannelImpl.this.waitForFetch();
                    return null;
                }
            }, this.retryParams);
        }
        catch (RetryHelper.RetryInteruptedException e) {
            this.closed = true;
            throw new ClosedByInterruptException();
        }
    }

    private void waitForFetch() throws IOException {
        Preconditions.checkState((this.pendingFetch != null ? 1 : 0) != 0, (String)"%s: no fetch pending", (Object[])new Object[]{this});
        Preconditions.checkState((!this.current.hasRemaining() ? 1 : 0) != 0, (String)"%s: current has remaining", (Object[])new Object[]{this});
        try {
            GcsFileMetadata gcsFileMetadata = this.pendingFetch.get();
            this.flipToNextBlockAndPrefetch(gcsFileMetadata.getLength());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BadRangeException) {
                this.eofHit = true;
                this.current = EMPTY_BUFFER;
                this.next = null;
                this.pendingFetch = null;
            }
            if (e.getCause() instanceof FileNotFoundException) {
                FileNotFoundException toThrow = new FileNotFoundException(e.getMessage());
                toThrow.initCause(e);
                throw toThrow;
            }
            if (e.getCause() instanceof IOException) {
                log.log(Level.WARNING, this + ": IOException fetching block", e);
                this.next = ByteBuffer.allocate(this.blockSizeBytes);
                this.pendingFetch = this.raw.readObjectAsync(this.next, this.filename, this.fetchPosition, this.retryParams.getRequestTimeoutMillis());
                throw new IOException(this + ": Prefetch failed, prefetching again", e);
            }
            throw new RuntimeException(this + ": Unexpected cause of ExecutionException", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.closed = true;
            throw new ClosedByInterruptException();
        }
    }

    private void flipToNextBlockAndPrefetch(long contentLength) {
        Preconditions.checkState((this.next != null ? 1 : 0) != 0, (String)"%s: no next", (Object[])new Object[]{this});
        this.current = this.next;
        this.current.flip();
        this.fetchPosition += (long)this.blockSizeBytes;
        if (this.length == -1L) {
            this.length = contentLength;
        } else if (contentLength != this.length) {
            this.eofHit = true;
            this.next = null;
            this.pendingFetch = null;
            throw new RuntimeException("Contents of file: " + this.filename + " changed while being read.");
        }
        if (this.fetchPosition >= contentLength) {
            this.eofHit = true;
            this.next = null;
            this.pendingFetch = null;
        } else {
            this.next = ByteBuffer.allocate(this.blockSizeBytes);
            this.pendingFetch = this.raw.readObjectAsync(this.next, this.filename, this.fetchPosition, this.retryParams.getRequestTimeoutMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            if (this.eofHit && !this.current.hasRemaining()) {
                return -1;
            }
            Preconditions.checkArgument((dst.remaining() > 0 ? 1 : 0) != 0, (Object)"Requested to read data into a full buffer");
            if (!this.current.hasRemaining()) {
                this.waitForFetchWithRetry();
                if (this.eofHit && !this.current.hasRemaining()) {
                    return -1;
                }
            }
            Preconditions.checkState((boolean)this.current.hasRemaining(), (String)"%s: no remaining after wait", (Object[])new Object[]{this});
            int toRead = dst.remaining();
            if (this.current.remaining() <= toRead) {
                dst.put(this.current);
                if (this.pendingFetch != null && this.pendingFetch.isDone()) {
                    this.waitForFetchWithRetry();
                }
                this.readPosition += (long)(toRead - dst.remaining());
                return toRead - dst.remaining();
            }
            int oldLimit = this.current.limit();
            this.current.limit(this.current.position() + toRead);
            dst.put(this.current);
            this.current.limit(oldLimit);
            this.readPosition += (long)toRead;
            return toRead;
        }
    }
}

