/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.appengine.tools.cloudstorage.GcsFileMetadata;
import com.google.appengine.tools.cloudstorage.GcsFileOptions;
import com.google.appengine.tools.cloudstorage.GcsFilename;
import com.google.appengine.tools.cloudstorage.GcsInputChannel;
import com.google.appengine.tools.cloudstorage.GcsOutputChannel;
import com.google.appengine.tools.cloudstorage.GcsOutputChannelImpl;
import com.google.appengine.tools.cloudstorage.GcsService;
import com.google.appengine.tools.cloudstorage.PrefetchingGcsInputChannelImpl;
import com.google.appengine.tools.cloudstorage.RawGcsService;
import com.google.appengine.tools.cloudstorage.RetryHelper;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.appengine.tools.cloudstorage.SimpleGcsInputChannelImpl;
import com.google.common.base.Preconditions;
import java.io.IOException;

final class GcsServiceImpl
implements GcsService {
    private final RawGcsService raw;
    private final RetryParams retryParams;

    GcsServiceImpl(RawGcsService raw, RetryParams retryParams) {
        this.raw = (RawGcsService)Preconditions.checkNotNull((Object)raw, (Object)"Null raw");
        this.retryParams = retryParams;
    }

    public String toString() {
        return "GcsServiceImpl [retryParams=" + this.retryParams + "]";
    }

    @Override
    public GcsOutputChannel createOrReplace(final GcsFilename filename, final GcsFileOptions options) throws IOException {
        RawGcsService.RawGcsCreationToken token = RetryHelper.runWithRetries(new RetryHelper.Body<RawGcsService.RawGcsCreationToken>(){

            @Override
            public RawGcsService.RawGcsCreationToken run() throws IOException {
                return GcsServiceImpl.this.raw.beginObjectCreation(filename, options, GcsServiceImpl.this.retryParams.getRequestTimeoutMillis());
            }
        }, this.retryParams);
        return new GcsOutputChannelImpl(this.raw, token, this.retryParams);
    }

    @Override
    public GcsInputChannel openReadChannel(GcsFilename filename, long startPosition) {
        return new SimpleGcsInputChannelImpl(this.raw, filename, startPosition, this.retryParams);
    }

    @Override
    public GcsInputChannel openPrefetchingReadChannel(GcsFilename filename, long startPosition, int blockSize) {
        return new PrefetchingGcsInputChannelImpl(this.raw, filename, blockSize, startPosition, this.retryParams);
    }

    @Override
    public GcsFileMetadata getMetadata(final GcsFilename filename) throws IOException {
        return RetryHelper.runWithRetries(new RetryHelper.Body<GcsFileMetadata>(){

            @Override
            public GcsFileMetadata run() throws IOException {
                return GcsServiceImpl.this.raw.getObjectMetadata(filename, GcsServiceImpl.this.retryParams.getRequestTimeoutMillis());
            }
        }, this.retryParams);
    }

    @Override
    public boolean delete(final GcsFilename filename) throws IOException {
        return RetryHelper.runWithRetries(new RetryHelper.Body<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                return GcsServiceImpl.this.raw.deleteObject(filename, GcsServiceImpl.this.retryParams.getRequestTimeoutMillis());
            }
        }, this.retryParams);
    }
}

