/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.tools.cloudstorage.GcsService;
import com.google.appengine.tools.cloudstorage.GcsServiceImpl;
import com.google.appengine.tools.cloudstorage.RawGcsService;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.appengine.tools.cloudstorage.dev.LocalRawGcsServiceFactory;
import com.google.appengine.tools.cloudstorage.oauth.OauthRawGcsServiceFactory;

public final class GcsServiceFactory {
    private GcsServiceFactory() {
    }

    public static GcsService createGcsService(RetryParams params) {
        RawGcsService rawGcsService = GcsServiceFactory.createRawGcsService();
        return new GcsServiceImpl(rawGcsService, params);
    }

    static RawGcsService createRawGcsService() {
        RawGcsService rawGcsService = SystemProperty.environment.value() == SystemProperty.Environment.Value.Production ? OauthRawGcsServiceFactory.createOauthRawGcsService() : LocalRawGcsServiceFactory.createLocalRawGcsService();
        return rawGcsService;
    }

    public static GcsService createGcsService() {
        return GcsServiceFactory.createGcsService(RetryParams.getDefaultInstance());
    }
}

