/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.appengine.tools.cloudstorage.GcsFilename;
import com.google.appengine.tools.cloudstorage.GcsOutputChannel;
import com.google.appengine.tools.cloudstorage.GcsServiceFactory;
import com.google.appengine.tools.cloudstorage.RawGcsService;
import com.google.appengine.tools.cloudstorage.RetryHelper;
import com.google.appengine.tools.cloudstorage.RetryParams;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Logger;

final class GcsOutputChannelImpl
implements GcsOutputChannel,
Serializable {
    private static final long serialVersionUID = 3011935384698648440L;
    private static final Logger log = Logger.getLogger(GcsOutputChannelImpl.class.getName());
    private transient Object lock = new Object();
    private transient ByteBuffer buf;
    private transient RawGcsService raw;
    private RawGcsService.RawGcsCreationToken token;
    private final GcsFilename filename;
    private RetryParams retryParams;

    GcsOutputChannelImpl(RawGcsService raw, RawGcsService.RawGcsCreationToken nextToken, RetryParams retryParams) {
        this.retryParams = retryParams;
        this.raw = (RawGcsService)Preconditions.checkNotNull((Object)raw, (Object)"Null raw");
        this.buf = ByteBuffer.allocate(GcsOutputChannelImpl.getBufferSize(raw.getChunkSizeBytes()));
        this.token = (RawGcsService.RawGcsCreationToken)Preconditions.checkNotNull((Object)nextToken, (Object)"Null token");
        this.filename = nextToken.getFilename();
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.lock = new Object();
        this.raw = GcsServiceFactory.createRawGcsService();
        if (this.token != null) {
            this.buf = ByteBuffer.allocate(GcsOutputChannelImpl.getBufferSize(this.raw.getChunkSizeBytes()));
            int length = aInputStream.readInt();
            if (length > this.buf.capacity()) {
                throw new IllegalArgumentException("Size of buffer is smaller than initial contents: " + length);
            }
            if (length > 0) {
                byte[] initialBuffer = new byte[length];
                for (int pos = 0; pos < length; pos += aInputStream.read(initialBuffer, pos, length - pos)) {
                }
                this.buf.put(initialBuffer);
            }
        }
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
        int length = this.buf == null ? 0 : this.buf.position();
        aOutputStream.writeInt(length);
        if (length > 0 && this.isOpen()) {
            this.buf.rewind();
            byte[] toWrite = new byte[length];
            this.buf.get(toWrite);
            aOutputStream.write(toWrite);
        }
    }

    @VisibleForTesting
    static int getBufferSize(int chunkSize) {
        if (chunkSize <= 262144) {
            return 8 * chunkSize;
        }
        if (chunkSize <= 0x100000) {
            return 2 * chunkSize;
        }
        return chunkSize;
    }

    @Override
    public int getBufferSizeBytes() {
        if (this.buf == null) {
            return GcsOutputChannelImpl.getBufferSize(this.raw.getChunkSizeBytes());
        }
        return this.buf.capacity();
    }

    public String toString() {
        return "GcsOutputChannelImpl [token=" + this.token + ", filename=" + this.filename + ", retryParams=" + this.retryParams + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.token != null;
        }
    }

    @Override
    public GcsFilename getFilename() {
        return this.filename;
    }

    private ByteBuffer getSliceForWrite() {
        int oldPos = this.buf.position();
        this.buf.flip();
        ByteBuffer out = this.buf.slice();
        this.buf.limit(this.buf.capacity());
        this.buf.position(oldPos);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
            final ByteBuffer out = this.getSliceForWrite();
            RetryHelper.runWithRetries(new RetryHelper.Body<Void>(){

                @Override
                public Void run() throws IOException {
                    GcsOutputChannelImpl.this.raw.finishObjectCreation(GcsOutputChannelImpl.this.token, out, GcsOutputChannelImpl.this.retryParams.getRequestTimeoutMillis());
                    return null;
                }
            }, this.retryParams);
            this.token = null;
        }
    }

    private void flushIfNeeded() throws IOException {
        if (!this.buf.hasRemaining()) {
            this.writeOut(this.getSliceForWrite());
            this.buf.clear();
        }
    }

    void writeOut(final ByteBuffer toWrite) throws IOException, ClosedByInterruptException {
        try {
            this.token = RetryHelper.runWithRetries(new RetryHelper.Body<RawGcsService.RawGcsCreationToken>(){

                @Override
                public RawGcsService.RawGcsCreationToken run() throws IOException {
                    return GcsOutputChannelImpl.this.raw.continueObjectCreation(GcsOutputChannelImpl.this.token, toWrite, GcsOutputChannelImpl.this.retryParams.getRequestTimeoutMillis());
                }
            }, this.retryParams);
        }
        catch (ClosedByInterruptException e) {
            this.token = null;
            throw new ClosedByInterruptException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer in) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int inBufferSize = in.remaining();
            while (in.hasRemaining()) {
                this.flushIfNeeded();
                Preconditions.checkState((boolean)this.buf.hasRemaining(), (String)"%s: %s", (Object[])new Object[]{this, this.buf});
                int numBytesToCopyToBuffer = Math.min(this.buf.remaining(), in.remaining());
                int oldLimit = in.limit();
                in.limit(in.position() + numBytesToCopyToBuffer);
                this.buf.put(in);
                in.limit(oldLimit);
            }
            this.flushIfNeeded();
            return inBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForOutstandingWrites() throws ClosedByInterruptException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
            int chunkSize = this.raw.getChunkSizeBytes();
            int position = this.buf.position();
            int bytesToWrite = position / chunkSize * chunkSize;
            if (bytesToWrite > 0) {
                ByteBuffer outputBuffer = this.getSliceForWrite();
                outputBuffer.limit(bytesToWrite);
                this.writeOut(outputBuffer);
                this.buf.position(bytesToWrite);
                this.buf.limit(position);
                ByteBuffer remaining = this.buf.slice();
                this.buf.clear();
                this.buf.put(remaining);
            }
        }
    }
}

