/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class GcsFileOptions
implements Serializable {
    private static final long serialVersionUID = -7350111525144535653L;
    private final String mimeType;
    private final String acl;
    private final String cacheControl;
    private final String contentEncoding;
    private final String contentDisposition;
    private final ImmutableMap<String, String> userMetadata;
    private static final GcsFileOptions DEFAULT_INSTANCE = new GcsFileOptions(new Builder());

    private GcsFileOptions(Builder builder) {
        this.mimeType = builder.mimeType;
        this.acl = builder.acl;
        this.cacheControl = builder.cacheControl;
        this.contentEncoding = builder.contentEncoding;
        this.contentDisposition = builder.contentDisposition;
        this.userMetadata = ImmutableMap.copyOf((Map)builder.userMetadata);
    }

    public static GcsFileOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getAcl() {
        return this.acl;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public String toString() {
        return "GcsFileOptions [" + (this.mimeType != null ? "mimeType=" + this.mimeType + ", " : "") + (this.acl != null ? "acl=" + this.acl + ", " : "") + (this.cacheControl != null ? "cacheControl=" + this.cacheControl + ", " : "") + (this.contentEncoding != null ? "contentEncoding=" + this.contentEncoding + ", " : "") + (this.contentDisposition != null ? "contentDisposition=" + this.contentDisposition + ", " : "") + (this.userMetadata != null ? "userMetadata=" + this.userMetadata : "") + "]";
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcsFileOptions other = (GcsFileOptions)o;
        return Objects.equal((Object)this.mimeType, (Object)other.mimeType) && Objects.equal((Object)this.acl, (Object)other.acl) && Objects.equal((Object)this.cacheControl, (Object)other.cacheControl) && Objects.equal((Object)this.contentEncoding, (Object)other.contentEncoding) && Objects.equal((Object)this.contentDisposition, (Object)other.contentDisposition) && Objects.equal(this.userMetadata, other.userMetadata);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mimeType, this.acl, this.cacheControl, this.contentEncoding, this.contentDisposition, this.userMetadata});
    }

    public static final class Builder {
        private String mimeType;
        private String acl;
        private String cacheControl;
        private String contentEncoding;
        private String contentDisposition;
        private final Map<String, String> userMetadata = new HashMap<String, String>();

        public Builder mimeType(String mimeType) {
            this.mimeType = Builder.checkNotEmpty(mimeType, "MIME type");
            return this;
        }

        public Builder acl(String acl) {
            this.acl = Builder.checkNotEmpty(acl, "ACL");
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = Builder.checkNotEmpty(cacheControl, "cache control");
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = Builder.checkNotEmpty(contentEncoding, "content encoding");
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = Builder.checkNotEmpty(contentDisposition, "content disposition");
            return this;
        }

        public Builder addUserMetadata(String key, String value) {
            Builder.checkNotEmpty(key, "key");
            Builder.checkNotEmpty(value, "value");
            this.userMetadata.put(key, value);
            return this;
        }

        private static String checkNotEmpty(String value, String what) {
            Preconditions.checkNotNull((Object)value, (String)"Null %s", (Object[])new Object[]{what});
            Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (String)"Empty %s", (Object[])new Object[]{what});
            return value;
        }

        public GcsFileOptions build() {
            return new GcsFileOptions(this);
        }
    }
}

