/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.cloudstorage;

import com.google.appengine.tools.cloudstorage.GcsFileOptions;
import com.google.appengine.tools.cloudstorage.GcsFilename;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class GcsFileMetadata {
    private final GcsFilename filename;
    private final GcsFileOptions options;
    private final String etag;
    private final long length;

    public GcsFileMetadata(GcsFilename filename, GcsFileOptions options, String etag, long length) {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"Length must be positive");
        this.filename = (GcsFilename)Preconditions.checkNotNull((Object)filename, (Object)"Null filename");
        this.options = (GcsFileOptions)Preconditions.checkNotNull((Object)options, (Object)"Null options");
        this.etag = etag;
        this.length = length;
    }

    public GcsFilename getFilename() {
        return this.filename;
    }

    public GcsFileOptions getOptions() {
        return this.options;
    }

    public String getEtag() {
        return this.etag;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.filename + ", " + this.length + ", " + this.etag + ", " + this.options + ")";
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcsFileMetadata other = (GcsFileMetadata)o;
        return this.length == other.length && Objects.equal((Object)this.filename, (Object)other.filename) && Objects.equal((Object)this.etag, (Object)other.etag) && Objects.equal((Object)this.options, (Object)other.options);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.filename, this.options, this.etag, this.length});
    }
}

