/*
 * Copyright 2012 Google Inc. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.appengine.tools.cloudstorage.dev;

import com.google.appengine.tools.cloudstorage.RawGcsService;

/**
 * Creates a RawGcsService for use in-process. This is useful for testing.
 */
public final class LocalRawGcsServiceFactory {

  private LocalRawGcsServiceFactory() {}
  
  public static RawGcsService createLocalRawGcsService() {
    return new LocalRawGcsService();
  }
  
}
