/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2LaxPolygonShape;
import com.google.appengine.repackaged.com.google.common.geometry.S2LaxPolylineShape;
import com.google.appengine.repackaged.com.google.common.geometry.S2Loop;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible
public strictfp class S2TextFormat {
    public static S2Point makePointOrDie(String str) {
        S2Point point = S2TextFormat.makePoint(str);
        Preconditions.checkState((null != point ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return point;
    }

    @Nullable
    public static S2Point makePoint(String str) {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        if (vertices == null || vertices.size() != 1) {
            return null;
        }
        return vertices.get(0);
    }

    public static List<S2LatLng> parseLatLngsOrDie(String str) {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        Preconditions.checkState((latlngs != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return latlngs;
    }

    @Nullable
    static List<S2LatLng> parseLatLngs(String str) {
        List<ParseEntry> ps = S2TextFormat.dictionaryParse(str);
        if (ps == null) {
            return null;
        }
        ArrayList<S2LatLng> latlngs = new ArrayList<S2LatLng>();
        for (ParseEntry p : ps) {
            Double lat = Double.parseDouble(p.key);
            if (lat == null) {
                return null;
            }
            Double lng = Double.parseDouble(p.value);
            if (lng == null) {
                return null;
            }
            latlngs.add(S2LatLng.fromDegrees(lat, lng));
        }
        return latlngs;
    }

    public static List<S2Point> parsePointsOrDie(String str) {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        Preconditions.checkState((vertices != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return vertices;
    }

    @Nullable
    public static List<S2Point> parsePoints(String str) {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        if (latlngs == null) {
            return null;
        }
        ArrayList<S2Point> vertices = new ArrayList<S2Point>();
        for (S2LatLng latlng : latlngs) {
            vertices.add(latlng.toPoint());
        }
        return vertices;
    }

    public static S2LatLng makeLatLngOrDie(String str) {
        S2LatLng latlng = S2TextFormat.makeLatLng(str);
        Preconditions.checkState((null != latlng ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return latlng;
    }

    @Nullable
    public static S2LatLng makeLatLng(String str) {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        if (null == latlngs || latlngs.size() != 1) {
            return null;
        }
        return latlngs.get(0);
    }

    S2LatLngRect makeLatLngRectOrDie(String str) {
        S2LatLngRect rect = S2TextFormat.makeLatLngRect(str);
        Preconditions.checkState((null != rect ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return rect;
    }

    @Nullable
    public static S2LatLngRect makeLatLngRect(String str) {
        List<S2LatLng> latlngs = S2TextFormat.parseLatLngs(str);
        if (null == latlngs || latlngs.isEmpty()) {
            return null;
        }
        S2LatLngRect rect = S2LatLngRect.fromPoint(latlngs.get(0));
        for (int i = 1; i < latlngs.size(); ++i) {
            rect = rect.addPoint(latlngs.get(i));
        }
        return rect;
    }

    public static S2CellId makeCellIdOrDie(String str) {
        S2CellId cellId = S2TextFormat.makeCellId(str);
        Preconditions.checkState((null != cellId ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return cellId;
    }

    @Nullable
    public static S2CellId makeCellId(String str) {
        S2CellId cellId = S2CellId.fromDebugString(str);
        if (cellId.equals(S2CellId.none())) {
            return null;
        }
        return cellId;
    }

    public static S2CellUnion makeCellUnionOrDie(String str) {
        S2CellUnion cellUnion = S2TextFormat.makeCellUnion(str);
        Preconditions.checkState((null != cellUnion ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return cellUnion;
    }

    @Nullable
    public static S2CellUnion makeCellUnion(String str) {
        ArrayList<S2CellId> cellIds = new ArrayList<S2CellId>();
        for (String cellStr : S2TextFormat.splitString(str, ",")) {
            S2CellId cellId = S2TextFormat.makeCellId(cellStr = cellStr.trim());
            if (null == cellId) {
                return null;
            }
            cellIds.add(cellId);
        }
        S2CellUnion cellUnion = new S2CellUnion();
        cellUnion.initFromCellIds(cellIds);
        return cellUnion;
    }

    public static S2Loop makeLoopOrDie(String str) {
        S2Loop loop = S2TextFormat.makeLoop(str);
        Preconditions.checkState((loop != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return loop;
    }

    @Nullable
    public static S2Loop makeLoop(String str) {
        if (str.equals("empty")) {
            return S2Loop.empty();
        }
        if (str.equals("full")) {
            return S2Loop.full();
        }
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        if (vertices == null) {
            return null;
        }
        return new S2Loop(vertices);
    }

    public static S2Polyline makePolylineOrDie(String str) {
        S2Polyline polyline = S2TextFormat.makePolyline(str);
        Preconditions.checkState((null != polyline ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return polyline;
    }

    @Nullable
    public static S2Polyline makePolyline(String str) {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        if (null == vertices) {
            return null;
        }
        return new S2Polyline(vertices);
    }

    @GwtIncompatible(value="S2LaxPolylineShape")
    public static S2LaxPolylineShape makeLaxPolylineOrDie(String str) {
        S2LaxPolylineShape laxPolyline = S2TextFormat.makeLaxPolyline(str);
        Preconditions.checkState((null != laxPolyline ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return laxPolyline;
    }

    @Nullable
    @GwtIncompatible(value="S2LaxPolylineShape")
    public static S2LaxPolylineShape makeLaxPolyline(String str) {
        List<S2Point> vertices = S2TextFormat.parsePoints(str);
        if (null == vertices) {
            return null;
        }
        return S2LaxPolylineShape.create(vertices);
    }

    public static S2Polygon makePolygonOrDie(String str) {
        S2Polygon polygon = S2TextFormat.makePolygon(str);
        Preconditions.checkState((polygon != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return polygon;
    }

    @Nullable
    public static S2Polygon makePolygon(String str) {
        return S2TextFormat.internalMakePolygon(str, true);
    }

    public static S2Polygon makeVerbatimPolygonOrDie(String str) {
        S2Polygon polygon = S2TextFormat.makeVerbatimPolygon(str);
        Preconditions.checkState((polygon != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return polygon;
    }

    @Nullable
    public static S2Polygon makeVerbatimPolygon(String str) {
        return S2TextFormat.internalMakePolygon(str, false);
    }

    @GwtIncompatible(value="S2LaxPolygonShape")
    public static S2LaxPolygonShape makeLaxPolygonOrDie(String str) {
        S2LaxPolygonShape laxPolygon = S2TextFormat.makeLaxPolygon(str);
        Preconditions.checkState((null != laxPolygon ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return laxPolygon;
    }

    @Nullable
    @GwtIncompatible(value="S2LaxPolygonShape")
    public static S2LaxPolygonShape makeLaxPolygon(String str) {
        List<String> loopStrs = S2TextFormat.splitString(str, ";");
        ArrayList<List<Object>> loops = new ArrayList<List<Object>>();
        for (String loopStr : loopStrs) {
            if (loopStr.equals("full")) {
                loops.add(new ArrayList());
                continue;
            }
            if (loopStr.equals("empty")) continue;
            List<S2Point> points = S2TextFormat.parsePoints(loopStr);
            if (null == points) {
                return null;
            }
            loops.add(points);
        }
        return S2LaxPolygonShape.create(loops);
    }

    @GwtIncompatible(value="S2LaxPolylineShape, S2LaxPolygonShape")
    public static S2ShapeIndex makeIndexOrDie(String str) {
        S2ShapeIndex index = S2TextFormat.makeIndex(str);
        Preconditions.checkState((index != null ? 1 : 0) != 0, (String)": str == \"%s\"", (Object)str);
        return index;
    }

    @Nullable
    @GwtIncompatible(value="S2LaxPolylineShape, S2LaxPolygonShape")
    public static S2ShapeIndex makeIndex(String str) {
        String[] strs = str.split("#", -1);
        if (strs.length != 3) {
            return null;
        }
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        for (String pointStr : S2TextFormat.splitString(strs[0], "\\|")) {
            S2Point point = S2TextFormat.makePoint(pointStr);
            if (point == null) {
                return null;
            }
            points.add(point);
        }
        S2ShapeIndex index = new S2ShapeIndex();
        if (!points.isEmpty()) {
            index.add(S2Point.Shape.fromList(points));
        }
        for (String lineStr : S2TextFormat.splitString(strs[1], "\\|")) {
            S2LaxPolylineShape laxPolyline = S2TextFormat.makeLaxPolyline(lineStr);
            if (laxPolyline == null) {
                return null;
            }
            index.add(laxPolyline);
        }
        for (String polygonStr : S2TextFormat.splitString(strs[2], "\\|")) {
            S2LaxPolygonShape laxPolygon = S2TextFormat.makeLaxPolygon(polygonStr);
            if (laxPolygon == null) {
                return null;
            }
            index.add(laxPolygon);
        }
        return index;
    }

    public static String toString(S2Point s2Point) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertex(s2Point, out);
        return out.toString();
    }

    public static String toString(S2LatLng latlng) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertex(latlng, out);
        return out.toString();
    }

    public static String toString(S2LatLngRect rect) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertex(rect.lo(), out);
        out.append(", ");
        S2TextFormat.appendVertex(rect.hi(), out);
        return out.toString();
    }

    public static String toString(S2CellId cellId) {
        return cellId.toString();
    }

    public static String toString(S2CellUnion cellUnion) {
        StringBuilder out = new StringBuilder();
        for (S2CellId cellId : cellUnion) {
            if (out.length() > 0) {
                out.append(", ");
            }
            out.append(cellId.toString());
        }
        return out.toString();
    }

    public static String toString(S2Loop loop) {
        if (loop.isEmpty()) {
            return "empty";
        }
        if (loop.isFull()) {
            return "full";
        }
        StringBuilder out = new StringBuilder();
        if (loop.numVertices() > 0) {
            S2TextFormat.appendVertices(loop.vertices(), out);
        }
        return out.toString();
    }

    public static String toString(S2Polyline polyline) {
        StringBuilder out = new StringBuilder();
        if (polyline.numVertices() > 0) {
            S2TextFormat.appendVertices(polyline.vertices(), out);
        }
        return out.toString();
    }

    public static String toString(S2Polygon polygon) {
        return S2TextFormat.toString(polygon, ";\n");
    }

    public static String toString(S2Polygon polygon, String loopSeparator) {
        if (polygon.isEmpty()) {
            return "empty";
        }
        if (polygon.isFull()) {
            return "full";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < polygon.numLoops(); ++i) {
            if (i > 0) {
                out.append(loopSeparator);
            }
            S2TextFormat.appendVertices(polygon.loop(i).vertices(), out);
        }
        return out.toString();
    }

    public static String s2PointsToString(List<S2Point> points) {
        StringBuilder out = new StringBuilder();
        S2TextFormat.appendVertices(points, out);
        return out.toString();
    }

    public static String s2LatLngsToString(List<S2LatLng> latlngs) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < latlngs.size(); ++i) {
            if (i > 0) {
                out.append(", ");
            }
            S2TextFormat.appendVertex(latlngs.get(i), out);
        }
        return out.toString();
    }

    @GwtIncompatible(value="S2LaxPolylineShape, S2LaxPolygonShape")
    public static String toString(S2LaxPolylineShape polyline) {
        StringBuilder out = new StringBuilder();
        if (polyline.numVertices() > 0) {
            S2TextFormat.appendVertices(polyline.vertices(), out);
        }
        return out.toString();
    }

    @GwtIncompatible(value="S2LaxPolylineShape, S2LaxPolygonShape")
    public static String toString(S2LaxPolygonShape polygon) {
        return S2TextFormat.toString(polygon, ";\n");
    }

    @GwtIncompatible(value="S2LaxPolylineShape, S2LaxPolygonShape")
    public static String toString(S2LaxPolygonShape polygon, String loopSeparator) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < polygon.numChains(); ++i) {
            int chainLength;
            if (i > 0) {
                out.append(loopSeparator);
            }
            if ((chainLength = polygon.getChainLength(i)) == 0) {
                out.append("full");
                continue;
            }
            for (int edgeOffset = 0; edgeOffset < chainLength; ++edgeOffset) {
                S2TextFormat.appendVertex(polygon.getChainVertex(i, edgeOffset), out);
                if (edgeOffset >= chainLength - 1) continue;
                out.append(", ");
            }
        }
        return out.toString();
    }

    public static String toString(S2ShapeIndex index) {
        StringBuilder out = new StringBuilder();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (int dim = 0; dim < 3; ++dim) {
            if (dim > 0) {
                out.append("#");
            }
            int count = 0;
            for (S2Shape shape : index.getShapes()) {
                if (shape == null || shape.dimension() != dim) continue;
                out.append(count > 0 ? " | " : (dim > 0 ? " " : ""));
                int i = 0;
                while (i < shape.numChains()) {
                    if (i > 0) {
                        out.append(dim == 2 ? "; " : " | ");
                    }
                    if (shape.getChainLength(i) == 0) {
                        out.append("full");
                    } else {
                        shape.getChainEdge(i, 0, edge);
                        S2TextFormat.appendVertex(edge.getStart(), out);
                    }
                    int limit = shape.getChainLength(i);
                    if (dim != 1) {
                        --limit;
                    }
                    for (int edgeOffset = 0; edgeOffset < limit; ++edgeOffset) {
                        out.append(", ");
                        shape.getChainEdge(i, edgeOffset, edge);
                        S2TextFormat.appendVertex(edge.getEnd(), out);
                    }
                    ++i;
                    ++count;
                }
            }
            if (dim != 1 && (dim != 0 || count <= 0)) continue;
            out.append(" ");
        }
        return out.toString();
    }

    private static List<String> splitString(String str, String regexp) {
        String[] parts = str.split(regexp);
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            if (part.trim().isEmpty()) continue;
            result.add(part.trim());
        }
        return result;
    }

    @Nullable
    private static List<ParseEntry> dictionaryParse(String str) {
        String[] entries;
        ArrayList<ParseEntry> items = new ArrayList<ParseEntry>();
        for (String entry : entries = str.split(",", -1)) {
            if (entry.trim().isEmpty()) continue;
            String[] fields = entry.split(":", -1);
            if (fields.length != 2) {
                return null;
            }
            items.add(new ParseEntry(fields[0], fields[1]));
        }
        return items;
    }

    @Nullable
    private static S2Polygon internalMakePolygon(String str, boolean normalizeLoops) {
        if (str.equals("empty")) {
            return new S2Polygon(new ArrayList<S2Loop>());
        }
        List<String> loopStrs = S2TextFormat.splitString(str, ";");
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
        for (String loopStr : loopStrs) {
            S2Loop loop = S2TextFormat.makeLoop(loopStr);
            if (loop == null) {
                return null;
            }
            if (normalizeLoops && !loop.isFull()) {
                loop.normalize();
            }
            loops.add(loop);
        }
        return new S2Polygon(loops);
    }

    private static void appendVertex(S2LatLng ll, StringBuilder out) {
        out.append(Platform.formatDouble(ll.latDegrees())).append(':').append(Platform.formatDouble(ll.lngDegrees()));
    }

    private static void appendVertex(S2Point p, StringBuilder out) {
        S2TextFormat.appendVertex(new S2LatLng(p), out);
    }

    private static void appendVertices(Iterable<S2Point> points, StringBuilder out) {
        Iterator<S2Point> i = points.iterator();
        while (i.hasNext()) {
            S2TextFormat.appendVertex(i.next(), out);
            if (!i.hasNext()) continue;
            out.append(", ");
        }
    }

    private strictfp static class ParseEntry {
        public String key;
        public String value;

        public ParseEntry(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

