/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.datastore.dev.PseudoKind;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

class EntityGroupPseudoKind
implements PseudoKind {
    private final long baseVersion = System.currentTimeMillis() * 1000L;

    EntityGroupPseudoKind() {
    }

    @Override
    public String getKindName() {
        return "__entity_group__";
    }

    @Override
    public List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query) {
        Utils.checkRequest(false, "queries not supported on __entity_group__");
        return null;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto get(@Nullable LocalDatastoreService.LiveTxn txn, LocalDatastoreService.Profile.EntityGroup eg, OnestoreEntity.Reference key, boolean eventualConsistency) {
        OnestoreEntity.Path path = key.getPath();
        if (path.elementSize() != 2 || path.getElement(1).getId() != 1L) {
            return null;
        }
        long version = txn == null ? eg.getVersion() : txn.trackEntityGroup(eg).getEntityGroupVersion().longValue();
        return EntityGroupPseudoKind.makeEntityGroupEntity(key, version + this.baseVersion);
    }

    private static OnestoreEntity.EntityProto makeEntityGroupEntity(OnestoreEntity.Reference key, long version) {
        OnestoreEntity.EntityProto egEntity = new OnestoreEntity.EntityProto().setKey(key);
        egEntity.getMutableEntityGroup().addElement(key.getPath().getElement(0));
        OnestoreEntity.PropertyValue value = new OnestoreEntity.PropertyValue().setInt64Value(version);
        egEntity.addProperty().setMultiple(false).setName("__version__").setValue(value);
        return egEntity;
    }
}

