/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AbstractIterator;
import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.BaseDatastoreServiceImpl;
import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PostDeleteFuture;
import com.google.appengine.api.datastore.PostLoadFuture;
import com.google.appengine.api.datastore.PostPutFuture;
import com.google.appengine.api.datastore.PreGetContext;
import com.google.appengine.api.datastore.PreQueryContext;
import com.google.appengine.api.datastore.PreparedMultiQuery;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PreparedQueryImpl;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitHelper;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;

class AsyncDatastoreServiceImpl
extends BaseDatastoreServiceImpl
implements AsyncDatastoreService,
CurrentTransactionProvider {
    static final EntityGroupGrouper<IndexedItem<Entity>> ENTITY_GROUPER = new EntityGroupGrouper<IndexedItem<Entity>>(){

        @Override
        Key extractEntityGroupKey(IndexedItem<Entity> item) {
            return 1.getEntityGroupKey(((Entity)item.item).getKey());
        }
    };
    static final EntityGroupGrouper<Key> KEY_GROUPER = new EntityGroupGrouper<Key>(){

        @Override
        Key extractEntityGroupKey(Key key) {
            return 2.getEntityGroupKey(key);
        }
    };
    private DatastoreAttributes.DatastoreType datastoreType;

    public AsyncDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        super(AsyncDatastoreServiceImpl.validateDatastoreServiceConfig(datastoreServiceConfig), defaultTxnProvider);
    }

    private static DatastoreServiceConfig validateDatastoreServiceConfig(DatastoreServiceConfig datastoreServiceConfig) {
        if (datastoreServiceConfig.getImplicitTransactionManagementPolicy() == ImplicitTransactionManagementPolicy.AUTO) {
            throw new IllegalArgumentException("The async datastore service does not support an implicit transaction management policy of AUTO");
        }
        return datastoreServiceConfig;
    }

    @Override
    public Future<Entity> get(Key key) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), key);
    }

    @Override
    public Future<Entity> get(Transaction txn, final Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        Future<Map<Key, Entity>> entities = this.get(txn, Arrays.asList(key));
        return new FutureWrapper<Map<Key, Entity>, Entity>(entities){

            @Override
            protected Entity wrap(Map<Key, Entity> entities) throws Exception {
                Entity entity = entities.get(key);
                if (entity == null) {
                    throw new EntityNotFoundException(key);
                }
                return entity;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Map<Key, Entity>> get(Iterable<Key> keys) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), keys);
    }

    @Override
    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        Collection<List<Key>> keysByEntityGroup;
        if (keys == null) {
            throw new NullPointerException("keys cannot be null");
        }
        ArrayList<Key> keyList = Lists.newArrayList(keys);
        HashMap<Key, Entity> resultMap = new HashMap<Key, Entity>();
        PreGetContext preGetContext = new PreGetContext(this, keyList, resultMap);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreGetCallbacks(preGetContext);
        if (!resultMap.isEmpty()) {
            keyList.removeAll(resultMap.keySet());
        }
        if (txn == null && this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.STRONG && this.getDatastoreType() == DatastoreAttributes.DatastoreType.HIGH_REPLICATION && (keysByEntityGroup = KEY_GROUPER.getItemsByEntityGroup(keys)).size() > 1) {
            return new PostLoadFuture(this.doBatchGetByEntityGroups(keysByEntityGroup, resultMap), this.datastoreServiceConfig.getDatastoreCallbacks(), this);
        }
        return new PostLoadFuture(this.doBatchGetBySize(txn, keys, resultMap), this.datastoreServiceConfig.getDatastoreCallbacks(), this);
    }

    private Future<Map<Key, Entity>> doBatchGetBySize(Transaction txn, final Iterable<Key> keys, final Map<Key, Entity> resultMap) {
        DatastorePb.GetRequest baseReq = new DatastorePb.GetRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            baseReq.setFailoverMs(-1L);
            baseReq.setStrong(false);
        }
        int baseEncodedReqSize = baseReq.encodingSize();
        ArrayList<Future<DatastorePb.GetResponse>> futures = new ArrayList<Future<DatastorePb.GetResponse>>();
        DatastorePb.GetRequest req = (DatastorePb.GetRequest)baseReq.clone();
        int encodedReqSize = baseEncodedReqSize;
        for (Key key : keys) {
            if (!key.isComplete()) {
                throw new IllegalArgumentException(key + " is incomplete.");
            }
            OnestoreEntity.Reference ref = KeyTranslator.convertToPb(key);
            int encodedKeySize = Protocol.stringSize(ref.encodingSize()) + 1;
            if (this.datastoreServiceConfig.exceedsReadLimits(req.keySize() + 1, encodedReqSize + encodedKeySize)) {
                futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Get", req, new DatastorePb.GetResponse()));
                encodedReqSize = baseEncodedReqSize;
                req = (DatastorePb.GetRequest)baseReq.clone();
            }
            encodedReqSize += encodedKeySize;
            req.addKey(ref);
        }
        if (req.keySize() > 0) {
            futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Get", req, new DatastorePb.GetResponse()));
        }
        return this.registerInTransaction(txn, new IteratingAggregateFuture<DatastorePb.GetResponse, Key, Map<Key, Entity>>(futures){

            @Override
            protected Map<Key, Entity> initResult() {
                return resultMap;
            }

            @Override
            protected Iterator<Key> initIterator() {
                return keys.iterator();
            }

            @Override
            protected Map<Key, Entity> aggregate(DatastorePb.GetResponse response, Iterator<Key> keyIterator, Map<Key, Entity> results) {
                for (DatastorePb.GetResponse.Entity responseEntity : response.entitys()) {
                    Key key = keyIterator.next();
                    if (!responseEntity.hasEntity()) continue;
                    results.put(key, EntityTranslator.createFromPb(responseEntity.getEntity()));
                }
                return results;
            }
        });
    }

    private Future<Map<Key, Entity>> doBatchGetByEntityGroups(Collection<List<Key>> keysByEntityGroup, final Map<Key, Entity> resultMap) {
        ArrayList<Future<Map<Key, Entity>>> subFutures = new ArrayList<Future<Map<Key, Entity>>>();
        ArrayList<Key> keysToGet = new ArrayList<Key>();
        int numEntityGroups = 0;
        for (List<Key> keysInGroup : keysByEntityGroup) {
            keysToGet.addAll(keysInGroup);
            if (++numEntityGroups != this.datastoreServiceConfig.getMaxEntityGroupsPerHighRepReadRpc()) continue;
            subFutures.add(this.doBatchGetBySize(null, keysToGet, resultMap));
            keysToGet = new ArrayList();
            numEntityGroups = 0;
        }
        if (!keysToGet.isEmpty()) {
            subFutures.add(this.doBatchGetBySize(null, keysToGet, resultMap));
        }
        return new FutureHelper.CumulativeAggregateFuture<Map<Key, Entity>, Map<Key, Entity>, Map<Key, Entity>>(subFutures){

            @Override
            protected Map<Key, Entity> initIntermediateResult() {
                return resultMap;
            }

            @Override
            protected Map<Key, Entity> aggregate(Map<Key, Entity> intermediateResult, Map<Key, Entity> result) {
                intermediateResult.putAll(result);
                return intermediateResult;
            }

            @Override
            protected Map<Key, Entity> finalizeResult(Map<Key, Entity> result) {
                return result;
            }
        };
    }

    @Override
    public Future<Key> put(Entity entity) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entity);
    }

    @Override
    public Future<Key> put(Transaction txn, Entity entity) {
        return new FutureWrapper<List<Key>, Key>(this.put(txn, Arrays.asList(entity))){

            @Override
            protected Key wrap(List<Key> keys) throws Exception {
                return keys.get(0);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<List<Key>> put(Iterable<Entity> entities) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entities);
    }

    @Override
    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        ArrayList<Entity> entityList = List.class.isAssignableFrom(entities.getClass()) ? (ArrayList<Entity>)entities : Lists.newArrayList(entities);
        PutContext prePutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePrePutCallbacks(prePutContext);
        Future<List<Key>> result = null;
        PutContext postPutContext = null;
        if (txn == null) {
            postPutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
            ArrayList<IndexedItem<Entity>> indexedEntities = new ArrayList<IndexedItem<Entity>>();
            int index = 0;
            for (Entity entity : entityList) {
                indexedEntities.add(new IndexedItem<Entity>(entity, index++));
            }
            Collection<List<IndexedItem<Entity>>> entitiesByEntityGroup = ENTITY_GROUPER.getItemsByEntityGroup(indexedEntities);
            if (entitiesByEntityGroup.size() > 1) {
                result = this.doBatchPutByEntityGroups(entitiesByEntityGroup);
            }
        }
        if (result == null) {
            result = this.doBatchPutBySize(txn, entityList);
        }
        if (txn == null) {
            result = new PostPutFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), postPutContext);
        } else {
            this.defaultTxnProvider.addPutEntities(txn, entityList);
        }
        return result;
    }

    private Future<List<Key>> doBatchPutBySize(Transaction txn, final Iterable<Entity> entities) {
        DatastorePb.PutRequest baseReq = new DatastorePb.PutRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        int baseEncodedReqSize = baseReq.encodingSize();
        ArrayList<Future<DatastorePb.PutResponse>> futures = new ArrayList<Future<DatastorePb.PutResponse>>();
        int encodedReqSize = baseEncodedReqSize;
        DatastorePb.PutRequest req = (DatastorePb.PutRequest)baseReq.clone();
        for (Entity entity : entities) {
            OnestoreEntity.EntityProto proto = EntityTranslator.convertToPb(entity);
            int encodedEntitySize = Protocol.stringSize(proto.encodingSize()) + 1;
            if (this.datastoreServiceConfig.exceedsWriteLimits(req.entitySize() + 1, encodedReqSize + encodedEntitySize)) {
                futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Put", req, new DatastorePb.PutResponse()));
                encodedReqSize = baseEncodedReqSize;
                req = (DatastorePb.PutRequest)baseReq.clone();
            }
            encodedReqSize += encodedEntitySize;
            req.addEntity(proto);
        }
        if (req.entitySize() > 0) {
            futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Put", req, new DatastorePb.PutResponse()));
        }
        return this.registerInTransaction(txn, new IteratingAggregateFuture<DatastorePb.PutResponse, Entity, List<Key>>(futures){

            @Override
            protected List<Key> initResult() {
                return new ArrayList<Key>();
            }

            @Override
            protected Iterator<Entity> initIterator() {
                return entities.iterator();
            }

            @Override
            protected List<Key> aggregate(DatastorePb.PutResponse intermediateResult, Iterator<Entity> entitiesIterator, List<Key> keysInOrder) {
                for (OnestoreEntity.Reference reference : intermediateResult.keys()) {
                    Entity entity = entitiesIterator.next();
                    KeyTranslator.updateKey(reference, entity.getKey());
                    keysInOrder.add(entity.getKey());
                }
                return keysInOrder;
            }
        });
    }

    private Future<List<Key>> doBatchPutByEntityGroups(Collection<List<IndexedItem<Entity>>> entitiesByEntityGroup) {
        ArrayList<Future<List<IndexedItem<Key>>>> subFutures = new ArrayList<Future<List<IndexedItem<Key>>>>();
        ArrayList<IndexedItem<Entity>> entitiesToPut = new ArrayList<IndexedItem<Entity>>();
        int numEntityGroups = 0;
        for (List<IndexedItem<Entity>> indexedEntitiesInGroup : entitiesByEntityGroup) {
            entitiesToPut.addAll(indexedEntitiesInGroup);
            if (++numEntityGroups != this.datastoreServiceConfig.getMaxEntityGroupsPerRpcInternal()) continue;
            this.assemblePutFuture(entitiesToPut, subFutures);
            numEntityGroups = 0;
        }
        if (!entitiesToPut.isEmpty()) {
            this.assemblePutFuture(entitiesToPut, subFutures);
        }
        return new SortingAggregateFuture(subFutures);
    }

    private void assemblePutFuture(List<IndexedItem<Entity>> entitiesToPut, List<Future<List<IndexedItem<Key>>>> subFutures) {
        final ArrayList<IndexedItem<Entity>> entitiesToPutCopy = new ArrayList<IndexedItem<Entity>>(entitiesToPut);
        UnwrappingIterable<Entity> unwrappedEntitiesToPut = new UnwrappingIterable<Entity>(entitiesToPutCopy);
        Future<List<Key>> future = this.doBatchPutBySize(null, unwrappedEntitiesToPut);
        FutureWrapper<List<Key>, List<IndexedItem<Key>>> indexedFuture = new FutureWrapper<List<Key>, List<IndexedItem<Key>>>(future){

            @Override
            protected List<IndexedItem<Key>> wrap(List<Key> keys) throws Exception {
                ArrayList<IndexedItem<Key>> orderedKeys = new ArrayList<IndexedItem<Key>>(keys.size());
                int keyIndex = 0;
                for (Key key : keys) {
                    orderedKeys.add(new IndexedItem<Key>(key, ((IndexedItem)entitiesToPutCopy.get((int)keyIndex++)).index));
                }
                return orderedKeys;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
        subFutures.add((Future<List<IndexedItem<Key>>>)indexedFuture);
        entitiesToPut.clear();
    }

    @Override
    public Future<Void> delete(Key ... keys) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.delete(result.getTransaction(), keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Key ... keys) {
        return this.delete(txn, Arrays.asList(keys));
    }

    @Override
    public Future<Void> delete(Iterable<Key> keys) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.delete(result.getTransaction(), keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        ArrayList<Key> keyList = List.class.isAssignableFrom(keys.getClass()) ? (ArrayList<Key>)keys : Lists.newArrayList(keys);
        DeleteContext preDeleteContext = new DeleteContext((CurrentTransactionProvider)this, (List<Key>)keyList);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreDeleteCallbacks(preDeleteContext);
        Future<Void> result = null;
        DeleteContext postDeleteContext = null;
        if (txn == null) {
            postDeleteContext = new DeleteContext((CurrentTransactionProvider)this, (List<Key>)keyList);
            Collection<List<Key>> keysByEntityGroup = KEY_GROUPER.getItemsByEntityGroup(keyList);
            if (keysByEntityGroup.size() > 1) {
                result = this.doBatchDeleteByEntityGroups(keysByEntityGroup);
            }
        }
        if (result == null) {
            result = this.doBatchDeleteBySize(txn, keyList);
        }
        if (txn == null) {
            result = new PostDeleteFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), postDeleteContext);
        } else {
            this.defaultTxnProvider.addDeletedKeys(txn, keyList);
        }
        return result;
    }

    private Future<Void> doBatchDeleteBySize(Transaction txn, Iterable<Key> keys) {
        DatastorePb.DeleteRequest baseReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        int baseEncodedReqSize = baseReq.encodingSize();
        ArrayList<Future<DatastorePb.DeleteResponse>> futures = new ArrayList<Future<DatastorePb.DeleteResponse>>();
        int encodedReqSize = baseEncodedReqSize;
        DatastorePb.DeleteRequest req = (DatastorePb.DeleteRequest)baseReq.clone();
        for (Key key : keys) {
            if (!key.isComplete()) {
                throw new IllegalArgumentException(key + " is incomplete.");
            }
            OnestoreEntity.Reference ref = KeyTranslator.convertToPb(key);
            int encodedKeySize = Protocol.stringSize(ref.encodingSize()) + 1;
            if (this.datastoreServiceConfig.exceedsWriteLimits(req.keySize() + 1, encodedReqSize + encodedKeySize)) {
                futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Delete", req, new DatastorePb.DeleteResponse()));
                encodedReqSize = baseEncodedReqSize;
                req = (DatastorePb.DeleteRequest)baseReq.clone();
            }
            encodedReqSize += encodedKeySize;
            req.addKey(ref);
        }
        if (req.keySize() > 0) {
            futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Delete", req, new DatastorePb.DeleteResponse()));
        }
        return this.registerInTransaction(txn, new FutureHelper.CumulativeAggregateFuture<DatastorePb.DeleteResponse, Void, Void>(futures){

            @Override
            protected Void aggregate(DatastorePb.DeleteResponse intermediateResult, Void result) {
                return null;
            }

            @Override
            protected Void finalizeResult(Void result) {
                return null;
            }

            @Override
            protected Void initIntermediateResult() {
                return null;
            }
        });
    }

    private Future<Void> doBatchDeleteByEntityGroups(Collection<List<Key>> keysByEntityGroup) {
        ArrayList<Future<Void>> subFutures = new ArrayList<Future<Void>>();
        ArrayList<Key> keysToDelete = new ArrayList<Key>();
        int numEntityGroups = 0;
        for (List<Key> keysInGroup : keysByEntityGroup) {
            keysToDelete.addAll(keysInGroup);
            if (++numEntityGroups != this.datastoreServiceConfig.getMaxEntityGroupsPerRpcInternal()) continue;
            subFutures.add(this.doBatchDeleteBySize(null, keysToDelete));
            keysToDelete = new ArrayList();
            numEntityGroups = 0;
        }
        if (!keysToDelete.isEmpty()) {
            subFutures.add(this.doBatchDeleteBySize(null, keysToDelete));
        }
        return new FutureHelper.CumulativeAggregateFuture<Void, Void, Void>(subFutures){

            @Override
            protected Void initIntermediateResult() {
                return null;
            }

            @Override
            protected Void aggregate(Void intermediateResult, Void result) {
                return null;
            }

            @Override
            protected Void finalizeResult(Void result) {
                return null;
            }
        };
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.defaultTxnProvider.getAll();
    }

    private <T> Future<T> registerInTransaction(Transaction txn, Future<T> future) {
        if (txn != null) {
            this.defaultTxnProvider.addFuture(txn, future);
            return new FutureHelper.TxnAwareFuture<T>(future, txn, this.defaultTxnProvider);
        }
        return future;
    }

    @Override
    public Future<Transaction> beginTransaction() {
        return this.beginTransaction(TransactionOptions.Builder.withDefaults());
    }

    @Override
    public Future<Transaction> beginTransaction(TransactionOptions options) {
        return new FutureHelper.FakeFuture<Transaction>(this.beginTransactionInternal(options));
    }

    @Override
    public PreparedQuery prepare(Query query) {
        return this.prepare(null, query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        PreQueryContext context = new PreQueryContext((CurrentTransactionProvider)this, query);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreQueryCallbacks(context);
        query = (Query)context.getElements().get(0);
        AsyncDatastoreServiceImpl.validateQuery(query);
        List<MultiQueryBuilder> queriesToRun = QuerySplitHelper.splitQuery(query);
        query.setFilter(null);
        query.getFilterPredicates().clear();
        if (queriesToRun.size() == 1 && queriesToRun.get(0).isSingleton()) {
            query.getFilterPredicates().addAll(queriesToRun.get(0).getBaseFilters());
            return new PreparedQueryImpl(this.apiConfig, this.datastoreServiceConfig, query, txn);
        }
        return new PreparedMultiQuery(this.apiConfig, this.datastoreServiceConfig, query, queriesToRun, txn);
    }

    @Override
    public Future<KeyRange> allocateIds(String kind, long num) {
        return this.allocateIds(null, kind, num);
    }

    static OnestoreEntity.Reference buildAllocateIdsRef(Key parent, String kind) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("parent key must be complete");
        }
        Key key = KeyFactory.createKey(parent, kind, "ignored");
        return KeyTranslator.convertToPb(key);
    }

    @Override
    public Future<KeyRange> allocateIds(final Key parent, final String kind, long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("num must be > 0");
        }
        if (num > 1000000000L) {
            throw new IllegalArgumentException("num must be < 1 billion");
        }
        OnestoreEntity.Reference allocateIdsRef = AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind);
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setSize(num).setModelKey(allocateIdsRef);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        Future<DatastorePb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "AllocateIds", req, resp);
        return new FutureWrapper<DatastorePb.AllocateIdsResponse, KeyRange>(future){

            @Override
            protected KeyRange wrap(DatastorePb.AllocateIdsResponse resp) throws Exception {
                return new KeyRange(parent, kind, resp.getStart(), resp.getEnd());
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    protected DatastoreAttributes.DatastoreType getDatastoreType() {
        if (this.datastoreType == null) {
            this.datastoreType = FutureHelper.quietGet(this.getDatastoreAttributes()).getDatastoreType();
        }
        return this.datastoreType;
    }

    @Override
    public Future<DatastoreAttributes> getDatastoreAttributes() {
        return new FutureHelper.FakeFuture<DatastoreAttributes>(new DatastoreAttributes());
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        String appId = DatastoreApiHelper.getCurrentAppId();
        ApiBasePb.StringProto req = new ApiBasePb.StringProto();
        req.setValue(appId);
        return new FutureWrapper<DatastorePb.CompositeIndices, Map<Index, Index.IndexState>>(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "GetIndices", req, new DatastorePb.CompositeIndices())){

            @Override
            protected Map<Index, Index.IndexState> wrap(DatastorePb.CompositeIndices indices) throws Exception {
                LinkedHashMap<Index, Index.IndexState> answer = new LinkedHashMap<Index, Index.IndexState>();
                block6: for (OnestoreEntity.CompositeIndex ci : indices.indexs()) {
                    Index index = AsyncDatastoreServiceImpl.translateCompositeIndexProtobufToIndex(ci);
                    switch (ci.getStateEnum()) {
                        case DELETED: {
                            answer.put(index, Index.IndexState.DELETING);
                            continue block6;
                        }
                        case ERROR: {
                            answer.put(index, Index.IndexState.ERROR);
                            continue block6;
                        }
                        case READ_WRITE: {
                            answer.put(index, Index.IndexState.SERVING);
                            continue block6;
                        }
                        case WRITE_ONLY: {
                            answer.put(index, Index.IndexState.BUILDING);
                            continue block6;
                        }
                    }
                    AsyncDatastoreServiceImpl.this.logger.log(Level.WARNING, "Unrecognized index state for " + index);
                }
                return answer;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    static Index translateCompositeIndexProtobufToIndex(OnestoreEntity.CompositeIndex ci) {
        String kind = ci.getDefinition().getEntityType();
        boolean isAncestor = ci.getDefinition().isAncestor();
        ArrayList<Index.Property> properties = new ArrayList<Index.Property>(ci.getDefinition().propertySize());
        for (OnestoreEntity.Index.Property p : ci.getDefinition().propertys()) {
            properties.add(new Index.Property(p.getName(), Query.SortDirection.valueOf(p.getDirectionEnum().name())));
        }
        Index index = new Index(ci.getId(), kind, isAncestor, properties);
        return index;
    }

    private static class SortingAggregateFuture
    extends FutureHelper.CumulativeAggregateFuture<List<IndexedItem<Key>>, List<IndexedItem<Key>>, List<Key>> {
        private SortingAggregateFuture(Iterable<Future<List<IndexedItem<Key>>>> futures) {
            super(futures);
        }

        @Override
        protected List<IndexedItem<Key>> initIntermediateResult() {
            return new ArrayList<IndexedItem<Key>>();
        }

        @Override
        protected List<IndexedItem<Key>> aggregate(List<IndexedItem<Key>> intermediateResult, List<IndexedItem<Key>> result) {
            intermediateResult.addAll(result);
            return intermediateResult;
        }

        @Override
        protected List<Key> finalizeResult(List<IndexedItem<Key>> unorderedResult) {
            Collections.sort(unorderedResult);
            ArrayList<Key> orderedResult = new ArrayList<Key>(unorderedResult.size());
            for (IndexedItem<Key> key : unorderedResult) {
                orderedResult.add((Key)key.item);
            }
            return orderedResult;
        }
    }

    static abstract class EntityGroupGrouper<T> {
        EntityGroupGrouper() {
        }

        public Collection<List<T>> getItemsByEntityGroup(Iterable<T> items) {
            LinkedHashMap<Key, ArrayList<T>> entitiesByEntityGroup = new LinkedHashMap<Key, ArrayList<T>>();
            for (T item : items) {
                Key entityGroupKey = this.extractEntityGroupKey(item);
                ArrayList<T> entitiesInGroup = (ArrayList<T>)entitiesByEntityGroup.get(entityGroupKey);
                if (entitiesInGroup == null) {
                    entitiesInGroup = new ArrayList<T>();
                    entitiesByEntityGroup.put(entityGroupKey, entitiesInGroup);
                }
                entitiesInGroup.add(item);
            }
            return entitiesByEntityGroup.values();
        }

        static Key getEntityGroupKey(Key key) {
            Key curKey = key;
            while (curKey.getParent() != null) {
                curKey = curKey.getParent();
            }
            return curKey;
        }

        abstract Key extractEntityGroupKey(T var1);
    }

    private static class UnwrappingIterable<T>
    implements Iterable<T> {
        private final Iterable<IndexedItem<T>> innerIterable;

        private UnwrappingIterable(Iterable<IndexedItem<T>> innerIterable) {
            this.innerIterable = innerIterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                Iterator<IndexedItem<T>> inner;
                {
                    this.inner = UnwrappingIterable.this.innerIterable.iterator();
                }

                @Override
                protected T computeNext() {
                    if (this.inner.hasNext()) {
                        return this.inner.next().item;
                    }
                    this.endOfData();
                    return null;
                }
            };
        }
    }

    static class IndexedItem<T>
    implements Comparable<IndexedItem<T>> {
        final T item;
        final int index;

        IndexedItem(T item, int index) {
            this.item = item;
            this.index = index;
        }

        @Override
        public int compareTo(IndexedItem<T> other) {
            return Integer.valueOf(this.index).compareTo(other.index);
        }
    }

    private static abstract class IteratingAggregateFuture<K, I, V>
    extends FutureHelper.CumulativeAggregateFuture<K, Pair<Iterator<I>, V>, V> {
        public IteratingAggregateFuture(Iterable<Future<K>> futures) {
            super(futures);
        }

        protected abstract V aggregate(K var1, Iterator<I> var2, V var3);

        protected abstract Iterator<I> initIterator();

        protected abstract V initResult();

        @Override
        protected final Pair<Iterator<I>, V> aggregate(K intermediateResult, Pair<Iterator<I>, V> result) {
            return Pair.of(result.first, this.aggregate(intermediateResult, (Iterator)result.first, result.second));
        }

        @Override
        protected V finalizeResult(Pair<Iterator<I>, V> result) {
            return (V)result.second;
        }

        @Override
        protected final Pair<Iterator<I>, V> initIntermediateResult() {
            return Pair.of(this.initIterator(), this.initResult());
        }
    }
}

