/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Settings and Info of the monitor stream
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MonitorStreamInfo extends com.google.api.client.json.GenericJson {

  /**
   * If you have set the enableMonitorStream property to true, then this property determines the
   * length of the live broadcast delay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long broadcastStreamDelayMs;

  /**
   * HTML code that embeds a player that plays the monitor stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String embedHtml;

  /**
   * This value determines whether the monitor stream is enabled for the broadcast. If the monitor
   * stream is enabled, then YouTube will broadcast the event content on a special stream intended
   * only for the broadcaster's consumption. The broadcaster can use the stream to review the event
   * content and also to identify the optimal times to insert cuepoints.
   *
   * You need to set this value to true if you intend to have a broadcast delay for your event.
   *
   * Note: This property cannot be updated once the broadcast is in the testing or live state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableMonitorStream;

  /**
   * If you have set the enableMonitorStream property to true, then this property determines the
   * length of the live broadcast delay.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBroadcastStreamDelayMs() {
    return broadcastStreamDelayMs;
  }

  /**
   * If you have set the enableMonitorStream property to true, then this property determines the
   * length of the live broadcast delay.
   * @param broadcastStreamDelayMs broadcastStreamDelayMs or {@code null} for none
   */
  public MonitorStreamInfo setBroadcastStreamDelayMs(java.lang.Long broadcastStreamDelayMs) {
    this.broadcastStreamDelayMs = broadcastStreamDelayMs;
    return this;
  }

  /**
   * HTML code that embeds a player that plays the monitor stream.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmbedHtml() {
    return embedHtml;
  }

  /**
   * HTML code that embeds a player that plays the monitor stream.
   * @param embedHtml embedHtml or {@code null} for none
   */
  public MonitorStreamInfo setEmbedHtml(java.lang.String embedHtml) {
    this.embedHtml = embedHtml;
    return this;
  }

  /**
   * This value determines whether the monitor stream is enabled for the broadcast. If the monitor
   * stream is enabled, then YouTube will broadcast the event content on a special stream intended
   * only for the broadcaster's consumption. The broadcaster can use the stream to review the event
   * content and also to identify the optimal times to insert cuepoints.
   *
   * You need to set this value to true if you intend to have a broadcast delay for your event.
   *
   * Note: This property cannot be updated once the broadcast is in the testing or live state.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableMonitorStream() {
    return enableMonitorStream;
  }

  /**
   * This value determines whether the monitor stream is enabled for the broadcast. If the monitor
   * stream is enabled, then YouTube will broadcast the event content on a special stream intended
   * only for the broadcaster's consumption. The broadcaster can use the stream to review the event
   * content and also to identify the optimal times to insert cuepoints.
   *
   * You need to set this value to true if you intend to have a broadcast delay for your event.
   *
   * Note: This property cannot be updated once the broadcast is in the testing or live state.
   * @param enableMonitorStream enableMonitorStream or {@code null} for none
   */
  public MonitorStreamInfo setEnableMonitorStream(java.lang.Boolean enableMonitorStream) {
    this.enableMonitorStream = enableMonitorStream;
    return this;
  }

  @Override
  public MonitorStreamInfo set(String fieldName, Object value) {
    return (MonitorStreamInfo) super.set(fieldName, value);
  }

  @Override
  public MonitorStreamInfo clone() {
    return (MonitorStreamInfo) super.clone();
  }

}
