/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveStreamHealthStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveStreamHealthStatus extends com.google.api.client.json.GenericJson {

  /**
   * The configurations issues on this stream
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LiveStreamConfigurationIssue> configurationIssues;

  static {
    // hack to force ProGuard to consider LiveStreamConfigurationIssue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LiveStreamConfigurationIssue.class);
  }

  /**
   * The last time this status was updated (in seconds)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger lastUpdateTimeSeconds;

  /**
   * The status code of this stream
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The configurations issues on this stream
   * @return value or {@code null} for none
   */
  public java.util.List<LiveStreamConfigurationIssue> getConfigurationIssues() {
    return configurationIssues;
  }

  /**
   * The configurations issues on this stream
   * @param configurationIssues configurationIssues or {@code null} for none
   */
  public LiveStreamHealthStatus setConfigurationIssues(java.util.List<LiveStreamConfigurationIssue> configurationIssues) {
    this.configurationIssues = configurationIssues;
    return this;
  }

  /**
   * The last time this status was updated (in seconds)
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getLastUpdateTimeSeconds() {
    return lastUpdateTimeSeconds;
  }

  /**
   * The last time this status was updated (in seconds)
   * @param lastUpdateTimeSeconds lastUpdateTimeSeconds or {@code null} for none
   */
  public LiveStreamHealthStatus setLastUpdateTimeSeconds(java.math.BigInteger lastUpdateTimeSeconds) {
    this.lastUpdateTimeSeconds = lastUpdateTimeSeconds;
    return this;
  }

  /**
   * The status code of this stream
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status code of this stream
   * @param status status or {@code null} for none
   */
  public LiveStreamHealthStatus setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public LiveStreamHealthStatus set(String fieldName, Object value) {
    return (LiveStreamHealthStatus) super.set(fieldName, value);
  }

  @Override
  public LiveStreamHealthStatus clone() {
    return (LiveStreamHealthStatus) super.clone();
  }

}
