/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveBroadcastTopic.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveBroadcastTopic extends com.google.api.client.json.GenericJson {

  /**
   * Information about the topic matched.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveBroadcastTopicSnippet snippet;

  /**
   * The type of the topic.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * If this flag is set it means that we have not been able to match the topic title and type
   * provided to a known entity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean unmatched;

  /**
   * Information about the topic matched.
   * @return value or {@code null} for none
   */
  public LiveBroadcastTopicSnippet getSnippet() {
    return snippet;
  }

  /**
   * Information about the topic matched.
   * @param snippet snippet or {@code null} for none
   */
  public LiveBroadcastTopic setSnippet(LiveBroadcastTopicSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The type of the topic.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the topic.
   * @param type type or {@code null} for none
   */
  public LiveBroadcastTopic setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * If this flag is set it means that we have not been able to match the topic title and type
   * provided to a known entity.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUnmatched() {
    return unmatched;
  }

  /**
   * If this flag is set it means that we have not been able to match the topic title and type
   * provided to a known entity.
   * @param unmatched unmatched or {@code null} for none
   */
  public LiveBroadcastTopic setUnmatched(java.lang.Boolean unmatched) {
    this.unmatched = unmatched;
    return this;
  }

  @Override
  public LiveBroadcastTopic set(String fieldName, Object value) {
    return (LiveBroadcastTopic) super.set(fieldName, value);
  }

  @Override
  public LiveBroadcastTopic clone() {
    return (LiveBroadcastTopic) super.clone();
  }

}
