/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for FanFundingEventSnippet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FanFundingEventSnippet extends com.google.api.client.json.GenericJson {

  /**
   * The amount of funding in micros of fund_currency. e.g., 1 is represented
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger amountMicros;

  /**
   * Channel id where the funding event occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelId;

  /**
   * The text contents of the comment left by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commentText;

  /**
   * The date and time when the funding occurred. The value is specified in ISO 8601 (YYYY-MM-
   * DDThh:mm:ss.sZ) format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdAt;

  /**
   * The currency in which the fund was made. ISO 4217.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currency;

  /**
   * A rendered string that displays the fund amount and currency (e.g., "$1.00"). The string is
   * rendered for the given language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayString;

  /**
   * Details about the supporter. Only filled if the event was made public by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelProfileDetails supporterDetails;

  /**
   * The amount of funding in micros of fund_currency. e.g., 1 is represented
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getAmountMicros() {
    return amountMicros;
  }

  /**
   * The amount of funding in micros of fund_currency. e.g., 1 is represented
   * @param amountMicros amountMicros or {@code null} for none
   */
  public FanFundingEventSnippet setAmountMicros(java.math.BigInteger amountMicros) {
    this.amountMicros = amountMicros;
    return this;
  }

  /**
   * Channel id where the funding event occurred.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelId() {
    return channelId;
  }

  /**
   * Channel id where the funding event occurred.
   * @param channelId channelId or {@code null} for none
   */
  public FanFundingEventSnippet setChannelId(java.lang.String channelId) {
    this.channelId = channelId;
    return this;
  }

  /**
   * The text contents of the comment left by the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommentText() {
    return commentText;
  }

  /**
   * The text contents of the comment left by the user.
   * @param commentText commentText or {@code null} for none
   */
  public FanFundingEventSnippet setCommentText(java.lang.String commentText) {
    this.commentText = commentText;
    return this;
  }

  /**
   * The date and time when the funding occurred. The value is specified in ISO 8601 (YYYY-MM-
   * DDThh:mm:ss.sZ) format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * The date and time when the funding occurred. The value is specified in ISO 8601 (YYYY-MM-
   * DDThh:mm:ss.sZ) format.
   * @param createdAt createdAt or {@code null} for none
   */
  public FanFundingEventSnippet setCreatedAt(com.google.api.client.util.DateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * The currency in which the fund was made. ISO 4217.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrency() {
    return currency;
  }

  /**
   * The currency in which the fund was made. ISO 4217.
   * @param currency currency or {@code null} for none
   */
  public FanFundingEventSnippet setCurrency(java.lang.String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * A rendered string that displays the fund amount and currency (e.g., "$1.00"). The string is
   * rendered for the given language.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayString() {
    return displayString;
  }

  /**
   * A rendered string that displays the fund amount and currency (e.g., "$1.00"). The string is
   * rendered for the given language.
   * @param displayString displayString or {@code null} for none
   */
  public FanFundingEventSnippet setDisplayString(java.lang.String displayString) {
    this.displayString = displayString;
    return this;
  }

  /**
   * Details about the supporter. Only filled if the event was made public by the user.
   * @return value or {@code null} for none
   */
  public ChannelProfileDetails getSupporterDetails() {
    return supporterDetails;
  }

  /**
   * Details about the supporter. Only filled if the event was made public by the user.
   * @param supporterDetails supporterDetails or {@code null} for none
   */
  public FanFundingEventSnippet setSupporterDetails(ChannelProfileDetails supporterDetails) {
    this.supporterDetails = supporterDetails;
    return this;
  }

  @Override
  public FanFundingEventSnippet set(String fieldName, Object value) {
    return (FanFundingEventSnippet) super.set(fieldName, value);
  }

  @Override
  public FanFundingEventSnippet clone() {
    return (FanFundingEventSnippet) super.clone();
  }

}
