/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A fanFundingEvent resource represents a fan funding event on a YouTube channel. Fan funding
 * events occur when a user gives one-time monetary support to the channel owner.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FanFundingEvent extends com.google.api.client.json.GenericJson {

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube assigns to uniquely identify the fan funding event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#fanFundingEvent".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the fan funding event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FanFundingEventSnippet snippet;

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public FanFundingEvent setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the fan funding event.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the fan funding event.
   * @param id id or {@code null} for none
   */
  public FanFundingEvent setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#fanFundingEvent".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#fanFundingEvent".
   * @param kind kind or {@code null} for none
   */
  public FanFundingEvent setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the fan funding event.
   * @return value or {@code null} for none
   */
  public FanFundingEventSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the fan funding event.
   * @param snippet snippet or {@code null} for none
   */
  public FanFundingEvent setSnippet(FanFundingEventSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  @Override
  public FanFundingEvent set(String fieldName, Object value) {
    return (FanFundingEvent) super.set(fieldName, value);
  }

  @Override
  public FanFundingEvent clone() {
    return (FanFundingEvent) super.clone();
  }

}
