/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Basic details about a comment thread.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CommentThreadSnippet extends com.google.api.client.json.GenericJson {

  /**
   * Whether the current viewer of the thread can reply to it. This is viewer specific - other
   * viewers may see a different value for this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canReply;

  /**
   * The YouTube channel the comments in the thread refer to or the channel with the video the
   * comments refer to. If video_id isn't set the comments refer to the channel itself.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelId;

  /**
   * Whether the thread (and therefore all its comments) is visible to all YouTube users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isPublic;

  /**
   * The top level comment of this thread.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Comment topLevelComment;

  /**
   * The total number of replies (not including the top level comment).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long totalReplyCount;

  /**
   * The ID of the video the comments refer to, if any. No video_id implies a channel discussion
   * comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String videoId;

  /**
   * Whether the current viewer of the thread can reply to it. This is viewer specific - other
   * viewers may see a different value for this field.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanReply() {
    return canReply;
  }

  /**
   * Whether the current viewer of the thread can reply to it. This is viewer specific - other
   * viewers may see a different value for this field.
   * @param canReply canReply or {@code null} for none
   */
  public CommentThreadSnippet setCanReply(java.lang.Boolean canReply) {
    this.canReply = canReply;
    return this;
  }

  /**
   * The YouTube channel the comments in the thread refer to or the channel with the video the
   * comments refer to. If video_id isn't set the comments refer to the channel itself.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelId() {
    return channelId;
  }

  /**
   * The YouTube channel the comments in the thread refer to or the channel with the video the
   * comments refer to. If video_id isn't set the comments refer to the channel itself.
   * @param channelId channelId or {@code null} for none
   */
  public CommentThreadSnippet setChannelId(java.lang.String channelId) {
    this.channelId = channelId;
    return this;
  }

  /**
   * Whether the thread (and therefore all its comments) is visible to all YouTube users.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsPublic() {
    return isPublic;
  }

  /**
   * Whether the thread (and therefore all its comments) is visible to all YouTube users.
   * @param isPublic isPublic or {@code null} for none
   */
  public CommentThreadSnippet setIsPublic(java.lang.Boolean isPublic) {
    this.isPublic = isPublic;
    return this;
  }

  /**
   * The top level comment of this thread.
   * @return value or {@code null} for none
   */
  public Comment getTopLevelComment() {
    return topLevelComment;
  }

  /**
   * The top level comment of this thread.
   * @param topLevelComment topLevelComment or {@code null} for none
   */
  public CommentThreadSnippet setTopLevelComment(Comment topLevelComment) {
    this.topLevelComment = topLevelComment;
    return this;
  }

  /**
   * The total number of replies (not including the top level comment).
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalReplyCount() {
    return totalReplyCount;
  }

  /**
   * The total number of replies (not including the top level comment).
   * @param totalReplyCount totalReplyCount or {@code null} for none
   */
  public CommentThreadSnippet setTotalReplyCount(java.lang.Long totalReplyCount) {
    this.totalReplyCount = totalReplyCount;
    return this;
  }

  /**
   * The ID of the video the comments refer to, if any. No video_id implies a channel discussion
   * comment.
   * @return value or {@code null} for none
   */
  public java.lang.String getVideoId() {
    return videoId;
  }

  /**
   * The ID of the video the comments refer to, if any. No video_id implies a channel discussion
   * comment.
   * @param videoId videoId or {@code null} for none
   */
  public CommentThreadSnippet setVideoId(java.lang.String videoId) {
    this.videoId = videoId;
    return this;
  }

  @Override
  public CommentThreadSnippet set(String fieldName, Object value) {
    return (CommentThreadSnippet) super.set(fieldName, value);
  }

  @Override
  public CommentThreadSnippet clone() {
    return (CommentThreadSnippet) super.clone();
  }

}
