/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A comment thread represents information that applies to a top level comment and all its replies.
 * It can also include the top level comment itself and some of the replies.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CommentThread extends com.google.api.client.json.GenericJson {

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube uses to uniquely identify the comment thread.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#commentThread".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The replies object contains a limited number of replies (if any) to the top level comment found
   * in the snippet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CommentThreadReplies replies;

  /**
   * The snippet object contains basic details about the comment thread and also the top level
   * comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CommentThreadSnippet snippet;

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public CommentThread setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the comment thread.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube uses to uniquely identify the comment thread.
   * @param id id or {@code null} for none
   */
  public CommentThread setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#commentThread".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#commentThread".
   * @param kind kind or {@code null} for none
   */
  public CommentThread setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The replies object contains a limited number of replies (if any) to the top level comment found
   * in the snippet.
   * @return value or {@code null} for none
   */
  public CommentThreadReplies getReplies() {
    return replies;
  }

  /**
   * The replies object contains a limited number of replies (if any) to the top level comment found
   * in the snippet.
   * @param replies replies or {@code null} for none
   */
  public CommentThread setReplies(CommentThreadReplies replies) {
    this.replies = replies;
    return this;
  }

  /**
   * The snippet object contains basic details about the comment thread and also the top level
   * comment.
   * @return value or {@code null} for none
   */
  public CommentThreadSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the comment thread and also the top level
   * comment.
   * @param snippet snippet or {@code null} for none
   */
  public CommentThread setSnippet(CommentThreadSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  @Override
  public CommentThread set(String fieldName, Object value) {
    return (CommentThread) super.set(fieldName, value);
  }

  @Override
  public CommentThread clone() {
    return (CommentThread) super.clone();
  }

}
