/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.slides.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.slides.v1.SlidesRequest;
import com.google.api.services.slides.v1.SlidesRequestInitializer;
import com.google.api.services.slides.v1.model.BatchUpdatePresentationRequest;
import com.google.api.services.slides.v1.model.BatchUpdatePresentationResponse;
import com.google.api.services.slides.v1.model.Page;
import com.google.api.services.slides.v1.model.Presentation;
import com.google.api.services.slides.v1.model.Thumbnail;
import java.io.IOException;
import java.util.regex.Pattern;

public class Slides
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://slides.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://slides.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://slides.googleapis.com/";

    public Slides(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Slides(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Presentations presentations() {
        return new Presentations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Google Slides API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Slides.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://slides.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Slides.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Slides.DEFAULT_BATCH_PATH);
        }

        public Slides build() {
            return new Slides(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSlidesRequestInitializer(SlidesRequestInitializer slidesRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)slidesRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Presentations {
        public BatchUpdate batchUpdate(String presentationId, BatchUpdatePresentationRequest content) throws IOException {
            BatchUpdate result = new BatchUpdate(presentationId, content);
            Slides.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Presentation content) throws IOException {
            Create result = new Create(content);
            Slides.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String presentationId) throws IOException {
            Get result = new Get(presentationId);
            Slides.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Pages pages() {
            return new Pages();
        }

        public class Pages {
            public Get get(String presentationId, String pageObjectId) throws IOException {
                Get result = new Get(presentationId, pageObjectId);
                Slides.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetThumbnail getThumbnail(String presentationId, String pageObjectId) throws IOException {
                GetThumbnail result = new GetThumbnail(presentationId, pageObjectId);
                Slides.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class GetThumbnail
            extends SlidesRequest<Thumbnail> {
                private static final String REST_PATH = "v1/presentations/{presentationId}/pages/{pageObjectId}/thumbnail";
                @Key
                private String presentationId;
                @Key
                private String pageObjectId;
                @Key(value="thumbnailProperties.mimeType")
                private String thumbnailPropertiesMimeType;
                @Key(value="thumbnailProperties.thumbnailSize")
                private String thumbnailPropertiesThumbnailSize;

                protected GetThumbnail(String presentationId, String pageObjectId) {
                    super(Slides.this, "GET", REST_PATH, null, Thumbnail.class);
                    this.presentationId = (String)Preconditions.checkNotNull((Object)presentationId, (Object)"Required parameter presentationId must be specified.");
                    this.pageObjectId = (String)Preconditions.checkNotNull((Object)pageObjectId, (Object)"Required parameter pageObjectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetThumbnail set$Xgafv(String $Xgafv) {
                    return (GetThumbnail)super.set$Xgafv($Xgafv);
                }

                public GetThumbnail setAccessToken(String accessToken) {
                    return (GetThumbnail)super.setAccessToken(accessToken);
                }

                public GetThumbnail setAlt(String alt) {
                    return (GetThumbnail)super.setAlt(alt);
                }

                public GetThumbnail setCallback(String callback) {
                    return (GetThumbnail)super.setCallback(callback);
                }

                public GetThumbnail setFields(String fields) {
                    return (GetThumbnail)super.setFields(fields);
                }

                public GetThumbnail setKey(String key) {
                    return (GetThumbnail)super.setKey(key);
                }

                public GetThumbnail setOauthToken(String oauthToken) {
                    return (GetThumbnail)super.setOauthToken(oauthToken);
                }

                public GetThumbnail setPrettyPrint(Boolean prettyPrint) {
                    return (GetThumbnail)super.setPrettyPrint(prettyPrint);
                }

                public GetThumbnail setQuotaUser(String quotaUser) {
                    return (GetThumbnail)super.setQuotaUser(quotaUser);
                }

                public GetThumbnail setUploadType(String uploadType) {
                    return (GetThumbnail)super.setUploadType(uploadType);
                }

                public GetThumbnail setUploadProtocol(String uploadProtocol) {
                    return (GetThumbnail)super.setUploadProtocol(uploadProtocol);
                }

                public String getPresentationId() {
                    return this.presentationId;
                }

                public GetThumbnail setPresentationId(String presentationId) {
                    this.presentationId = presentationId;
                    return this;
                }

                public String getPageObjectId() {
                    return this.pageObjectId;
                }

                public GetThumbnail setPageObjectId(String pageObjectId) {
                    this.pageObjectId = pageObjectId;
                    return this;
                }

                public String getThumbnailPropertiesMimeType() {
                    return this.thumbnailPropertiesMimeType;
                }

                public GetThumbnail setThumbnailPropertiesMimeType(String thumbnailPropertiesMimeType) {
                    this.thumbnailPropertiesMimeType = thumbnailPropertiesMimeType;
                    return this;
                }

                public String getThumbnailPropertiesThumbnailSize() {
                    return this.thumbnailPropertiesThumbnailSize;
                }

                public GetThumbnail setThumbnailPropertiesThumbnailSize(String thumbnailPropertiesThumbnailSize) {
                    this.thumbnailPropertiesThumbnailSize = thumbnailPropertiesThumbnailSize;
                    return this;
                }

                @Override
                public GetThumbnail set(String parameterName, Object value) {
                    return (GetThumbnail)super.set(parameterName, value);
                }
            }

            public class Get
            extends SlidesRequest<Page> {
                private static final String REST_PATH = "v1/presentations/{presentationId}/pages/{pageObjectId}";
                @Key
                private String presentationId;
                @Key
                private String pageObjectId;

                protected Get(String presentationId, String pageObjectId) {
                    super(Slides.this, "GET", REST_PATH, null, Page.class);
                    this.presentationId = (String)Preconditions.checkNotNull((Object)presentationId, (Object)"Required parameter presentationId must be specified.");
                    this.pageObjectId = (String)Preconditions.checkNotNull((Object)pageObjectId, (Object)"Required parameter pageObjectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getPresentationId() {
                    return this.presentationId;
                }

                public Get setPresentationId(String presentationId) {
                    this.presentationId = presentationId;
                    return this;
                }

                public String getPageObjectId() {
                    return this.pageObjectId;
                }

                public Get setPageObjectId(String pageObjectId) {
                    this.pageObjectId = pageObjectId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Get
        extends SlidesRequest<Presentation> {
            private static final String REST_PATH = "v1/presentations/{+presentationId}";
            private final Pattern PRESENTATION_ID_PATTERN;
            @Key
            private String presentationId;

            protected Get(String presentationId) {
                super(Slides.this, "GET", REST_PATH, null, Presentation.class);
                this.PRESENTATION_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.presentationId = (String)Preconditions.checkNotNull((Object)presentationId, (Object)"Required parameter presentationId must be specified.");
                if (!Slides.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PRESENTATION_ID_PATTERN.matcher(presentationId).matches(), (Object)"Parameter presentationId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getPresentationId() {
                return this.presentationId;
            }

            public Get setPresentationId(String presentationId) {
                if (!Slides.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PRESENTATION_ID_PATTERN.matcher(presentationId).matches(), (Object)"Parameter presentationId must conform to the pattern ^[^/]+$");
                }
                this.presentationId = presentationId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends SlidesRequest<Presentation> {
            private static final String REST_PATH = "v1/presentations";

            protected Create(Presentation content) {
                super(Slides.this, "POST", REST_PATH, (Object)content, Presentation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class BatchUpdate
        extends SlidesRequest<BatchUpdatePresentationResponse> {
            private static final String REST_PATH = "v1/presentations/{presentationId}:batchUpdate";
            @Key
            private String presentationId;

            protected BatchUpdate(String presentationId, BatchUpdatePresentationRequest content) {
                super(Slides.this, "POST", REST_PATH, (Object)content, BatchUpdatePresentationResponse.class);
                this.presentationId = (String)Preconditions.checkNotNull((Object)presentationId, (Object)"Required parameter presentationId must be specified.");
            }

            public BatchUpdate set$Xgafv(String $Xgafv) {
                return (BatchUpdate)super.set$Xgafv($Xgafv);
            }

            public BatchUpdate setAccessToken(String accessToken) {
                return (BatchUpdate)super.setAccessToken(accessToken);
            }

            public BatchUpdate setAlt(String alt) {
                return (BatchUpdate)super.setAlt(alt);
            }

            public BatchUpdate setCallback(String callback) {
                return (BatchUpdate)super.setCallback(callback);
            }

            public BatchUpdate setFields(String fields) {
                return (BatchUpdate)super.setFields(fields);
            }

            public BatchUpdate setKey(String key) {
                return (BatchUpdate)super.setKey(key);
            }

            public BatchUpdate setOauthToken(String oauthToken) {
                return (BatchUpdate)super.setOauthToken(oauthToken);
            }

            public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                return (BatchUpdate)super.setPrettyPrint(prettyPrint);
            }

            public BatchUpdate setQuotaUser(String quotaUser) {
                return (BatchUpdate)super.setQuotaUser(quotaUser);
            }

            public BatchUpdate setUploadType(String uploadType) {
                return (BatchUpdate)super.setUploadType(uploadType);
            }

            public BatchUpdate setUploadProtocol(String uploadProtocol) {
                return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
            }

            public String getPresentationId() {
                return this.presentationId;
            }

            public BatchUpdate setPresentationId(String presentationId) {
                this.presentationId = presentationId;
                return this;
            }

            @Override
            public BatchUpdate set(String parameterName, Object value) {
                return (BatchUpdate)super.set(parameterName, value);
            }
        }
    }
}

