/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A PageElement kind representing a video.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Video extends com.google.api.client.json.GenericJson {

  /**
   * The video source's unique identifier for this video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The video source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * An URL to a video. The URL is valid as long as the source video exists and sharing settings do
   * not change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * The properties of the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoProperties videoProperties;

  /**
   * The video source's unique identifier for this video.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The video source's unique identifier for this video.
   * @param id id or {@code null} for none
   */
  public Video setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The video source.
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The video source.
   * @param source source or {@code null} for none
   */
  public Video setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * An URL to a video. The URL is valid as long as the source video exists and sharing settings do
   * not change.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * An URL to a video. The URL is valid as long as the source video exists and sharing settings do
   * not change.
   * @param url url or {@code null} for none
   */
  public Video setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  /**
   * The properties of the video.
   * @return value or {@code null} for none
   */
  public VideoProperties getVideoProperties() {
    return videoProperties;
  }

  /**
   * The properties of the video.
   * @param videoProperties videoProperties or {@code null} for none
   */
  public Video setVideoProperties(VideoProperties videoProperties) {
    this.videoProperties = videoProperties;
    return this;
  }

  @Override
  public Video set(String fieldName, Object value) {
    return (Video) super.set(fieldName, value);
  }

  @Override
  public Video clone() {
    return (Video) super.clone();
  }

}
