/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Update the styling of text in a Shape or Table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateTextStyleRequest extends com.google.api.client.json.GenericJson {

  /**
   * The location of the cell in the table containing the text to style. If `object_id` refers to a
   * table, `cell_location` must have a value. Otherwise, it must not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellLocation cellLocation;

  /**
   * The fields that should be updated. At least one field must be specified. The root `style` is
   * implied and should not be specified. A single `"*"` can be used as short-hand for listing every
   * field. For example, to update the text style to bold, set `fields` to `"bold"`. To reset a
   * property to its default value, include its field name in the field mask but leave the field
   * itself unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The object ID of the shape or table with the text to be styled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The style(s) to set on the text. If the value for a particular style matches that of the
   * parent, that style will be set to inherit. Certain text style changes may cause other changes
   * meant to mirror the behavior of the Slides editor. See the documentation of TextStyle for more
   * information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyle style;

  /**
   * The range of text to style. The range may be extended to include adjacent newlines. If the
   * range fully contains a paragraph belonging to a list, the paragraph's bullet is also updated
   * with the matching text style.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range textRange;

  /**
   * The location of the cell in the table containing the text to style. If `object_id` refers to a
   * table, `cell_location` must have a value. Otherwise, it must not.
   * @return value or {@code null} for none
   */
  public TableCellLocation getCellLocation() {
    return cellLocation;
  }

  /**
   * The location of the cell in the table containing the text to style. If `object_id` refers to a
   * table, `cell_location` must have a value. Otherwise, it must not.
   * @param cellLocation cellLocation or {@code null} for none
   */
  public UpdateTextStyleRequest setCellLocation(TableCellLocation cellLocation) {
    this.cellLocation = cellLocation;
    return this;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root `style` is
   * implied and should not be specified. A single `"*"` can be used as short-hand for listing every
   * field. For example, to update the text style to bold, set `fields` to `"bold"`. To reset a
   * property to its default value, include its field name in the field mask but leave the field
   * itself unset.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root `style` is
   * implied and should not be specified. A single `"*"` can be used as short-hand for listing every
   * field. For example, to update the text style to bold, set `fields` to `"bold"`. To reset a
   * property to its default value, include its field name in the field mask but leave the field
   * itself unset.
   * @param fields fields or {@code null} for none
   */
  public UpdateTextStyleRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The object ID of the shape or table with the text to be styled.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the shape or table with the text to be styled.
   * @param objectId objectId or {@code null} for none
   */
  public UpdateTextStyleRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The style(s) to set on the text. If the value for a particular style matches that of the
   * parent, that style will be set to inherit. Certain text style changes may cause other changes
   * meant to mirror the behavior of the Slides editor. See the documentation of TextStyle for more
   * information.
   * @return value or {@code null} for none
   */
  public TextStyle getStyle() {
    return style;
  }

  /**
   * The style(s) to set on the text. If the value for a particular style matches that of the
   * parent, that style will be set to inherit. Certain text style changes may cause other changes
   * meant to mirror the behavior of the Slides editor. See the documentation of TextStyle for more
   * information.
   * @param style style or {@code null} for none
   */
  public UpdateTextStyleRequest setStyle(TextStyle style) {
    this.style = style;
    return this;
  }

  /**
   * The range of text to style. The range may be extended to include adjacent newlines. If the
   * range fully contains a paragraph belonging to a list, the paragraph's bullet is also updated
   * with the matching text style.
   * @return value or {@code null} for none
   */
  public Range getTextRange() {
    return textRange;
  }

  /**
   * The range of text to style. The range may be extended to include adjacent newlines. If the
   * range fully contains a paragraph belonging to a list, the paragraph's bullet is also updated
   * with the matching text style.
   * @param textRange textRange or {@code null} for none
   */
  public UpdateTextStyleRequest setTextRange(Range textRange) {
    this.textRange = textRange;
    return this;
  }

  @Override
  public UpdateTextStyleRequest set(String fieldName, Object value) {
    return (UpdateTextStyleRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateTextStyleRequest clone() {
    return (UpdateTextStyleRequest) super.clone();
  }

}
