/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Updates the properties of a Table row.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateTableRowPropertiesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableRowProperties` is implied and should not be specified. A single `"*"` can be used as
   * short-hand for listing every field. For example to update the minimum row height, set `fields`
   * to `"min_row_height"`. If '"min_row_height"' is included in the field mask but the property is
   * left unset, the minimum row height will default to 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The object ID of the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The list of zero-based indices specifying which rows to update. If no indices are provided, all
   * rows in the table will be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> rowIndices;

  /**
   * The table row properties to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableRowProperties tableRowProperties;

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableRowProperties` is implied and should not be specified. A single `"*"` can be used as
   * short-hand for listing every field. For example to update the minimum row height, set `fields`
   * to `"min_row_height"`. If '"min_row_height"' is included in the field mask but the property is
   * left unset, the minimum row height will default to 0.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableRowProperties` is implied and should not be specified. A single `"*"` can be used as
   * short-hand for listing every field. For example to update the minimum row height, set `fields`
   * to `"min_row_height"`. If '"min_row_height"' is included in the field mask but the property is
   * left unset, the minimum row height will default to 0.
   * @param fields fields or {@code null} for none
   */
  public UpdateTableRowPropertiesRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The object ID of the table.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the table.
   * @param objectId objectId or {@code null} for none
   */
  public UpdateTableRowPropertiesRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The list of zero-based indices specifying which rows to update. If no indices are provided, all
   * rows in the table will be updated.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getRowIndices() {
    return rowIndices;
  }

  /**
   * The list of zero-based indices specifying which rows to update. If no indices are provided, all
   * rows in the table will be updated.
   * @param rowIndices rowIndices or {@code null} for none
   */
  public UpdateTableRowPropertiesRequest setRowIndices(java.util.List<java.lang.Integer> rowIndices) {
    this.rowIndices = rowIndices;
    return this;
  }

  /**
   * The table row properties to update.
   * @return value or {@code null} for none
   */
  public TableRowProperties getTableRowProperties() {
    return tableRowProperties;
  }

  /**
   * The table row properties to update.
   * @param tableRowProperties tableRowProperties or {@code null} for none
   */
  public UpdateTableRowPropertiesRequest setTableRowProperties(TableRowProperties tableRowProperties) {
    this.tableRowProperties = tableRowProperties;
    return this;
  }

  @Override
  public UpdateTableRowPropertiesRequest set(String fieldName, Object value) {
    return (UpdateTableRowPropertiesRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateTableRowPropertiesRequest clone() {
    return (UpdateTableRowPropertiesRequest) super.clone();
  }

}
