/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Updates the category of a line.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateLineCategoryRequest extends com.google.api.client.json.GenericJson {

  /**
   * The line category to update to. The exact line type is determined based on the category to
   * update to and how it's routed to connect to other page elements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineCategory;

  /**
   * The object ID of the line the update is applied to. Only a line with a category indicating it
   * is a "connector" can be updated. The line may be rerouted after updating its category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The line category to update to. The exact line type is determined based on the category to
   * update to and how it's routed to connect to other page elements.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineCategory() {
    return lineCategory;
  }

  /**
   * The line category to update to. The exact line type is determined based on the category to
   * update to and how it's routed to connect to other page elements.
   * @param lineCategory lineCategory or {@code null} for none
   */
  public UpdateLineCategoryRequest setLineCategory(java.lang.String lineCategory) {
    this.lineCategory = lineCategory;
    return this;
  }

  /**
   * The object ID of the line the update is applied to. Only a line with a category indicating it
   * is a "connector" can be updated. The line may be rerouted after updating its category.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the line the update is applied to. Only a line with a category indicating it
   * is a "connector" can be updated. The line may be rerouted after updating its category.
   * @param objectId objectId or {@code null} for none
   */
  public UpdateLineCategoryRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  @Override
  public UpdateLineCategoryRequest set(String fieldName, Object value) {
    return (UpdateLineCategoryRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateLineCategoryRequest clone() {
    return (UpdateLineCategoryRequest) super.clone();
  }

}
