/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A TextElement describes the content of a range of indices in the text content of a Shape or
 * TableCell.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextElement extends com.google.api.client.json.GenericJson {

  /**
   * A TextElement representing a spot in the text that is dynamically replaced with content that
   * can change over time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoText autoText;

  /**
   * The zero-based end index of this text element, exclusive, in Unicode code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endIndex;

  /**
   * A marker representing the beginning of a new paragraph. The `start_index` and `end_index` of
   * this TextElement represent the range of the paragraph. Other TextElements with an index range
   * contained inside this paragraph's range are considered to be part of this paragraph. The range
   * of indices of two separate paragraphs will never overlap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParagraphMarker paragraphMarker;

  /**
   * The zero-based start index of this text element, in Unicode code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * A TextElement representing a run of text where all of the characters in the run have the same
   * TextStyle. The `start_index` and `end_index` of TextRuns will always be fully contained in the
   * index range of a single `paragraph_marker` TextElement. In other words, a TextRun will never
   * span multiple paragraphs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextRun textRun;

  /**
   * A TextElement representing a spot in the text that is dynamically replaced with content that
   * can change over time.
   * @return value or {@code null} for none
   */
  public AutoText getAutoText() {
    return autoText;
  }

  /**
   * A TextElement representing a spot in the text that is dynamically replaced with content that
   * can change over time.
   * @param autoText autoText or {@code null} for none
   */
  public TextElement setAutoText(AutoText autoText) {
    this.autoText = autoText;
    return this;
  }

  /**
   * The zero-based end index of this text element, exclusive, in Unicode code units.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndIndex() {
    return endIndex;
  }

  /**
   * The zero-based end index of this text element, exclusive, in Unicode code units.
   * @param endIndex endIndex or {@code null} for none
   */
  public TextElement setEndIndex(java.lang.Integer endIndex) {
    this.endIndex = endIndex;
    return this;
  }

  /**
   * A marker representing the beginning of a new paragraph. The `start_index` and `end_index` of
   * this TextElement represent the range of the paragraph. Other TextElements with an index range
   * contained inside this paragraph's range are considered to be part of this paragraph. The range
   * of indices of two separate paragraphs will never overlap.
   * @return value or {@code null} for none
   */
  public ParagraphMarker getParagraphMarker() {
    return paragraphMarker;
  }

  /**
   * A marker representing the beginning of a new paragraph. The `start_index` and `end_index` of
   * this TextElement represent the range of the paragraph. Other TextElements with an index range
   * contained inside this paragraph's range are considered to be part of this paragraph. The range
   * of indices of two separate paragraphs will never overlap.
   * @param paragraphMarker paragraphMarker or {@code null} for none
   */
  public TextElement setParagraphMarker(ParagraphMarker paragraphMarker) {
    this.paragraphMarker = paragraphMarker;
    return this;
  }

  /**
   * The zero-based start index of this text element, in Unicode code units.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The zero-based start index of this text element, in Unicode code units.
   * @param startIndex startIndex or {@code null} for none
   */
  public TextElement setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * A TextElement representing a run of text where all of the characters in the run have the same
   * TextStyle. The `start_index` and `end_index` of TextRuns will always be fully contained in the
   * index range of a single `paragraph_marker` TextElement. In other words, a TextRun will never
   * span multiple paragraphs.
   * @return value or {@code null} for none
   */
  public TextRun getTextRun() {
    return textRun;
  }

  /**
   * A TextElement representing a run of text where all of the characters in the run have the same
   * TextStyle. The `start_index` and `end_index` of TextRuns will always be fully contained in the
   * index range of a single `paragraph_marker` TextElement. In other words, a TextRun will never
   * span multiple paragraphs.
   * @param textRun textRun or {@code null} for none
   */
  public TextElement setTextRun(TextRun textRun) {
    this.textRun = textRun;
    return this;
  }

  @Override
  public TextElement set(String fieldName, Object value) {
    return (TextElement) super.set(fieldName, value);
  }

  @Override
  public TextElement clone() {
    return (TextElement) super.clone();
  }

}
