/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The properties of each border cell.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableBorderCell extends com.google.api.client.json.GenericJson {

  /**
   * The location of the border within the border table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellLocation location;

  /**
   * The border properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableBorderProperties tableBorderProperties;

  /**
   * The location of the border within the border table.
   * @return value or {@code null} for none
   */
  public TableCellLocation getLocation() {
    return location;
  }

  /**
   * The location of the border within the border table.
   * @param location location or {@code null} for none
   */
  public TableBorderCell setLocation(TableCellLocation location) {
    this.location = location;
    return this;
  }

  /**
   * The border properties.
   * @return value or {@code null} for none
   */
  public TableBorderProperties getTableBorderProperties() {
    return tableBorderProperties;
  }

  /**
   * The border properties.
   * @param tableBorderProperties tableBorderProperties or {@code null} for none
   */
  public TableBorderCell setTableBorderProperties(TableBorderProperties tableBorderProperties) {
    this.tableBorderProperties = tableBorderProperties;
    return this;
  }

  @Override
  public TableBorderCell set(String fieldName, Object value) {
    return (TableBorderCell) super.set(fieldName, value);
  }

  @Override
  public TableBorderCell clone() {
    return (TableBorderCell) super.clone();
  }

}
