/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The properties of Page that are only relevant for pages with page_type SLIDE.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SlideProperties extends com.google.api.client.json.GenericJson {

  /**
   * Whether the slide is skipped in the presentation mode. Defaults to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isSkipped;

  /**
   * The object ID of the layout that this slide is based on. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String layoutObjectId;

  /**
   * The object ID of the master that this slide is based on. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String masterObjectId;

  /**
   * The notes page that this slide is associated with. It defines the visual appearance of a notes
   * page when printing or exporting slides with speaker notes. A notes page inherits properties
   * from the notes master. The placeholder shape with type BODY on the notes page contains the
   * speaker notes for this slide. The ID of this shape is identified by the speakerNotesObjectId
   * field. The notes page is read-only except for the text content and styles of the speaker notes
   * shape. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Page notesPage;

  /**
   * Whether the slide is skipped in the presentation mode. Defaults to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsSkipped() {
    return isSkipped;
  }

  /**
   * Whether the slide is skipped in the presentation mode. Defaults to false.
   * @param isSkipped isSkipped or {@code null} for none
   */
  public SlideProperties setIsSkipped(java.lang.Boolean isSkipped) {
    this.isSkipped = isSkipped;
    return this;
  }

  /**
   * The object ID of the layout that this slide is based on. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getLayoutObjectId() {
    return layoutObjectId;
  }

  /**
   * The object ID of the layout that this slide is based on. This property is read-only.
   * @param layoutObjectId layoutObjectId or {@code null} for none
   */
  public SlideProperties setLayoutObjectId(java.lang.String layoutObjectId) {
    this.layoutObjectId = layoutObjectId;
    return this;
  }

  /**
   * The object ID of the master that this slide is based on. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getMasterObjectId() {
    return masterObjectId;
  }

  /**
   * The object ID of the master that this slide is based on. This property is read-only.
   * @param masterObjectId masterObjectId or {@code null} for none
   */
  public SlideProperties setMasterObjectId(java.lang.String masterObjectId) {
    this.masterObjectId = masterObjectId;
    return this;
  }

  /**
   * The notes page that this slide is associated with. It defines the visual appearance of a notes
   * page when printing or exporting slides with speaker notes. A notes page inherits properties
   * from the notes master. The placeholder shape with type BODY on the notes page contains the
   * speaker notes for this slide. The ID of this shape is identified by the speakerNotesObjectId
   * field. The notes page is read-only except for the text content and styles of the speaker notes
   * shape. This property is read-only.
   * @return value or {@code null} for none
   */
  public Page getNotesPage() {
    return notesPage;
  }

  /**
   * The notes page that this slide is associated with. It defines the visual appearance of a notes
   * page when printing or exporting slides with speaker notes. A notes page inherits properties
   * from the notes master. The placeholder shape with type BODY on the notes page contains the
   * speaker notes for this slide. The ID of this shape is identified by the speakerNotesObjectId
   * field. The notes page is read-only except for the text content and styles of the speaker notes
   * shape. This property is read-only.
   * @param notesPage notesPage or {@code null} for none
   */
  public SlideProperties setNotesPage(Page notesPage) {
    this.notesPage = notesPage;
    return this;
  }

  @Override
  public SlideProperties set(String fieldName, Object value) {
    return (SlideProperties) super.set(fieldName, value);
  }

  @Override
  public SlideProperties clone() {
    return (SlideProperties) super.clone();
  }

}
