/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The shape background fill.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShapeBackgroundFill extends com.google.api.client.json.GenericJson {

  /**
   * The background fill property state. Updating the fill on a shape will implicitly update this
   * field to `RENDERED`, unless another value is specified in the same request. To have no fill on
   * a shape, set this field to `NOT_RENDERED`. In this case, any other fill fields set in the same
   * request will be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String propertyState;

  /**
   * Solid color fill.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SolidFill solidFill;

  /**
   * The background fill property state. Updating the fill on a shape will implicitly update this
   * field to `RENDERED`, unless another value is specified in the same request. To have no fill on
   * a shape, set this field to `NOT_RENDERED`. In this case, any other fill fields set in the same
   * request will be ignored.
   * @return value or {@code null} for none
   */
  public java.lang.String getPropertyState() {
    return propertyState;
  }

  /**
   * The background fill property state. Updating the fill on a shape will implicitly update this
   * field to `RENDERED`, unless another value is specified in the same request. To have no fill on
   * a shape, set this field to `NOT_RENDERED`. In this case, any other fill fields set in the same
   * request will be ignored.
   * @param propertyState propertyState or {@code null} for none
   */
  public ShapeBackgroundFill setPropertyState(java.lang.String propertyState) {
    this.propertyState = propertyState;
    return this;
  }

  /**
   * Solid color fill.
   * @return value or {@code null} for none
   */
  public SolidFill getSolidFill() {
    return solidFill;
  }

  /**
   * Solid color fill.
   * @param solidFill solidFill or {@code null} for none
   */
  public ShapeBackgroundFill setSolidFill(SolidFill solidFill) {
    this.solidFill = solidFill;
    return this;
  }

  @Override
  public ShapeBackgroundFill set(String fieldName, Object value) {
    return (ShapeBackgroundFill) super.set(fieldName, value);
  }

  @Override
  public ShapeBackgroundFill clone() {
    return (ShapeBackgroundFill) super.clone();
  }

}
