/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The shadow properties of a page element. If these fields are unset, they may be inherited from a
 * parent placeholder if it exists. If there is no parent, the fields will default to the value used
 * for new page elements created in the Slides editor, which may depend on the page element kind.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Shadow extends com.google.api.client.json.GenericJson {

  /**
   * The alignment point of the shadow, that sets the origin for translate, scale and skew of the
   * shadow. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alignment;

  /**
   * The alpha of the shadow's color, from 0.0 to 1.0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float alpha;

  /**
   * The radius of the shadow blur. The larger the radius, the more diffuse the shadow becomes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension blurRadius;

  /**
   * The shadow color value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OpaqueColor color;

  /**
   * The shadow property state. Updating the shadow on a page element will implicitly update this
   * field to `RENDERED`, unless another value is specified in the same request. To have no shadow
   * on a page element, set this field to `NOT_RENDERED`. In this case, any other shadow fields set
   * in the same request will be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String propertyState;

  /**
   * Whether the shadow should rotate with the shape. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean rotateWithShape;

  /**
   * Transform that encodes the translate, scale, and skew of the shadow, relative to the alignment
   * position.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AffineTransform transform;

  /**
   * The type of the shadow. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The alignment point of the shadow, that sets the origin for translate, scale and skew of the
   * shadow. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlignment() {
    return alignment;
  }

  /**
   * The alignment point of the shadow, that sets the origin for translate, scale and skew of the
   * shadow. This property is read-only.
   * @param alignment alignment or {@code null} for none
   */
  public Shadow setAlignment(java.lang.String alignment) {
    this.alignment = alignment;
    return this;
  }

  /**
   * The alpha of the shadow's color, from 0.0 to 1.0.
   * @return value or {@code null} for none
   */
  public java.lang.Float getAlpha() {
    return alpha;
  }

  /**
   * The alpha of the shadow's color, from 0.0 to 1.0.
   * @param alpha alpha or {@code null} for none
   */
  public Shadow setAlpha(java.lang.Float alpha) {
    this.alpha = alpha;
    return this;
  }

  /**
   * The radius of the shadow blur. The larger the radius, the more diffuse the shadow becomes.
   * @return value or {@code null} for none
   */
  public Dimension getBlurRadius() {
    return blurRadius;
  }

  /**
   * The radius of the shadow blur. The larger the radius, the more diffuse the shadow becomes.
   * @param blurRadius blurRadius or {@code null} for none
   */
  public Shadow setBlurRadius(Dimension blurRadius) {
    this.blurRadius = blurRadius;
    return this;
  }

  /**
   * The shadow color value.
   * @return value or {@code null} for none
   */
  public OpaqueColor getColor() {
    return color;
  }

  /**
   * The shadow color value.
   * @param color color or {@code null} for none
   */
  public Shadow setColor(OpaqueColor color) {
    this.color = color;
    return this;
  }

  /**
   * The shadow property state. Updating the shadow on a page element will implicitly update this
   * field to `RENDERED`, unless another value is specified in the same request. To have no shadow
   * on a page element, set this field to `NOT_RENDERED`. In this case, any other shadow fields set
   * in the same request will be ignored.
   * @return value or {@code null} for none
   */
  public java.lang.String getPropertyState() {
    return propertyState;
  }

  /**
   * The shadow property state. Updating the shadow on a page element will implicitly update this
   * field to `RENDERED`, unless another value is specified in the same request. To have no shadow
   * on a page element, set this field to `NOT_RENDERED`. In this case, any other shadow fields set
   * in the same request will be ignored.
   * @param propertyState propertyState or {@code null} for none
   */
  public Shadow setPropertyState(java.lang.String propertyState) {
    this.propertyState = propertyState;
    return this;
  }

  /**
   * Whether the shadow should rotate with the shape. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRotateWithShape() {
    return rotateWithShape;
  }

  /**
   * Whether the shadow should rotate with the shape. This property is read-only.
   * @param rotateWithShape rotateWithShape or {@code null} for none
   */
  public Shadow setRotateWithShape(java.lang.Boolean rotateWithShape) {
    this.rotateWithShape = rotateWithShape;
    return this;
  }

  /**
   * Transform that encodes the translate, scale, and skew of the shadow, relative to the alignment
   * position.
   * @return value or {@code null} for none
   */
  public AffineTransform getTransform() {
    return transform;
  }

  /**
   * Transform that encodes the translate, scale, and skew of the shadow, relative to the alignment
   * position.
   * @param transform transform or {@code null} for none
   */
  public Shadow setTransform(AffineTransform transform) {
    this.transform = transform;
    return this;
  }

  /**
   * The type of the shadow. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the shadow. This property is read-only.
   * @param type type or {@code null} for none
   */
  public Shadow setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Shadow set(String fieldName, Object value) {
    return (Shadow) super.set(fieldName, value);
  }

  @Override
  public Shadow clone() {
    return (Shadow) super.clone();
  }

}
