/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A single response from an update.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Response extends com.google.api.client.json.GenericJson {

  /**
   * The result of creating an image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateImageResponse createImage;

  /**
   * The result of creating a line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateLineResponse createLine;

  /**
   * The result of creating a shape.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateShapeResponse createShape;

  /**
   * The result of creating a Google Sheets chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateSheetsChartResponse createSheetsChart;

  /**
   * The result of creating a slide.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateSlideResponse createSlide;

  /**
   * The result of creating a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateTableResponse createTable;

  /**
   * The result of creating a video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateVideoResponse createVideo;

  /**
   * The result of duplicating an object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DuplicateObjectResponse duplicateObject;

  /**
   * The result of grouping objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GroupObjectsResponse groupObjects;

  /**
   * The result of replacing all shapes matching some criteria with an image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceAllShapesWithImageResponse replaceAllShapesWithImage;

  /**
   * The result of replacing all shapes matching some criteria with a Google Sheets chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceAllShapesWithSheetsChartResponse replaceAllShapesWithSheetsChart;

  /**
   * The result of replacing text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceAllTextResponse replaceAllText;

  /**
   * The result of creating an image.
   * @return value or {@code null} for none
   */
  public CreateImageResponse getCreateImage() {
    return createImage;
  }

  /**
   * The result of creating an image.
   * @param createImage createImage or {@code null} for none
   */
  public Response setCreateImage(CreateImageResponse createImage) {
    this.createImage = createImage;
    return this;
  }

  /**
   * The result of creating a line.
   * @return value or {@code null} for none
   */
  public CreateLineResponse getCreateLine() {
    return createLine;
  }

  /**
   * The result of creating a line.
   * @param createLine createLine or {@code null} for none
   */
  public Response setCreateLine(CreateLineResponse createLine) {
    this.createLine = createLine;
    return this;
  }

  /**
   * The result of creating a shape.
   * @return value or {@code null} for none
   */
  public CreateShapeResponse getCreateShape() {
    return createShape;
  }

  /**
   * The result of creating a shape.
   * @param createShape createShape or {@code null} for none
   */
  public Response setCreateShape(CreateShapeResponse createShape) {
    this.createShape = createShape;
    return this;
  }

  /**
   * The result of creating a Google Sheets chart.
   * @return value or {@code null} for none
   */
  public CreateSheetsChartResponse getCreateSheetsChart() {
    return createSheetsChart;
  }

  /**
   * The result of creating a Google Sheets chart.
   * @param createSheetsChart createSheetsChart or {@code null} for none
   */
  public Response setCreateSheetsChart(CreateSheetsChartResponse createSheetsChart) {
    this.createSheetsChart = createSheetsChart;
    return this;
  }

  /**
   * The result of creating a slide.
   * @return value or {@code null} for none
   */
  public CreateSlideResponse getCreateSlide() {
    return createSlide;
  }

  /**
   * The result of creating a slide.
   * @param createSlide createSlide or {@code null} for none
   */
  public Response setCreateSlide(CreateSlideResponse createSlide) {
    this.createSlide = createSlide;
    return this;
  }

  /**
   * The result of creating a table.
   * @return value or {@code null} for none
   */
  public CreateTableResponse getCreateTable() {
    return createTable;
  }

  /**
   * The result of creating a table.
   * @param createTable createTable or {@code null} for none
   */
  public Response setCreateTable(CreateTableResponse createTable) {
    this.createTable = createTable;
    return this;
  }

  /**
   * The result of creating a video.
   * @return value or {@code null} for none
   */
  public CreateVideoResponse getCreateVideo() {
    return createVideo;
  }

  /**
   * The result of creating a video.
   * @param createVideo createVideo or {@code null} for none
   */
  public Response setCreateVideo(CreateVideoResponse createVideo) {
    this.createVideo = createVideo;
    return this;
  }

  /**
   * The result of duplicating an object.
   * @return value or {@code null} for none
   */
  public DuplicateObjectResponse getDuplicateObject() {
    return duplicateObject;
  }

  /**
   * The result of duplicating an object.
   * @param duplicateObject duplicateObject or {@code null} for none
   */
  public Response setDuplicateObject(DuplicateObjectResponse duplicateObject) {
    this.duplicateObject = duplicateObject;
    return this;
  }

  /**
   * The result of grouping objects.
   * @return value or {@code null} for none
   */
  public GroupObjectsResponse getGroupObjects() {
    return groupObjects;
  }

  /**
   * The result of grouping objects.
   * @param groupObjects groupObjects or {@code null} for none
   */
  public Response setGroupObjects(GroupObjectsResponse groupObjects) {
    this.groupObjects = groupObjects;
    return this;
  }

  /**
   * The result of replacing all shapes matching some criteria with an image.
   * @return value or {@code null} for none
   */
  public ReplaceAllShapesWithImageResponse getReplaceAllShapesWithImage() {
    return replaceAllShapesWithImage;
  }

  /**
   * The result of replacing all shapes matching some criteria with an image.
   * @param replaceAllShapesWithImage replaceAllShapesWithImage or {@code null} for none
   */
  public Response setReplaceAllShapesWithImage(ReplaceAllShapesWithImageResponse replaceAllShapesWithImage) {
    this.replaceAllShapesWithImage = replaceAllShapesWithImage;
    return this;
  }

  /**
   * The result of replacing all shapes matching some criteria with a Google Sheets chart.
   * @return value or {@code null} for none
   */
  public ReplaceAllShapesWithSheetsChartResponse getReplaceAllShapesWithSheetsChart() {
    return replaceAllShapesWithSheetsChart;
  }

  /**
   * The result of replacing all shapes matching some criteria with a Google Sheets chart.
   * @param replaceAllShapesWithSheetsChart replaceAllShapesWithSheetsChart or {@code null} for none
   */
  public Response setReplaceAllShapesWithSheetsChart(ReplaceAllShapesWithSheetsChartResponse replaceAllShapesWithSheetsChart) {
    this.replaceAllShapesWithSheetsChart = replaceAllShapesWithSheetsChart;
    return this;
  }

  /**
   * The result of replacing text.
   * @return value or {@code null} for none
   */
  public ReplaceAllTextResponse getReplaceAllText() {
    return replaceAllText;
  }

  /**
   * The result of replacing text.
   * @param replaceAllText replaceAllText or {@code null} for none
   */
  public Response setReplaceAllText(ReplaceAllTextResponse replaceAllText) {
    this.replaceAllText = replaceAllText;
    return this;
  }

  @Override
  public Response set(String fieldName, Object value) {
    return (Response) super.set(fieldName, value);
  }

  @Override
  public Response clone() {
    return (Response) super.clone();
  }

}
