/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Replaces all instances of text matching a criteria with replace text.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplaceAllTextRequest extends com.google.api.client.json.GenericJson {

  /**
   * Finds text in a shape matching this substring.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubstringMatchCriteria containsText;

  /**
   * If non-empty, limits the matches to page elements only on the given pages. Returns a 400 bad
   * request error if given the page object ID of a notes master, or if a page with that object ID
   * doesn't exist in the presentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> pageObjectIds;

  /**
   * The text that will replace the matched text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replaceText;

  /**
   * Finds text in a shape matching this substring.
   * @return value or {@code null} for none
   */
  public SubstringMatchCriteria getContainsText() {
    return containsText;
  }

  /**
   * Finds text in a shape matching this substring.
   * @param containsText containsText or {@code null} for none
   */
  public ReplaceAllTextRequest setContainsText(SubstringMatchCriteria containsText) {
    this.containsText = containsText;
    return this;
  }

  /**
   * If non-empty, limits the matches to page elements only on the given pages. Returns a 400 bad
   * request error if given the page object ID of a notes master, or if a page with that object ID
   * doesn't exist in the presentation.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPageObjectIds() {
    return pageObjectIds;
  }

  /**
   * If non-empty, limits the matches to page elements only on the given pages. Returns a 400 bad
   * request error if given the page object ID of a notes master, or if a page with that object ID
   * doesn't exist in the presentation.
   * @param pageObjectIds pageObjectIds or {@code null} for none
   */
  public ReplaceAllTextRequest setPageObjectIds(java.util.List<java.lang.String> pageObjectIds) {
    this.pageObjectIds = pageObjectIds;
    return this;
  }

  /**
   * The text that will replace the matched text.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplaceText() {
    return replaceText;
  }

  /**
   * The text that will replace the matched text.
   * @param replaceText replaceText or {@code null} for none
   */
  public ReplaceAllTextRequest setReplaceText(java.lang.String replaceText) {
    this.replaceText = replaceText;
    return this;
  }

  @Override
  public ReplaceAllTextRequest set(String fieldName, Object value) {
    return (ReplaceAllTextRequest) super.set(fieldName, value);
  }

  @Override
  public ReplaceAllTextRequest clone() {
    return (ReplaceAllTextRequest) super.clone();
  }

}
