/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Styles that apply to a whole paragraph. If this text is contained in a shape with a parent
 * placeholder, then these paragraph styles may be inherited from the parent. Which paragraph styles
 * are inherited depend on the nesting level of lists: * A paragraph not in a list will inherit its
 * paragraph style from the paragraph at the 0 nesting level of the list inside the parent
 * placeholder. * A paragraph in a list will inherit its paragraph style from the paragraph at its
 * corresponding nesting level of the list inside the parent placeholder. Inherited paragraph styles
 * are represented as unset fields in this message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParagraphStyle extends com.google.api.client.json.GenericJson {

  /**
   * The text alignment for this paragraph.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alignment;

  /**
   * The text direction of this paragraph. If unset, the value defaults to LEFT_TO_RIGHT since text
   * direction is not inherited.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String direction;

  /**
   * The amount indentation for the paragraph on the side that corresponds to the end of the text,
   * based on the current text direction. If unset, the value is inherited from the parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension indentEnd;

  /**
   * The amount of indentation for the start of the first line of the paragraph. If unset, the value
   * is inherited from the parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension indentFirstLine;

  /**
   * The amount indentation for the paragraph on the side that corresponds to the start of the text,
   * based on the current text direction. If unset, the value is inherited from the parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension indentStart;

  /**
   * The amount of space between lines, as a percentage of normal, where normal is represented as
   * 100.0. If unset, the value is inherited from the parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float lineSpacing;

  /**
   * The amount of extra space above the paragraph. If unset, the value is inherited from the
   * parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension spaceAbove;

  /**
   * The amount of extra space below the paragraph. If unset, the value is inherited from the
   * parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension spaceBelow;

  /**
   * The spacing mode for the paragraph.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spacingMode;

  /**
   * The text alignment for this paragraph.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlignment() {
    return alignment;
  }

  /**
   * The text alignment for this paragraph.
   * @param alignment alignment or {@code null} for none
   */
  public ParagraphStyle setAlignment(java.lang.String alignment) {
    this.alignment = alignment;
    return this;
  }

  /**
   * The text direction of this paragraph. If unset, the value defaults to LEFT_TO_RIGHT since text
   * direction is not inherited.
   * @return value or {@code null} for none
   */
  public java.lang.String getDirection() {
    return direction;
  }

  /**
   * The text direction of this paragraph. If unset, the value defaults to LEFT_TO_RIGHT since text
   * direction is not inherited.
   * @param direction direction or {@code null} for none
   */
  public ParagraphStyle setDirection(java.lang.String direction) {
    this.direction = direction;
    return this;
  }

  /**
   * The amount indentation for the paragraph on the side that corresponds to the end of the text,
   * based on the current text direction. If unset, the value is inherited from the parent.
   * @return value or {@code null} for none
   */
  public Dimension getIndentEnd() {
    return indentEnd;
  }

  /**
   * The amount indentation for the paragraph on the side that corresponds to the end of the text,
   * based on the current text direction. If unset, the value is inherited from the parent.
   * @param indentEnd indentEnd or {@code null} for none
   */
  public ParagraphStyle setIndentEnd(Dimension indentEnd) {
    this.indentEnd = indentEnd;
    return this;
  }

  /**
   * The amount of indentation for the start of the first line of the paragraph. If unset, the value
   * is inherited from the parent.
   * @return value or {@code null} for none
   */
  public Dimension getIndentFirstLine() {
    return indentFirstLine;
  }

  /**
   * The amount of indentation for the start of the first line of the paragraph. If unset, the value
   * is inherited from the parent.
   * @param indentFirstLine indentFirstLine or {@code null} for none
   */
  public ParagraphStyle setIndentFirstLine(Dimension indentFirstLine) {
    this.indentFirstLine = indentFirstLine;
    return this;
  }

  /**
   * The amount indentation for the paragraph on the side that corresponds to the start of the text,
   * based on the current text direction. If unset, the value is inherited from the parent.
   * @return value or {@code null} for none
   */
  public Dimension getIndentStart() {
    return indentStart;
  }

  /**
   * The amount indentation for the paragraph on the side that corresponds to the start of the text,
   * based on the current text direction. If unset, the value is inherited from the parent.
   * @param indentStart indentStart or {@code null} for none
   */
  public ParagraphStyle setIndentStart(Dimension indentStart) {
    this.indentStart = indentStart;
    return this;
  }

  /**
   * The amount of space between lines, as a percentage of normal, where normal is represented as
   * 100.0. If unset, the value is inherited from the parent.
   * @return value or {@code null} for none
   */
  public java.lang.Float getLineSpacing() {
    return lineSpacing;
  }

  /**
   * The amount of space between lines, as a percentage of normal, where normal is represented as
   * 100.0. If unset, the value is inherited from the parent.
   * @param lineSpacing lineSpacing or {@code null} for none
   */
  public ParagraphStyle setLineSpacing(java.lang.Float lineSpacing) {
    this.lineSpacing = lineSpacing;
    return this;
  }

  /**
   * The amount of extra space above the paragraph. If unset, the value is inherited from the
   * parent.
   * @return value or {@code null} for none
   */
  public Dimension getSpaceAbove() {
    return spaceAbove;
  }

  /**
   * The amount of extra space above the paragraph. If unset, the value is inherited from the
   * parent.
   * @param spaceAbove spaceAbove or {@code null} for none
   */
  public ParagraphStyle setSpaceAbove(Dimension spaceAbove) {
    this.spaceAbove = spaceAbove;
    return this;
  }

  /**
   * The amount of extra space below the paragraph. If unset, the value is inherited from the
   * parent.
   * @return value or {@code null} for none
   */
  public Dimension getSpaceBelow() {
    return spaceBelow;
  }

  /**
   * The amount of extra space below the paragraph. If unset, the value is inherited from the
   * parent.
   * @param spaceBelow spaceBelow or {@code null} for none
   */
  public ParagraphStyle setSpaceBelow(Dimension spaceBelow) {
    this.spaceBelow = spaceBelow;
    return this;
  }

  /**
   * The spacing mode for the paragraph.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpacingMode() {
    return spacingMode;
  }

  /**
   * The spacing mode for the paragraph.
   * @param spacingMode spacingMode or {@code null} for none
   */
  public ParagraphStyle setSpacingMode(java.lang.String spacingMode) {
    this.spacingMode = spacingMode;
    return this;
  }

  @Override
  public ParagraphStyle set(String fieldName, Object value) {
    return (ParagraphStyle) super.set(fieldName, value);
  }

  @Override
  public ParagraphStyle clone() {
    return (ParagraphStyle) super.clone();
  }

}
