/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A page in a presentation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Page extends com.google.api.client.json.GenericJson {

  /**
   * Layout specific properties. Only set if page_type = LAYOUT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LayoutProperties layoutProperties;

  /**
   * Master specific properties. Only set if page_type = MASTER.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MasterProperties masterProperties;

  /**
   * Notes specific properties. Only set if page_type = NOTES.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NotesProperties notesProperties;

  /**
   * The object ID for this page. Object IDs used by Page and PageElement share the same namespace.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The page elements rendered on the page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PageElement> pageElements;

  /**
   * The properties of the page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageProperties pageProperties;

  /**
   * The type of the page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageType;

  /**
   * The revision ID of the presentation containing this page. Can be used in update requests to
   * assert that the presentation revision hasn't changed since the last read operation. Only
   * populated if the user has edit access to the presentation. The format of the revision ID may
   * change over time, so it should be treated opaquely. A returned revision ID is only guaranteed
   * to be valid for 24 hours after it has been returned and cannot be shared across users. If the
   * revision ID is unchanged between calls, then the presentation has not changed. Conversely, a
   * changed ID (for the same presentation and user) usually means the presentation has been
   * updated; however, a changed ID can also be due to internal factors such as ID format changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String revisionId;

  /**
   * Slide specific properties. Only set if page_type = SLIDE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SlideProperties slideProperties;

  /**
   * Layout specific properties. Only set if page_type = LAYOUT.
   * @return value or {@code null} for none
   */
  public LayoutProperties getLayoutProperties() {
    return layoutProperties;
  }

  /**
   * Layout specific properties. Only set if page_type = LAYOUT.
   * @param layoutProperties layoutProperties or {@code null} for none
   */
  public Page setLayoutProperties(LayoutProperties layoutProperties) {
    this.layoutProperties = layoutProperties;
    return this;
  }

  /**
   * Master specific properties. Only set if page_type = MASTER.
   * @return value or {@code null} for none
   */
  public MasterProperties getMasterProperties() {
    return masterProperties;
  }

  /**
   * Master specific properties. Only set if page_type = MASTER.
   * @param masterProperties masterProperties or {@code null} for none
   */
  public Page setMasterProperties(MasterProperties masterProperties) {
    this.masterProperties = masterProperties;
    return this;
  }

  /**
   * Notes specific properties. Only set if page_type = NOTES.
   * @return value or {@code null} for none
   */
  public NotesProperties getNotesProperties() {
    return notesProperties;
  }

  /**
   * Notes specific properties. Only set if page_type = NOTES.
   * @param notesProperties notesProperties or {@code null} for none
   */
  public Page setNotesProperties(NotesProperties notesProperties) {
    this.notesProperties = notesProperties;
    return this;
  }

  /**
   * The object ID for this page. Object IDs used by Page and PageElement share the same namespace.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID for this page. Object IDs used by Page and PageElement share the same namespace.
   * @param objectId objectId or {@code null} for none
   */
  public Page setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The page elements rendered on the page.
   * @return value or {@code null} for none
   */
  public java.util.List<PageElement> getPageElements() {
    return pageElements;
  }

  /**
   * The page elements rendered on the page.
   * @param pageElements pageElements or {@code null} for none
   */
  public Page setPageElements(java.util.List<PageElement> pageElements) {
    this.pageElements = pageElements;
    return this;
  }

  /**
   * The properties of the page.
   * @return value or {@code null} for none
   */
  public PageProperties getPageProperties() {
    return pageProperties;
  }

  /**
   * The properties of the page.
   * @param pageProperties pageProperties or {@code null} for none
   */
  public Page setPageProperties(PageProperties pageProperties) {
    this.pageProperties = pageProperties;
    return this;
  }

  /**
   * The type of the page.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageType() {
    return pageType;
  }

  /**
   * The type of the page.
   * @param pageType pageType or {@code null} for none
   */
  public Page setPageType(java.lang.String pageType) {
    this.pageType = pageType;
    return this;
  }

  /**
   * The revision ID of the presentation containing this page. Can be used in update requests to
   * assert that the presentation revision hasn't changed since the last read operation. Only
   * populated if the user has edit access to the presentation. The format of the revision ID may
   * change over time, so it should be treated opaquely. A returned revision ID is only guaranteed
   * to be valid for 24 hours after it has been returned and cannot be shared across users. If the
   * revision ID is unchanged between calls, then the presentation has not changed. Conversely, a
   * changed ID (for the same presentation and user) usually means the presentation has been
   * updated; however, a changed ID can also be due to internal factors such as ID format changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getRevisionId() {
    return revisionId;
  }

  /**
   * The revision ID of the presentation containing this page. Can be used in update requests to
   * assert that the presentation revision hasn't changed since the last read operation. Only
   * populated if the user has edit access to the presentation. The format of the revision ID may
   * change over time, so it should be treated opaquely. A returned revision ID is only guaranteed
   * to be valid for 24 hours after it has been returned and cannot be shared across users. If the
   * revision ID is unchanged between calls, then the presentation has not changed. Conversely, a
   * changed ID (for the same presentation and user) usually means the presentation has been
   * updated; however, a changed ID can also be due to internal factors such as ID format changes.
   * @param revisionId revisionId or {@code null} for none
   */
  public Page setRevisionId(java.lang.String revisionId) {
    this.revisionId = revisionId;
    return this;
  }

  /**
   * Slide specific properties. Only set if page_type = SLIDE.
   * @return value or {@code null} for none
   */
  public SlideProperties getSlideProperties() {
    return slideProperties;
  }

  /**
   * Slide specific properties. Only set if page_type = SLIDE.
   * @param slideProperties slideProperties or {@code null} for none
   */
  public Page setSlideProperties(SlideProperties slideProperties) {
    this.slideProperties = slideProperties;
    return this;
  }

  @Override
  public Page set(String fieldName, Object value) {
    return (Page) super.set(fieldName, value);
  }

  @Override
  public Page clone() {
    return (Page) super.clone();
  }

}
