/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A themeable solid color value.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OpaqueColor extends com.google.api.client.json.GenericJson {

  /**
   * An opaque RGB color.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RgbColor rgbColor;

  /**
   * An opaque theme color.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String themeColor;

  /**
   * An opaque RGB color.
   * @return value or {@code null} for none
   */
  public RgbColor getRgbColor() {
    return rgbColor;
  }

  /**
   * An opaque RGB color.
   * @param rgbColor rgbColor or {@code null} for none
   */
  public OpaqueColor setRgbColor(RgbColor rgbColor) {
    this.rgbColor = rgbColor;
    return this;
  }

  /**
   * An opaque theme color.
   * @return value or {@code null} for none
   */
  public java.lang.String getThemeColor() {
    return themeColor;
  }

  /**
   * An opaque theme color.
   * @param themeColor themeColor or {@code null} for none
   */
  public OpaqueColor setThemeColor(java.lang.String themeColor) {
    this.themeColor = themeColor;
    return this;
  }

  @Override
  public OpaqueColor set(String fieldName, Object value) {
    return (OpaqueColor) super.set(fieldName, value);
  }

  @Override
  public OpaqueColor clone() {
    return (OpaqueColor) super.clone();
  }

}
