/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The user-specified ID mapping for a placeholder that will be created on a slide from a specified
 * layout.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LayoutPlaceholderIdMapping extends com.google.api.client.json.GenericJson {

  /**
   * The placeholder on a layout that will be applied to a slide. Only type and index are needed.
   * For example, a predefined `TITLE_AND_BODY` layout may usually have a TITLE placeholder with
   * index 0 and a BODY placeholder with index 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Placeholder layoutPlaceholder;

  /**
   * The object ID of the placeholder on a layout that will be applied to a slide.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String layoutPlaceholderObjectId;

  /**
   * A user-supplied object ID for the placeholder identified above that to be created onto a slide.
   * If you specify an ID, it must be unique among all pages and page elements in the presentation.
   * The ID must start with an alphanumeric character or an underscore (matches regex
   * `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or colon (matches
   * regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater than 50. If
   * you don't specify an ID, a unique one is generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The placeholder on a layout that will be applied to a slide. Only type and index are needed.
   * For example, a predefined `TITLE_AND_BODY` layout may usually have a TITLE placeholder with
   * index 0 and a BODY placeholder with index 0.
   * @return value or {@code null} for none
   */
  public Placeholder getLayoutPlaceholder() {
    return layoutPlaceholder;
  }

  /**
   * The placeholder on a layout that will be applied to a slide. Only type and index are needed.
   * For example, a predefined `TITLE_AND_BODY` layout may usually have a TITLE placeholder with
   * index 0 and a BODY placeholder with index 0.
   * @param layoutPlaceholder layoutPlaceholder or {@code null} for none
   */
  public LayoutPlaceholderIdMapping setLayoutPlaceholder(Placeholder layoutPlaceholder) {
    this.layoutPlaceholder = layoutPlaceholder;
    return this;
  }

  /**
   * The object ID of the placeholder on a layout that will be applied to a slide.
   * @return value or {@code null} for none
   */
  public java.lang.String getLayoutPlaceholderObjectId() {
    return layoutPlaceholderObjectId;
  }

  /**
   * The object ID of the placeholder on a layout that will be applied to a slide.
   * @param layoutPlaceholderObjectId layoutPlaceholderObjectId or {@code null} for none
   */
  public LayoutPlaceholderIdMapping setLayoutPlaceholderObjectId(java.lang.String layoutPlaceholderObjectId) {
    this.layoutPlaceholderObjectId = layoutPlaceholderObjectId;
    return this;
  }

  /**
   * A user-supplied object ID for the placeholder identified above that to be created onto a slide.
   * If you specify an ID, it must be unique among all pages and page elements in the presentation.
   * The ID must start with an alphanumeric character or an underscore (matches regex
   * `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or colon (matches
   * regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater than 50. If
   * you don't specify an ID, a unique one is generated.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * A user-supplied object ID for the placeholder identified above that to be created onto a slide.
   * If you specify an ID, it must be unique among all pages and page elements in the presentation.
   * The ID must start with an alphanumeric character or an underscore (matches regex
   * `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or colon (matches
   * regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater than 50. If
   * you don't specify an ID, a unique one is generated.
   * @param objectId objectId or {@code null} for none
   */
  public LayoutPlaceholderIdMapping setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  @Override
  public LayoutPlaceholderIdMapping set(String fieldName, Object value) {
    return (LayoutPlaceholderIdMapping) super.set(fieldName, value);
  }

  @Override
  public LayoutPlaceholderIdMapping clone() {
    return (LayoutPlaceholderIdMapping) super.clone();
  }

}
