/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The properties of the Image.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImageProperties extends com.google.api.client.json.GenericJson {

  /**
   * The brightness effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float brightness;

  /**
   * The contrast effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float contrast;

  /**
   * The crop properties of the image. If not set, the image is not cropped. This property is read-
   * only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CropProperties cropProperties;

  /**
   * The hyperlink destination of the image. If unset, there is no link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Link link;

  /**
   * The outline of the image. If not set, the image has no outline.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Outline outline;

  /**
   * The recolor effect of the image. If not set, the image is not recolored. This property is read-
   * only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Recolor recolor;

  /**
   * The shadow of the image. If not set, the image has no shadow. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Shadow shadow;

  /**
   * The transparency effect of the image. The value should be in the interval [0.0, 1.0], where 0
   * means no effect and 1 means completely transparent. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float transparency;

  /**
   * The brightness effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.Float getBrightness() {
    return brightness;
  }

  /**
   * The brightness effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect. This property is read-only.
   * @param brightness brightness or {@code null} for none
   */
  public ImageProperties setBrightness(java.lang.Float brightness) {
    this.brightness = brightness;
    return this;
  }

  /**
   * The contrast effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.Float getContrast() {
    return contrast;
  }

  /**
   * The contrast effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect. This property is read-only.
   * @param contrast contrast or {@code null} for none
   */
  public ImageProperties setContrast(java.lang.Float contrast) {
    this.contrast = contrast;
    return this;
  }

  /**
   * The crop properties of the image. If not set, the image is not cropped. This property is read-
   * only.
   * @return value or {@code null} for none
   */
  public CropProperties getCropProperties() {
    return cropProperties;
  }

  /**
   * The crop properties of the image. If not set, the image is not cropped. This property is read-
   * only.
   * @param cropProperties cropProperties or {@code null} for none
   */
  public ImageProperties setCropProperties(CropProperties cropProperties) {
    this.cropProperties = cropProperties;
    return this;
  }

  /**
   * The hyperlink destination of the image. If unset, there is no link.
   * @return value or {@code null} for none
   */
  public Link getLink() {
    return link;
  }

  /**
   * The hyperlink destination of the image. If unset, there is no link.
   * @param link link or {@code null} for none
   */
  public ImageProperties setLink(Link link) {
    this.link = link;
    return this;
  }

  /**
   * The outline of the image. If not set, the image has no outline.
   * @return value or {@code null} for none
   */
  public Outline getOutline() {
    return outline;
  }

  /**
   * The outline of the image. If not set, the image has no outline.
   * @param outline outline or {@code null} for none
   */
  public ImageProperties setOutline(Outline outline) {
    this.outline = outline;
    return this;
  }

  /**
   * The recolor effect of the image. If not set, the image is not recolored. This property is read-
   * only.
   * @return value or {@code null} for none
   */
  public Recolor getRecolor() {
    return recolor;
  }

  /**
   * The recolor effect of the image. If not set, the image is not recolored. This property is read-
   * only.
   * @param recolor recolor or {@code null} for none
   */
  public ImageProperties setRecolor(Recolor recolor) {
    this.recolor = recolor;
    return this;
  }

  /**
   * The shadow of the image. If not set, the image has no shadow. This property is read-only.
   * @return value or {@code null} for none
   */
  public Shadow getShadow() {
    return shadow;
  }

  /**
   * The shadow of the image. If not set, the image has no shadow. This property is read-only.
   * @param shadow shadow or {@code null} for none
   */
  public ImageProperties setShadow(Shadow shadow) {
    this.shadow = shadow;
    return this;
  }

  /**
   * The transparency effect of the image. The value should be in the interval [0.0, 1.0], where 0
   * means no effect and 1 means completely transparent. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.Float getTransparency() {
    return transparency;
  }

  /**
   * The transparency effect of the image. The value should be in the interval [0.0, 1.0], where 0
   * means no effect and 1 means completely transparent. This property is read-only.
   * @param transparency transparency or {@code null} for none
   */
  public ImageProperties setTransparency(java.lang.Float transparency) {
    this.transparency = transparency;
    return this;
  }

  @Override
  public ImageProperties set(String fieldName, Object value) {
    return (ImageProperties) super.set(fieldName, value);
  }

  @Override
  public ImageProperties clone() {
    return (ImageProperties) super.clone();
  }

}
