/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Deletes bullets from all of the paragraphs that overlap with the given text index range. The
 * nesting level of each paragraph will be visually preserved by adding indent to the start of the
 * corresponding paragraph.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteParagraphBulletsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The optional table cell location if the text to be modified is in a table cell. If present, the
   * object_id must refer to a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellLocation cellLocation;

  /**
   * The object ID of the shape or table containing the text to delete bullets from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The range of text to delete bullets from, based on TextElement indexes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range textRange;

  /**
   * The optional table cell location if the text to be modified is in a table cell. If present, the
   * object_id must refer to a table.
   * @return value or {@code null} for none
   */
  public TableCellLocation getCellLocation() {
    return cellLocation;
  }

  /**
   * The optional table cell location if the text to be modified is in a table cell. If present, the
   * object_id must refer to a table.
   * @param cellLocation cellLocation or {@code null} for none
   */
  public DeleteParagraphBulletsRequest setCellLocation(TableCellLocation cellLocation) {
    this.cellLocation = cellLocation;
    return this;
  }

  /**
   * The object ID of the shape or table containing the text to delete bullets from.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the shape or table containing the text to delete bullets from.
   * @param objectId objectId or {@code null} for none
   */
  public DeleteParagraphBulletsRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The range of text to delete bullets from, based on TextElement indexes.
   * @return value or {@code null} for none
   */
  public Range getTextRange() {
    return textRange;
  }

  /**
   * The range of text to delete bullets from, based on TextElement indexes.
   * @param textRange textRange or {@code null} for none
   */
  public DeleteParagraphBulletsRequest setTextRange(Range textRange) {
    this.textRange = textRange;
    return this;
  }

  @Override
  public DeleteParagraphBulletsRequest set(String fieldName, Object value) {
    return (DeleteParagraphBulletsRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteParagraphBulletsRequest clone() {
    return (DeleteParagraphBulletsRequest) super.clone();
  }

}
