/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A color and position in a gradient band.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ColorStop extends com.google.api.client.json.GenericJson {

  /**
   * The alpha value of this color in the gradient band. Defaults to 1.0, fully opaque.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float alpha;

  /**
   * The color of the gradient stop.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OpaqueColor color;

  /**
   * The relative position of the color stop in the gradient band measured in percentage. The value
   * should be in the interval [0.0, 1.0].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float position;

  /**
   * The alpha value of this color in the gradient band. Defaults to 1.0, fully opaque.
   * @return value or {@code null} for none
   */
  public java.lang.Float getAlpha() {
    return alpha;
  }

  /**
   * The alpha value of this color in the gradient band. Defaults to 1.0, fully opaque.
   * @param alpha alpha or {@code null} for none
   */
  public ColorStop setAlpha(java.lang.Float alpha) {
    this.alpha = alpha;
    return this;
  }

  /**
   * The color of the gradient stop.
   * @return value or {@code null} for none
   */
  public OpaqueColor getColor() {
    return color;
  }

  /**
   * The color of the gradient stop.
   * @param color color or {@code null} for none
   */
  public ColorStop setColor(OpaqueColor color) {
    this.color = color;
    return this;
  }

  /**
   * The relative position of the color stop in the gradient band measured in percentage. The value
   * should be in the interval [0.0, 1.0].
   * @return value or {@code null} for none
   */
  public java.lang.Float getPosition() {
    return position;
  }

  /**
   * The relative position of the color stop in the gradient band measured in percentage. The value
   * should be in the interval [0.0, 1.0].
   * @param position position or {@code null} for none
   */
  public ColorStop setPosition(java.lang.Float position) {
    this.position = position;
    return this;
  }

  @Override
  public ColorStop set(String fieldName, Object value) {
    return (ColorStop) super.set(fieldName, value);
  }

  @Override
  public ColorStop clone() {
    return (ColorStop) super.clone();
  }

}
