/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A TextElement kind that represents auto text.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoText extends com.google.api.client.json.GenericJson {

  /**
   * The rendered content of this auto text, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * The styling applied to this auto text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyle style;

  /**
   * The type of this auto text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The rendered content of this auto text, if available.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The rendered content of this auto text, if available.
   * @param content content or {@code null} for none
   */
  public AutoText setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * The styling applied to this auto text.
   * @return value or {@code null} for none
   */
  public TextStyle getStyle() {
    return style;
  }

  /**
   * The styling applied to this auto text.
   * @param style style or {@code null} for none
   */
  public AutoText setStyle(TextStyle style) {
    this.style = style;
    return this;
  }

  /**
   * The type of this auto text.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of this auto text.
   * @param type type or {@code null} for none
   */
  public AutoText setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public AutoText set(String fieldName, Object value) {
    return (AutoText) super.set(fieldName, value);
  }

  @Override
  public AutoText clone() {
    return (AutoText) super.clone();
  }

}
