/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.plus;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.plus.PlusRequest;
import com.google.api.services.plus.PlusRequestInitializer;
import com.google.api.services.plus.model.Activity;
import com.google.api.services.plus.model.ActivityFeed;
import com.google.api.services.plus.model.Comment;
import com.google.api.services.plus.model.CommentFeed;
import com.google.api.services.plus.model.PeopleFeed;
import com.google.api.services.plus.model.Person;
import java.io.IOException;

public class Plus
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "plus/v1/";
    public static final String DEFAULT_BATCH_PATH = "batch/plus/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/plus/v1/";

    public Plus(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Plus(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Activities activities() {
        return new Activities();
    }

    public Comments comments() {
        return new Comments();
    }

    public People people() {
        return new People();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.28.0 of the Google+ API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Plus.DEFAULT_ROOT_URL, Plus.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Plus.DEFAULT_BATCH_PATH);
        }

        public Plus build() {
            return new Plus(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setPlusRequestInitializer(PlusRequestInitializer plusRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)plusRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class People {
        public Get get(String userId) throws IOException {
            Get result = new Get(userId);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String userId, String collection) throws IOException {
            List result = new List(userId, collection);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListByActivity listByActivity(String activityId, String collection) throws IOException {
            ListByActivity result = new ListByActivity(activityId, collection);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search(String query) throws IOException {
            Search result = new Search(query);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "people";
            @Key
            private String query;
            @Key
            private String language;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected Search(String query) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"Required parameter query must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUserIp(String userIp) {
                return (Search)super.setUserIp(userIp);
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Search setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class ListByActivity
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "activities/{activityId}/people/{collection}";
            @Key
            private String activityId;
            @Key
            private String collection;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected ListByActivity(String activityId, String collection) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)activityId, (Object)"Required parameter activityId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListByActivity setAlt(String alt) {
                return (ListByActivity)super.setAlt(alt);
            }

            public ListByActivity setFields(String fields) {
                return (ListByActivity)super.setFields(fields);
            }

            public ListByActivity setKey(String key) {
                return (ListByActivity)super.setKey(key);
            }

            public ListByActivity setOauthToken(String oauthToken) {
                return (ListByActivity)super.setOauthToken(oauthToken);
            }

            public ListByActivity setPrettyPrint(Boolean prettyPrint) {
                return (ListByActivity)super.setPrettyPrint(prettyPrint);
            }

            public ListByActivity setQuotaUser(String quotaUser) {
                return (ListByActivity)super.setQuotaUser(quotaUser);
            }

            public ListByActivity setUserIp(String userIp) {
                return (ListByActivity)super.setUserIp(userIp);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public ListByActivity setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListByActivity setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByActivity setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByActivity setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListByActivity set(String parameterName, Object value) {
                return (ListByActivity)super.set(parameterName, value);
            }
        }

        public class List
        extends PlusRequest<PeopleFeed> {
            private static final String REST_PATH = "people/{userId}/people/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String userId, String collection) {
                super(Plus.this, "GET", REST_PATH, null, PeopleFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends PlusRequest<Person> {
            private static final String REST_PATH = "people/{userId}";
            @Key
            private String userId;

            protected Get(String userId) {
                super(Plus.this, "GET", REST_PATH, null, Person.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Comments {
        public Get get(String commentId) throws IOException {
            Get result = new Get(commentId);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String activityId) throws IOException {
            List result = new List(activityId);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends PlusRequest<CommentFeed> {
            private static final String REST_PATH = "activities/{activityId}/comments";
            @Key
            private String activityId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortOrder;

            protected List(String activityId) {
                super(Plus.this, "GET", REST_PATH, null, CommentFeed.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)activityId, (Object)"Required parameter activityId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public List setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends PlusRequest<Comment> {
            private static final String REST_PATH = "comments/{commentId}";
            @Key
            private String commentId;

            protected Get(String commentId) {
                super(Plus.this, "GET", REST_PATH, null, Comment.class);
                this.commentId = (String)Preconditions.checkNotNull((Object)commentId, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Activities {
        public Get get(String activityId) throws IOException {
            Get result = new Get(activityId);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String userId, String collection) throws IOException {
            List result = new List(userId, collection);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search(String query) throws IOException {
            Search result = new Search(query);
            Plus.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends PlusRequest<ActivityFeed> {
            private static final String REST_PATH = "activities";
            @Key
            private String query;
            @Key
            private String language;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected Search(String query) {
                super(Plus.this, "GET", REST_PATH, null, ActivityFeed.class);
                this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"Required parameter query must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUserIp(String userIp) {
                return (Search)super.setUserIp(userIp);
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Search setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Search setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class List
        extends PlusRequest<ActivityFeed> {
            private static final String REST_PATH = "people/{userId}/activities/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String userId, String collection) {
                super(Plus.this, "GET", REST_PATH, null, ActivityFeed.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends PlusRequest<Activity> {
            private static final String REST_PATH = "activities/{activityId}";
            @Key
            private String activityId;

            protected Get(String activityId) {
                super(Plus.this, "GET", REST_PATH, null, Activity.class);
                this.activityId = (String)Preconditions.checkNotNull((Object)activityId, (Object)"Required parameter activityId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public Get setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

