/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.iam.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.iam.v1.IamRequest;
import com.google.api.services.iam.v1.IamRequestInitializer;
import com.google.api.services.iam.v1.model.CreateRoleRequest;
import com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest;
import com.google.api.services.iam.v1.model.CreateServiceAccountRequest;
import com.google.api.services.iam.v1.model.Empty;
import com.google.api.services.iam.v1.model.ListRolesResponse;
import com.google.api.services.iam.v1.model.ListServiceAccountKeysResponse;
import com.google.api.services.iam.v1.model.ListServiceAccountsResponse;
import com.google.api.services.iam.v1.model.Policy;
import com.google.api.services.iam.v1.model.QueryGrantableRolesRequest;
import com.google.api.services.iam.v1.model.QueryGrantableRolesResponse;
import com.google.api.services.iam.v1.model.QueryTestablePermissionsRequest;
import com.google.api.services.iam.v1.model.QueryTestablePermissionsResponse;
import com.google.api.services.iam.v1.model.Role;
import com.google.api.services.iam.v1.model.ServiceAccount;
import com.google.api.services.iam.v1.model.ServiceAccountKey;
import com.google.api.services.iam.v1.model.SetIamPolicyRequest;
import com.google.api.services.iam.v1.model.SignBlobRequest;
import com.google.api.services.iam.v1.model.SignBlobResponse;
import com.google.api.services.iam.v1.model.SignJwtRequest;
import com.google.api.services.iam.v1.model.SignJwtResponse;
import com.google.api.services.iam.v1.model.TestIamPermissionsRequest;
import com.google.api.services.iam.v1.model.TestIamPermissionsResponse;
import com.google.api.services.iam.v1.model.UndeleteRoleRequest;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iam
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://iam.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://iam.googleapis.com/";

    public Iam(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Iam(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Permissions permissions() {
        return new Permissions();
    }

    public Projects projects() {
        return new Projects();
    }

    public Roles roles() {
        return new Roles();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google Identity and Access Management (IAM) API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://iam.googleapis.com/", Iam.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Iam build() {
            return new Iam(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setIamRequestInitializer(IamRequestInitializer iamRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)iamRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Roles {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public QueryGrantableRoles queryGrantableRoles(QueryGrantableRolesRequest queryGrantableRolesRequest) throws IOException {
            QueryGrantableRoles queryGrantableRoles = new QueryGrantableRoles(queryGrantableRolesRequest);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)queryGrantableRoles);
            return queryGrantableRoles;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QueryGrantableRoles
        extends IamRequest<QueryGrantableRolesResponse> {
            private static final String REST_PATH = "v1/roles:queryGrantableRoles";

            protected QueryGrantableRoles(QueryGrantableRolesRequest queryGrantableRolesRequest) {
                super(Iam.this, "POST", REST_PATH, (Object)queryGrantableRolesRequest, QueryGrantableRolesResponse.class);
            }

            public QueryGrantableRoles set$Xgafv(String string) {
                return (QueryGrantableRoles)super.set$Xgafv(string);
            }

            public QueryGrantableRoles setAccessToken(String string) {
                return (QueryGrantableRoles)super.setAccessToken(string);
            }

            public QueryGrantableRoles setAlt(String string) {
                return (QueryGrantableRoles)super.setAlt(string);
            }

            public QueryGrantableRoles setBearerToken(String string) {
                return (QueryGrantableRoles)super.setBearerToken(string);
            }

            public QueryGrantableRoles setCallback(String string) {
                return (QueryGrantableRoles)super.setCallback(string);
            }

            public QueryGrantableRoles setFields(String string) {
                return (QueryGrantableRoles)super.setFields(string);
            }

            public QueryGrantableRoles setKey(String string) {
                return (QueryGrantableRoles)super.setKey(string);
            }

            public QueryGrantableRoles setOauthToken(String string) {
                return (QueryGrantableRoles)super.setOauthToken(string);
            }

            public QueryGrantableRoles setPp(Boolean bl) {
                return (QueryGrantableRoles)super.setPp(bl);
            }

            public QueryGrantableRoles setPrettyPrint(Boolean bl) {
                return (QueryGrantableRoles)super.setPrettyPrint(bl);
            }

            public QueryGrantableRoles setQuotaUser(String string) {
                return (QueryGrantableRoles)super.setQuotaUser(string);
            }

            public QueryGrantableRoles setUploadType(String string) {
                return (QueryGrantableRoles)super.setUploadType(string);
            }

            public QueryGrantableRoles setUploadProtocol(String string) {
                return (QueryGrantableRoles)super.setUploadProtocol(string);
            }

            @Override
            public QueryGrantableRoles set(String string, Object object) {
                return (QueryGrantableRoles)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends IamRequest<ListRolesResponse> {
            private static final String REST_PATH = "v1/roles";
            @Key
            private Boolean showDeleted;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;
            @Key
            private String view;
            @Key
            private String parent;

            protected List() {
                super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean bl) {
                this.showDeleted = bl;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String string) {
                this.view = string;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String string) {
                this.parent = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends IamRequest<Role> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(Iam.this, "GET", REST_PATH, null, Role.class);
                this.NAME_PATTERN = Pattern.compile("^roles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^roles/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^roles/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Roles roles() {
            return new Roles();
        }

        public ServiceAccounts serviceAccounts() {
            return new ServiceAccounts();
        }

        public class ServiceAccounts {
            public Create create(String string, CreateServiceAccountRequest createServiceAccountRequest) throws IOException {
                Create create = new Create(string, createServiceAccountRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public SignBlob signBlob(String string, SignBlobRequest signBlobRequest) throws IOException {
                SignBlob signBlob = new SignBlob(string, signBlobRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)signBlob);
                return signBlob;
            }

            public SignJwt signJwt(String string, SignJwtRequest signJwtRequest) throws IOException {
                SignJwt signJwt = new SignJwt(string, signJwtRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)signJwt);
                return signJwt;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            public Update update(String string, ServiceAccount serviceAccount) throws IOException {
                Update update = new Update(string, serviceAccount);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            public Keys keys() {
                return new Keys();
            }

            public class Keys {
                public Create create(String string, CreateServiceAccountKeyRequest createServiceAccountKeyRequest) throws IOException {
                    Create create = new Create(string, createServiceAccountKeyRequest);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends IamRequest<ListServiceAccountKeysResponse> {
                    private static final String REST_PATH = "v1/{+name}/keys";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private java.util.List<String> keyTypes;

                    protected List(String string) {
                        super(Iam.this, "GET", REST_PATH, null, ListServiceAccountKeysResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public java.util.List<String> getKeyTypes() {
                        return this.keyTypes;
                    }

                    public List setKeyTypes(java.util.List<String> list) {
                        this.keyTypes = list;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String publicKeyType;

                    protected Get(String string) {
                        super(Iam.this, "GET", REST_PATH, null, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getPublicKeyType() {
                        return this.publicKeyType;
                    }

                    public Get setPublicKeyType(String string) {
                        this.publicKeyType = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends IamRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Iam.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}/keys";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Create(String string, CreateServiceAccountKeyRequest createServiceAccountKeyRequest) {
                        super(Iam.this, "POST", REST_PATH, (Object)createServiceAccountKeyRequest, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Create setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Update(String string, ServiceAccount serviceAccount) {
                    super(Iam.this, "PUT", REST_PATH, (Object)serviceAccount, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends IamRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setBearerToken(String string) {
                    return (TestIamPermissions)super.setBearerToken(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPp(Boolean bl) {
                    return (TestIamPermissions)super.setPp(bl);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SignJwt
            extends IamRequest<SignJwtResponse> {
                private static final String REST_PATH = "v1/{+name}:signJwt";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignJwt(String string, SignJwtRequest signJwtRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)signJwtRequest, SignJwtResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignJwt set$Xgafv(String string) {
                    return (SignJwt)super.set$Xgafv(string);
                }

                public SignJwt setAccessToken(String string) {
                    return (SignJwt)super.setAccessToken(string);
                }

                public SignJwt setAlt(String string) {
                    return (SignJwt)super.setAlt(string);
                }

                public SignJwt setBearerToken(String string) {
                    return (SignJwt)super.setBearerToken(string);
                }

                public SignJwt setCallback(String string) {
                    return (SignJwt)super.setCallback(string);
                }

                public SignJwt setFields(String string) {
                    return (SignJwt)super.setFields(string);
                }

                public SignJwt setKey(String string) {
                    return (SignJwt)super.setKey(string);
                }

                public SignJwt setOauthToken(String string) {
                    return (SignJwt)super.setOauthToken(string);
                }

                public SignJwt setPp(Boolean bl) {
                    return (SignJwt)super.setPp(bl);
                }

                public SignJwt setPrettyPrint(Boolean bl) {
                    return (SignJwt)super.setPrettyPrint(bl);
                }

                public SignJwt setQuotaUser(String string) {
                    return (SignJwt)super.setQuotaUser(string);
                }

                public SignJwt setUploadType(String string) {
                    return (SignJwt)super.setUploadType(string);
                }

                public SignJwt setUploadProtocol(String string) {
                    return (SignJwt)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public SignJwt setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public SignJwt set(String string, Object object) {
                    return (SignJwt)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SignBlob
            extends IamRequest<SignBlobResponse> {
                private static final String REST_PATH = "v1/{+name}:signBlob";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignBlob(String string, SignBlobRequest signBlobRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)signBlobRequest, SignBlobResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignBlob set$Xgafv(String string) {
                    return (SignBlob)super.set$Xgafv(string);
                }

                public SignBlob setAccessToken(String string) {
                    return (SignBlob)super.setAccessToken(string);
                }

                public SignBlob setAlt(String string) {
                    return (SignBlob)super.setAlt(string);
                }

                public SignBlob setBearerToken(String string) {
                    return (SignBlob)super.setBearerToken(string);
                }

                public SignBlob setCallback(String string) {
                    return (SignBlob)super.setCallback(string);
                }

                public SignBlob setFields(String string) {
                    return (SignBlob)super.setFields(string);
                }

                public SignBlob setKey(String string) {
                    return (SignBlob)super.setKey(string);
                }

                public SignBlob setOauthToken(String string) {
                    return (SignBlob)super.setOauthToken(string);
                }

                public SignBlob setPp(Boolean bl) {
                    return (SignBlob)super.setPp(bl);
                }

                public SignBlob setPrettyPrint(Boolean bl) {
                    return (SignBlob)super.setPrettyPrint(bl);
                }

                public SignBlob setQuotaUser(String string) {
                    return (SignBlob)super.setQuotaUser(string);
                }

                public SignBlob setUploadType(String string) {
                    return (SignBlob)super.setUploadType(string);
                }

                public SignBlob setUploadProtocol(String string) {
                    return (SignBlob)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public SignBlob setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public SignBlob set(String string, Object object) {
                    return (SignBlob)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends IamRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setBearerToken(String string) {
                    return (SetIamPolicy)super.setBearerToken(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPp(Boolean bl) {
                    return (SetIamPolicy)super.setPp(bl);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends IamRequest<ListServiceAccountsResponse> {
                private static final String REST_PATH = "v1/{+name}/serviceAccounts";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ListServiceAccountsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends IamRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string) {
                    super(Iam.this, "POST", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setBearerToken(String string) {
                    return (GetIamPolicy)super.setBearerToken(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPp(Boolean bl) {
                    return (GetIamPolicy)super.setPp(bl);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends IamRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String string) {
                    super(Iam.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}/serviceAccounts";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String string, CreateServiceAccountRequest createServiceAccountRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)createServiceAccountRequest, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Roles {
            public Create create(String string, CreateRoleRequest createRoleRequest) throws IOException {
                Create create = new Create(string, createRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, Role role) throws IOException {
                Patch patch = new Patch(string, role);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Undelete undelete(String string, UndeleteRoleRequest undeleteRoleRequest) throws IOException {
                Undelete undelete = new Undelete(string, undeleteRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)undelete);
                return undelete;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Undelete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String string, UndeleteRoleRequest undeleteRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)undeleteRoleRequest, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String string) {
                    return (Undelete)super.set$Xgafv(string);
                }

                public Undelete setAccessToken(String string) {
                    return (Undelete)super.setAccessToken(string);
                }

                public Undelete setAlt(String string) {
                    return (Undelete)super.setAlt(string);
                }

                public Undelete setBearerToken(String string) {
                    return (Undelete)super.setBearerToken(string);
                }

                public Undelete setCallback(String string) {
                    return (Undelete)super.setCallback(string);
                }

                public Undelete setFields(String string) {
                    return (Undelete)super.setFields(string);
                }

                public Undelete setKey(String string) {
                    return (Undelete)super.setKey(string);
                }

                public Undelete setOauthToken(String string) {
                    return (Undelete)super.setOauthToken(string);
                }

                public Undelete setPp(Boolean bl) {
                    return (Undelete)super.setPp(bl);
                }

                public Undelete setPrettyPrint(Boolean bl) {
                    return (Undelete)super.setPrettyPrint(bl);
                }

                public Undelete setQuotaUser(String string) {
                    return (Undelete)super.setQuotaUser(string);
                }

                public Undelete setUploadType(String string) {
                    return (Undelete)super.setUploadType(string);
                }

                public Undelete setUploadProtocol(String string) {
                    return (Undelete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Undelete set(String string, Object object) {
                    return (Undelete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String string, Role role) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)role, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends IamRequest<ListRolesResponse> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String view;
                @Key
                private Boolean showDeleted;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String string) {
                    this.view = string;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean bl) {
                    this.showDeleted = bl;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Iam.this, "GET", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String etag;

                protected Delete(String string) {
                    super(Iam.this, "DELETE", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getEtag() {
                    return this.etag;
                }

                public Delete setEtag(String string) {
                    this.etag = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String string, CreateRoleRequest createRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)createRoleRequest, Role.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }
    }

    public class Permissions {
        public QueryTestablePermissions queryTestablePermissions(QueryTestablePermissionsRequest queryTestablePermissionsRequest) throws IOException {
            QueryTestablePermissions queryTestablePermissions = new QueryTestablePermissions(queryTestablePermissionsRequest);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)queryTestablePermissions);
            return queryTestablePermissions;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QueryTestablePermissions
        extends IamRequest<QueryTestablePermissionsResponse> {
            private static final String REST_PATH = "v1/permissions:queryTestablePermissions";

            protected QueryTestablePermissions(QueryTestablePermissionsRequest queryTestablePermissionsRequest) {
                super(Iam.this, "POST", REST_PATH, (Object)queryTestablePermissionsRequest, QueryTestablePermissionsResponse.class);
            }

            public QueryTestablePermissions set$Xgafv(String string) {
                return (QueryTestablePermissions)super.set$Xgafv(string);
            }

            public QueryTestablePermissions setAccessToken(String string) {
                return (QueryTestablePermissions)super.setAccessToken(string);
            }

            public QueryTestablePermissions setAlt(String string) {
                return (QueryTestablePermissions)super.setAlt(string);
            }

            public QueryTestablePermissions setBearerToken(String string) {
                return (QueryTestablePermissions)super.setBearerToken(string);
            }

            public QueryTestablePermissions setCallback(String string) {
                return (QueryTestablePermissions)super.setCallback(string);
            }

            public QueryTestablePermissions setFields(String string) {
                return (QueryTestablePermissions)super.setFields(string);
            }

            public QueryTestablePermissions setKey(String string) {
                return (QueryTestablePermissions)super.setKey(string);
            }

            public QueryTestablePermissions setOauthToken(String string) {
                return (QueryTestablePermissions)super.setOauthToken(string);
            }

            public QueryTestablePermissions setPp(Boolean bl) {
                return (QueryTestablePermissions)super.setPp(bl);
            }

            public QueryTestablePermissions setPrettyPrint(Boolean bl) {
                return (QueryTestablePermissions)super.setPrettyPrint(bl);
            }

            public QueryTestablePermissions setQuotaUser(String string) {
                return (QueryTestablePermissions)super.setQuotaUser(string);
            }

            public QueryTestablePermissions setUploadType(String string) {
                return (QueryTestablePermissions)super.setUploadType(string);
            }

            public QueryTestablePermissions setUploadProtocol(String string) {
                return (QueryTestablePermissions)super.setUploadProtocol(string);
            }

            @Override
            public QueryTestablePermissions set(String string, Object object) {
                return (QueryTestablePermissions)super.set(string, object);
            }
        }
    }

    public class Organizations {
        public Roles roles() {
            return new Roles();
        }

        public class Roles {
            public Create create(String string, CreateRoleRequest createRoleRequest) throws IOException {
                Create create = new Create(string, createRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, Role role) throws IOException {
                Patch patch = new Patch(string, role);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Undelete undelete(String string, UndeleteRoleRequest undeleteRoleRequest) throws IOException {
                Undelete undelete = new Undelete(string, undeleteRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)undelete);
                return undelete;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Undelete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String string, UndeleteRoleRequest undeleteRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)undeleteRoleRequest, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String string) {
                    return (Undelete)super.set$Xgafv(string);
                }

                public Undelete setAccessToken(String string) {
                    return (Undelete)super.setAccessToken(string);
                }

                public Undelete setAlt(String string) {
                    return (Undelete)super.setAlt(string);
                }

                public Undelete setBearerToken(String string) {
                    return (Undelete)super.setBearerToken(string);
                }

                public Undelete setCallback(String string) {
                    return (Undelete)super.setCallback(string);
                }

                public Undelete setFields(String string) {
                    return (Undelete)super.setFields(string);
                }

                public Undelete setKey(String string) {
                    return (Undelete)super.setKey(string);
                }

                public Undelete setOauthToken(String string) {
                    return (Undelete)super.setOauthToken(string);
                }

                public Undelete setPp(Boolean bl) {
                    return (Undelete)super.setPp(bl);
                }

                public Undelete setPrettyPrint(Boolean bl) {
                    return (Undelete)super.setPrettyPrint(bl);
                }

                public Undelete setQuotaUser(String string) {
                    return (Undelete)super.setQuotaUser(string);
                }

                public Undelete setUploadType(String string) {
                    return (Undelete)super.setUploadType(string);
                }

                public Undelete setUploadProtocol(String string) {
                    return (Undelete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Undelete set(String string, Object object) {
                    return (Undelete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String string, Role role) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)role, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends IamRequest<ListRolesResponse> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String view;
                @Key
                private Boolean showDeleted;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String string) {
                    this.view = string;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean bl) {
                    this.showDeleted = bl;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Iam.this, "GET", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String etag;

                protected Delete(String string) {
                    super(Iam.this, "DELETE", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getEtag() {
                    return this.etag;
                }

                public Delete setEtag(String string) {
                    this.etag = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String string, CreateRoleRequest createRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)createRoleRequest, Role.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }
    }
}

