/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vpcaccess/v1/vpc_access.proto

package com.google.cloud.vpcaccess.v1;

/**
 *
 *
 * <pre>
 * Definition of a Serverless VPC Access connector.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vpcaccess.v1.Connector}
 */
public final class Connector extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vpcaccess.v1.Connector)
    ConnectorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Connector.newBuilder() to construct.
  private Connector(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Connector() {
    name_ = "";
    network_ = "";
    ipCidrRange_ = "";
    state_ = 0;
    connectedProjects_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    machineType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Connector();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vpcaccess.v1.VpcAccessProto
        .internal_static_google_cloud_vpcaccess_v1_Connector_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vpcaccess.v1.VpcAccessProto
        .internal_static_google_cloud_vpcaccess_v1_Connector_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vpcaccess.v1.Connector.class,
            com.google.cloud.vpcaccess.v1.Connector.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of a connector.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.vpcaccess.v1.Connector.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Connector is deployed and ready to receive traffic.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    READY(1),
    /**
     *
     *
     * <pre>
     * An Insert operation is in progress. Transient condition.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    CREATING(2),
    /**
     *
     *
     * <pre>
     * A Delete operation is in progress. Transient condition.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    DELETING(3),
    /**
     *
     *
     * <pre>
     * Connector is in a bad state, manual deletion recommended.
     * </pre>
     *
     * <code>ERROR = 4;</code>
     */
    ERROR(4),
    /**
     *
     *
     * <pre>
     * The connector is being updated.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    UPDATING(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Connector is deployed and ready to receive traffic.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    public static final int READY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * An Insert operation is in progress. Transient condition.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    public static final int CREATING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * A Delete operation is in progress. Transient condition.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    public static final int DELETING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Connector is in a bad state, manual deletion recommended.
     * </pre>
     *
     * <code>ERROR = 4;</code>
     */
    public static final int ERROR_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The connector is being updated.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    public static final int UPDATING_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return READY;
        case 2:
          return CREATING;
        case 3:
          return DELETING;
        case 4:
          return ERROR;
        case 5:
          return UPDATING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.vpcaccess.v1.Connector.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.vpcaccess.v1.Connector.State)
  }

  public interface SubnetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vpcaccess.v1.Connector.Subnet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Subnet name (relative, not fully qualified).
     * E.g. if the full subnet selfLink is
     * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
     * the correct input for this field would be {subnetName}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Subnet name (relative, not fully qualified).
     * E.g. if the full subnet selfLink is
     * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
     * the correct input for this field would be {subnetName}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Project in which the subnet exists.
     * If not set, this project is assumed to be the project for which
     * the connector create request was issued.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Project in which the subnet exists.
     * If not set, this project is assumed to be the project for which
     * the connector create request was issued.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();
  }
  /**
   *
   *
   * <pre>
   * The subnet in which to house the connector
   * </pre>
   *
   * Protobuf type {@code google.cloud.vpcaccess.v1.Connector.Subnet}
   */
  public static final class Subnet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vpcaccess.v1.Connector.Subnet)
      SubnetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Subnet.newBuilder() to construct.
    private Subnet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Subnet() {
      name_ = "";
      projectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Subnet();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vpcaccess.v1.VpcAccessProto
          .internal_static_google_cloud_vpcaccess_v1_Connector_Subnet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vpcaccess.v1.VpcAccessProto
          .internal_static_google_cloud_vpcaccess_v1_Connector_Subnet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vpcaccess.v1.Connector.Subnet.class,
              com.google.cloud.vpcaccess.v1.Connector.Subnet.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Subnet name (relative, not fully qualified).
     * E.g. if the full subnet selfLink is
     * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
     * the correct input for this field would be {subnetName}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnet name (relative, not fully qualified).
     * E.g. if the full subnet selfLink is
     * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
     * the correct input for this field would be {subnetName}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Project in which the subnet exists.
     * If not set, this project is assumed to be the project for which
     * the connector create request was issued.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Project in which the subnet exists.
     * If not set, this project is assumed to be the project for which
     * the connector create request was issued.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vpcaccess.v1.Connector.Subnet)) {
        return super.equals(obj);
      }
      com.google.cloud.vpcaccess.v1.Connector.Subnet other =
          (com.google.cloud.vpcaccess.v1.Connector.Subnet) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.vpcaccess.v1.Connector.Subnet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the connector
     * </pre>
     *
     * Protobuf type {@code google.cloud.vpcaccess.v1.Connector.Subnet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vpcaccess.v1.Connector.Subnet)
        com.google.cloud.vpcaccess.v1.Connector.SubnetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vpcaccess.v1.VpcAccessProto
            .internal_static_google_cloud_vpcaccess_v1_Connector_Subnet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vpcaccess.v1.VpcAccessProto
            .internal_static_google_cloud_vpcaccess_v1_Connector_Subnet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vpcaccess.v1.Connector.Subnet.class,
                com.google.cloud.vpcaccess.v1.Connector.Subnet.Builder.class);
      }

      // Construct using com.google.cloud.vpcaccess.v1.Connector.Subnet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        projectId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vpcaccess.v1.VpcAccessProto
            .internal_static_google_cloud_vpcaccess_v1_Connector_Subnet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vpcaccess.v1.Connector.Subnet getDefaultInstanceForType() {
        return com.google.cloud.vpcaccess.v1.Connector.Subnet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vpcaccess.v1.Connector.Subnet build() {
        com.google.cloud.vpcaccess.v1.Connector.Subnet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vpcaccess.v1.Connector.Subnet buildPartial() {
        com.google.cloud.vpcaccess.v1.Connector.Subnet result =
            new com.google.cloud.vpcaccess.v1.Connector.Subnet(this);
        result.name_ = name_;
        result.projectId_ = projectId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vpcaccess.v1.Connector.Subnet) {
          return mergeFrom((com.google.cloud.vpcaccess.v1.Connector.Subnet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vpcaccess.v1.Connector.Subnet other) {
        if (other == com.google.cloud.vpcaccess.v1.Connector.Subnet.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Subnet name (relative, not fully qualified).
       * E.g. if the full subnet selfLink is
       * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
       * the correct input for this field would be {subnetName}
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Subnet name (relative, not fully qualified).
       * E.g. if the full subnet selfLink is
       * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
       * the correct input for this field would be {subnetName}
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Subnet name (relative, not fully qualified).
       * E.g. if the full subnet selfLink is
       * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
       * the correct input for this field would be {subnetName}
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Subnet name (relative, not fully qualified).
       * E.g. if the full subnet selfLink is
       * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
       * the correct input for this field would be {subnetName}
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Subnet name (relative, not fully qualified).
       * E.g. if the full subnet selfLink is
       * https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName}
       * the correct input for this field would be {subnetName}
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Project in which the subnet exists.
       * If not set, this project is assumed to be the project for which
       * the connector create request was issued.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Project in which the subnet exists.
       * If not set, this project is assumed to be the project for which
       * the connector create request was issued.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Project in which the subnet exists.
       * If not set, this project is assumed to be the project for which
       * the connector create request was issued.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Project in which the subnet exists.
       * If not set, this project is assumed to be the project for which
       * the connector create request was issued.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Project in which the subnet exists.
       * If not set, this project is assumed to be the project for which
       * the connector create request was issued.
       * </pre>
       *
       * <code>string project_id = 2;</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vpcaccess.v1.Connector.Subnet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vpcaccess.v1.Connector.Subnet)
    private static final com.google.cloud.vpcaccess.v1.Connector.Subnet DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vpcaccess.v1.Connector.Subnet();
    }

    public static com.google.cloud.vpcaccess.v1.Connector.Subnet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Subnet> PARSER =
        new com.google.protobuf.AbstractParser<Subnet>() {
          @java.lang.Override
          public Subnet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Subnet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Subnet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vpcaccess.v1.Connector.Subnet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 2;
  private volatile java.lang.Object network_;
  /**
   *
   *
   * <pre>
   * Name of a VPC network.
   * </pre>
   *
   * <code>string network = 2;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a VPC network.
   * </pre>
   *
   * <code>string network = 2;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_CIDR_RANGE_FIELD_NUMBER = 3;
  private volatile java.lang.Object ipCidrRange_;
  /**
   *
   *
   * <pre>
   * The range of internal addresses that follows RFC 4632 notation.
   * Example: `10.132.0.0/28`.
   * </pre>
   *
   * <code>string ip_cidr_range = 3;</code>
   *
   * @return The ipCidrRange.
   */
  @java.lang.Override
  public java.lang.String getIpCidrRange() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipCidrRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The range of internal addresses that follows RFC 4632 notation.
   * Example: `10.132.0.0/28`.
   * </pre>
   *
   * <code>string ip_cidr_range = 3;</code>
   *
   * @return The bytes for ipCidrRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpCidrRangeBytes() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipCidrRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. State of the VPC access connector.
   * </pre>
   *
   * <code>
   * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the VPC access connector.
   * </pre>
   *
   * <code>
   * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.vpcaccess.v1.Connector.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vpcaccess.v1.Connector.State result =
        com.google.cloud.vpcaccess.v1.Connector.State.valueOf(state_);
    return result == null ? com.google.cloud.vpcaccess.v1.Connector.State.UNRECOGNIZED : result;
  }

  public static final int MIN_THROUGHPUT_FIELD_NUMBER = 5;
  private int minThroughput_;
  /**
   *
   *
   * <pre>
   * Minimum throughput of the connector in Mbps. Default and min is 200.
   * </pre>
   *
   * <code>int32 min_throughput = 5;</code>
   *
   * @return The minThroughput.
   */
  @java.lang.Override
  public int getMinThroughput() {
    return minThroughput_;
  }

  public static final int MAX_THROUGHPUT_FIELD_NUMBER = 6;
  private int maxThroughput_;
  /**
   *
   *
   * <pre>
   * Maximum throughput of the connector in Mbps. Default is 300, max is 1000.
   * </pre>
   *
   * <code>int32 max_throughput = 6;</code>
   *
   * @return The maxThroughput.
   */
  @java.lang.Override
  public int getMaxThroughput() {
    return maxThroughput_;
  }

  public static final int CONNECTED_PROJECTS_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList connectedProjects_;
  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the connectedProjects.
   */
  public com.google.protobuf.ProtocolStringList getConnectedProjectsList() {
    return connectedProjects_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of connectedProjects.
   */
  public int getConnectedProjectsCount() {
    return connectedProjects_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The connectedProjects at the given index.
   */
  public java.lang.String getConnectedProjects(int index) {
    return connectedProjects_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the connectedProjects at the given index.
   */
  public com.google.protobuf.ByteString getConnectedProjectsBytes(int index) {
    return connectedProjects_.getByteString(index);
  }

  public static final int SUBNET_FIELD_NUMBER = 8;
  private com.google.cloud.vpcaccess.v1.Connector.Subnet subnet_;
  /**
   *
   *
   * <pre>
   * The subnet in which to house the VPC Access Connector.
   * </pre>
   *
   * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
   *
   * @return Whether the subnet field is set.
   */
  @java.lang.Override
  public boolean hasSubnet() {
    return subnet_ != null;
  }
  /**
   *
   *
   * <pre>
   * The subnet in which to house the VPC Access Connector.
   * </pre>
   *
   * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
   *
   * @return The subnet.
   */
  @java.lang.Override
  public com.google.cloud.vpcaccess.v1.Connector.Subnet getSubnet() {
    return subnet_ == null
        ? com.google.cloud.vpcaccess.v1.Connector.Subnet.getDefaultInstance()
        : subnet_;
  }
  /**
   *
   *
   * <pre>
   * The subnet in which to house the VPC Access Connector.
   * </pre>
   *
   * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.vpcaccess.v1.Connector.SubnetOrBuilder getSubnetOrBuilder() {
    return getSubnet();
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 10;
  private volatile java.lang.Object machineType_;
  /**
   *
   *
   * <pre>
   * Machine type of VM Instance underlying connector. Default is e2-micro
   * </pre>
   *
   * <code>string machine_type = 10;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Machine type of VM Instance underlying connector. Default is e2-micro
   * </pre>
   *
   * <code>string machine_type = 10;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MIN_INSTANCES_FIELD_NUMBER = 11;
  private int minInstances_;
  /**
   *
   *
   * <pre>
   * Minimum value of instances in autoscaling group underlying the connector.
   * </pre>
   *
   * <code>int32 min_instances = 11;</code>
   *
   * @return The minInstances.
   */
  @java.lang.Override
  public int getMinInstances() {
    return minInstances_;
  }

  public static final int MAX_INSTANCES_FIELD_NUMBER = 12;
  private int maxInstances_;
  /**
   *
   *
   * <pre>
   * Maximum value of instances in autoscaling group underlying the connector.
   * </pre>
   *
   * <code>int32 max_instances = 12;</code>
   *
   * @return The maxInstances.
   */
  @java.lang.Override
  public int getMaxInstances() {
    return maxInstances_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipCidrRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ipCidrRange_);
    }
    if (state_ != com.google.cloud.vpcaccess.v1.Connector.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (minThroughput_ != 0) {
      output.writeInt32(5, minThroughput_);
    }
    if (maxThroughput_ != 0) {
      output.writeInt32(6, maxThroughput_);
    }
    for (int i = 0; i < connectedProjects_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, connectedProjects_.getRaw(i));
    }
    if (subnet_ != null) {
      output.writeMessage(8, getSubnet());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, machineType_);
    }
    if (minInstances_ != 0) {
      output.writeInt32(11, minInstances_);
    }
    if (maxInstances_ != 0) {
      output.writeInt32(12, maxInstances_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipCidrRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ipCidrRange_);
    }
    if (state_ != com.google.cloud.vpcaccess.v1.Connector.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (minThroughput_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, minThroughput_);
    }
    if (maxThroughput_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, maxThroughput_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < connectedProjects_.size(); i++) {
        dataSize += computeStringSizeNoTag(connectedProjects_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getConnectedProjectsList().size();
    }
    if (subnet_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSubnet());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, machineType_);
    }
    if (minInstances_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, minInstances_);
    }
    if (maxInstances_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, maxInstances_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vpcaccess.v1.Connector)) {
      return super.equals(obj);
    }
    com.google.cloud.vpcaccess.v1.Connector other = (com.google.cloud.vpcaccess.v1.Connector) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getIpCidrRange().equals(other.getIpCidrRange())) return false;
    if (state_ != other.state_) return false;
    if (getMinThroughput() != other.getMinThroughput()) return false;
    if (getMaxThroughput() != other.getMaxThroughput()) return false;
    if (!getConnectedProjectsList().equals(other.getConnectedProjectsList())) return false;
    if (hasSubnet() != other.hasSubnet()) return false;
    if (hasSubnet()) {
      if (!getSubnet().equals(other.getSubnet())) return false;
    }
    if (!getMachineType().equals(other.getMachineType())) return false;
    if (getMinInstances() != other.getMinInstances()) return false;
    if (getMaxInstances() != other.getMaxInstances()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + IP_CIDR_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getIpCidrRange().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + MIN_THROUGHPUT_FIELD_NUMBER;
    hash = (53 * hash) + getMinThroughput();
    hash = (37 * hash) + MAX_THROUGHPUT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxThroughput();
    if (getConnectedProjectsCount() > 0) {
      hash = (37 * hash) + CONNECTED_PROJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getConnectedProjectsList().hashCode();
    }
    if (hasSubnet()) {
      hash = (37 * hash) + SUBNET_FIELD_NUMBER;
      hash = (53 * hash) + getSubnet().hashCode();
    }
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    hash = (37 * hash) + MIN_INSTANCES_FIELD_NUMBER;
    hash = (53 * hash) + getMinInstances();
    hash = (37 * hash) + MAX_INSTANCES_FIELD_NUMBER;
    hash = (53 * hash) + getMaxInstances();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vpcaccess.v1.Connector parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vpcaccess.v1.Connector prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Definition of a Serverless VPC Access connector.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vpcaccess.v1.Connector}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vpcaccess.v1.Connector)
      com.google.cloud.vpcaccess.v1.ConnectorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vpcaccess.v1.VpcAccessProto
          .internal_static_google_cloud_vpcaccess_v1_Connector_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vpcaccess.v1.VpcAccessProto
          .internal_static_google_cloud_vpcaccess_v1_Connector_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vpcaccess.v1.Connector.class,
              com.google.cloud.vpcaccess.v1.Connector.Builder.class);
    }

    // Construct using com.google.cloud.vpcaccess.v1.Connector.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      network_ = "";

      ipCidrRange_ = "";

      state_ = 0;

      minThroughput_ = 0;

      maxThroughput_ = 0;

      connectedProjects_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (subnetBuilder_ == null) {
        subnet_ = null;
      } else {
        subnet_ = null;
        subnetBuilder_ = null;
      }
      machineType_ = "";

      minInstances_ = 0;

      maxInstances_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vpcaccess.v1.VpcAccessProto
          .internal_static_google_cloud_vpcaccess_v1_Connector_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vpcaccess.v1.Connector getDefaultInstanceForType() {
      return com.google.cloud.vpcaccess.v1.Connector.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vpcaccess.v1.Connector build() {
      com.google.cloud.vpcaccess.v1.Connector result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vpcaccess.v1.Connector buildPartial() {
      com.google.cloud.vpcaccess.v1.Connector result =
          new com.google.cloud.vpcaccess.v1.Connector(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.network_ = network_;
      result.ipCidrRange_ = ipCidrRange_;
      result.state_ = state_;
      result.minThroughput_ = minThroughput_;
      result.maxThroughput_ = maxThroughput_;
      if (((bitField0_ & 0x00000001) != 0)) {
        connectedProjects_ = connectedProjects_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.connectedProjects_ = connectedProjects_;
      if (subnetBuilder_ == null) {
        result.subnet_ = subnet_;
      } else {
        result.subnet_ = subnetBuilder_.build();
      }
      result.machineType_ = machineType_;
      result.minInstances_ = minInstances_;
      result.maxInstances_ = maxInstances_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vpcaccess.v1.Connector) {
        return mergeFrom((com.google.cloud.vpcaccess.v1.Connector) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vpcaccess.v1.Connector other) {
      if (other == com.google.cloud.vpcaccess.v1.Connector.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        onChanged();
      }
      if (!other.getIpCidrRange().isEmpty()) {
        ipCidrRange_ = other.ipCidrRange_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getMinThroughput() != 0) {
        setMinThroughput(other.getMinThroughput());
      }
      if (other.getMaxThroughput() != 0) {
        setMaxThroughput(other.getMaxThroughput());
      }
      if (!other.connectedProjects_.isEmpty()) {
        if (connectedProjects_.isEmpty()) {
          connectedProjects_ = other.connectedProjects_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureConnectedProjectsIsMutable();
          connectedProjects_.addAll(other.connectedProjects_);
        }
        onChanged();
      }
      if (other.hasSubnet()) {
        mergeSubnet(other.getSubnet());
      }
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        onChanged();
      }
      if (other.getMinInstances() != 0) {
        setMinInstances(other.getMinInstances());
      }
      if (other.getMaxInstances() != 0) {
        setMaxInstances(other.getMaxInstances());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                network_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                ipCidrRange_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();

                break;
              } // case 32
            case 40:
              {
                minThroughput_ = input.readInt32();

                break;
              } // case 40
            case 48:
              {
                maxThroughput_ = input.readInt32();

                break;
              } // case 48
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureConnectedProjectsIsMutable();
                connectedProjects_.add(s);
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSubnetFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 82:
              {
                machineType_ = input.readStringRequireUtf8();

                break;
              } // case 82
            case 88:
              {
                minInstances_ = input.readInt32();

                break;
              } // case 88
            case 96:
              {
                maxInstances_ = input.readInt32();

                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Name of a VPC network.
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a VPC network.
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a VPC network.
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a VPC network.
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {

      network_ = getDefaultInstance().getNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a VPC network.
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      network_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object ipCidrRange_ = "";
    /**
     *
     *
     * <pre>
     * The range of internal addresses that follows RFC 4632 notation.
     * Example: `10.132.0.0/28`.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @return The ipCidrRange.
     */
    public java.lang.String getIpCidrRange() {
      java.lang.Object ref = ipCidrRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipCidrRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that follows RFC 4632 notation.
     * Example: `10.132.0.0/28`.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @return The bytes for ipCidrRange.
     */
    public com.google.protobuf.ByteString getIpCidrRangeBytes() {
      java.lang.Object ref = ipCidrRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipCidrRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that follows RFC 4632 notation.
     * Example: `10.132.0.0/28`.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @param value The ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      ipCidrRange_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that follows RFC 4632 notation.
     * Example: `10.132.0.0/28`.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpCidrRange() {

      ipCidrRange_ = getDefaultInstance().getIpCidrRange();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that follows RFC 4632 notation.
     * Example: `10.132.0.0/28`.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @param value The bytes for ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      ipCidrRange_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the VPC access connector.
     * </pre>
     *
     * <code>
     * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the VPC access connector.
     * </pre>
     *
     * <code>
     * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the VPC access connector.
     * </pre>
     *
     * <code>
     * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.vpcaccess.v1.Connector.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vpcaccess.v1.Connector.State result =
          com.google.cloud.vpcaccess.v1.Connector.State.valueOf(state_);
      return result == null ? com.google.cloud.vpcaccess.v1.Connector.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the VPC access connector.
     * </pre>
     *
     * <code>
     * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.vpcaccess.v1.Connector.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the VPC access connector.
     * </pre>
     *
     * <code>
     * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private int minThroughput_;
    /**
     *
     *
     * <pre>
     * Minimum throughput of the connector in Mbps. Default and min is 200.
     * </pre>
     *
     * <code>int32 min_throughput = 5;</code>
     *
     * @return The minThroughput.
     */
    @java.lang.Override
    public int getMinThroughput() {
      return minThroughput_;
    }
    /**
     *
     *
     * <pre>
     * Minimum throughput of the connector in Mbps. Default and min is 200.
     * </pre>
     *
     * <code>int32 min_throughput = 5;</code>
     *
     * @param value The minThroughput to set.
     * @return This builder for chaining.
     */
    public Builder setMinThroughput(int value) {

      minThroughput_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum throughput of the connector in Mbps. Default and min is 200.
     * </pre>
     *
     * <code>int32 min_throughput = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinThroughput() {

      minThroughput_ = 0;
      onChanged();
      return this;
    }

    private int maxThroughput_;
    /**
     *
     *
     * <pre>
     * Maximum throughput of the connector in Mbps. Default is 300, max is 1000.
     * </pre>
     *
     * <code>int32 max_throughput = 6;</code>
     *
     * @return The maxThroughput.
     */
    @java.lang.Override
    public int getMaxThroughput() {
      return maxThroughput_;
    }
    /**
     *
     *
     * <pre>
     * Maximum throughput of the connector in Mbps. Default is 300, max is 1000.
     * </pre>
     *
     * <code>int32 max_throughput = 6;</code>
     *
     * @param value The maxThroughput to set.
     * @return This builder for chaining.
     */
    public Builder setMaxThroughput(int value) {

      maxThroughput_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum throughput of the connector in Mbps. Default is 300, max is 1000.
     * </pre>
     *
     * <code>int32 max_throughput = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxThroughput() {

      maxThroughput_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList connectedProjects_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureConnectedProjectsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        connectedProjects_ = new com.google.protobuf.LazyStringArrayList(connectedProjects_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the connectedProjects.
     */
    public com.google.protobuf.ProtocolStringList getConnectedProjectsList() {
      return connectedProjects_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of connectedProjects.
     */
    public int getConnectedProjectsCount() {
      return connectedProjects_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The connectedProjects at the given index.
     */
    public java.lang.String getConnectedProjects(int index) {
      return connectedProjects_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the connectedProjects at the given index.
     */
    public com.google.protobuf.ByteString getConnectedProjectsBytes(int index) {
      return connectedProjects_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The connectedProjects to set.
     * @return This builder for chaining.
     */
    public Builder setConnectedProjects(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureConnectedProjectsIsMutable();
      connectedProjects_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The connectedProjects to add.
     * @return This builder for chaining.
     */
    public Builder addConnectedProjects(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureConnectedProjectsIsMutable();
      connectedProjects_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The connectedProjects to add.
     * @return This builder for chaining.
     */
    public Builder addAllConnectedProjects(java.lang.Iterable<java.lang.String> values) {
      ensureConnectedProjectsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, connectedProjects_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectedProjects() {
      connectedProjects_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of projects using the connector.
     * </pre>
     *
     * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the connectedProjects to add.
     * @return This builder for chaining.
     */
    public Builder addConnectedProjectsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureConnectedProjectsIsMutable();
      connectedProjects_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloud.vpcaccess.v1.Connector.Subnet subnet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vpcaccess.v1.Connector.Subnet,
            com.google.cloud.vpcaccess.v1.Connector.Subnet.Builder,
            com.google.cloud.vpcaccess.v1.Connector.SubnetOrBuilder>
        subnetBuilder_;
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     *
     * @return Whether the subnet field is set.
     */
    public boolean hasSubnet() {
      return subnetBuilder_ != null || subnet_ != null;
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     *
     * @return The subnet.
     */
    public com.google.cloud.vpcaccess.v1.Connector.Subnet getSubnet() {
      if (subnetBuilder_ == null) {
        return subnet_ == null
            ? com.google.cloud.vpcaccess.v1.Connector.Subnet.getDefaultInstance()
            : subnet_;
      } else {
        return subnetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     */
    public Builder setSubnet(com.google.cloud.vpcaccess.v1.Connector.Subnet value) {
      if (subnetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        subnet_ = value;
        onChanged();
      } else {
        subnetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     */
    public Builder setSubnet(
        com.google.cloud.vpcaccess.v1.Connector.Subnet.Builder builderForValue) {
      if (subnetBuilder_ == null) {
        subnet_ = builderForValue.build();
        onChanged();
      } else {
        subnetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     */
    public Builder mergeSubnet(com.google.cloud.vpcaccess.v1.Connector.Subnet value) {
      if (subnetBuilder_ == null) {
        if (subnet_ != null) {
          subnet_ =
              com.google.cloud.vpcaccess.v1.Connector.Subnet.newBuilder(subnet_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          subnet_ = value;
        }
        onChanged();
      } else {
        subnetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     */
    public Builder clearSubnet() {
      if (subnetBuilder_ == null) {
        subnet_ = null;
        onChanged();
      } else {
        subnet_ = null;
        subnetBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     */
    public com.google.cloud.vpcaccess.v1.Connector.Subnet.Builder getSubnetBuilder() {

      onChanged();
      return getSubnetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     */
    public com.google.cloud.vpcaccess.v1.Connector.SubnetOrBuilder getSubnetOrBuilder() {
      if (subnetBuilder_ != null) {
        return subnetBuilder_.getMessageOrBuilder();
      } else {
        return subnet_ == null
            ? com.google.cloud.vpcaccess.v1.Connector.Subnet.getDefaultInstance()
            : subnet_;
      }
    }
    /**
     *
     *
     * <pre>
     * The subnet in which to house the VPC Access Connector.
     * </pre>
     *
     * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vpcaccess.v1.Connector.Subnet,
            com.google.cloud.vpcaccess.v1.Connector.Subnet.Builder,
            com.google.cloud.vpcaccess.v1.Connector.SubnetOrBuilder>
        getSubnetFieldBuilder() {
      if (subnetBuilder_ == null) {
        subnetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vpcaccess.v1.Connector.Subnet,
                com.google.cloud.vpcaccess.v1.Connector.Subnet.Builder,
                com.google.cloud.vpcaccess.v1.Connector.SubnetOrBuilder>(
                getSubnet(), getParentForChildren(), isClean());
        subnet_ = null;
      }
      return subnetBuilder_;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Machine type of VM Instance underlying connector. Default is e2-micro
     * </pre>
     *
     * <code>string machine_type = 10;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine type of VM Instance underlying connector. Default is e2-micro
     * </pre>
     *
     * <code>string machine_type = 10;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine type of VM Instance underlying connector. Default is e2-micro
     * </pre>
     *
     * <code>string machine_type = 10;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      machineType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine type of VM Instance underlying connector. Default is e2-micro
     * </pre>
     *
     * <code>string machine_type = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {

      machineType_ = getDefaultInstance().getMachineType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine type of VM Instance underlying connector. Default is e2-micro
     * </pre>
     *
     * <code>string machine_type = 10;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      machineType_ = value;
      onChanged();
      return this;
    }

    private int minInstances_;
    /**
     *
     *
     * <pre>
     * Minimum value of instances in autoscaling group underlying the connector.
     * </pre>
     *
     * <code>int32 min_instances = 11;</code>
     *
     * @return The minInstances.
     */
    @java.lang.Override
    public int getMinInstances() {
      return minInstances_;
    }
    /**
     *
     *
     * <pre>
     * Minimum value of instances in autoscaling group underlying the connector.
     * </pre>
     *
     * <code>int32 min_instances = 11;</code>
     *
     * @param value The minInstances to set.
     * @return This builder for chaining.
     */
    public Builder setMinInstances(int value) {

      minInstances_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum value of instances in autoscaling group underlying the connector.
     * </pre>
     *
     * <code>int32 min_instances = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinInstances() {

      minInstances_ = 0;
      onChanged();
      return this;
    }

    private int maxInstances_;
    /**
     *
     *
     * <pre>
     * Maximum value of instances in autoscaling group underlying the connector.
     * </pre>
     *
     * <code>int32 max_instances = 12;</code>
     *
     * @return The maxInstances.
     */
    @java.lang.Override
    public int getMaxInstances() {
      return maxInstances_;
    }
    /**
     *
     *
     * <pre>
     * Maximum value of instances in autoscaling group underlying the connector.
     * </pre>
     *
     * <code>int32 max_instances = 12;</code>
     *
     * @param value The maxInstances to set.
     * @return This builder for chaining.
     */
    public Builder setMaxInstances(int value) {

      maxInstances_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum value of instances in autoscaling group underlying the connector.
     * </pre>
     *
     * <code>int32 max_instances = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxInstances() {

      maxInstances_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vpcaccess.v1.Connector)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vpcaccess.v1.Connector)
  private static final com.google.cloud.vpcaccess.v1.Connector DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vpcaccess.v1.Connector();
  }

  public static com.google.cloud.vpcaccess.v1.Connector getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Connector> PARSER =
      new com.google.protobuf.AbstractParser<Connector>() {
        @java.lang.Override
        public Connector parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Connector> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Connector> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vpcaccess.v1.Connector getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
