/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p4beta1/image_annotator.proto

package com.google.cloud.vision.v1p4beta1;

/**
 *
 *
 * <pre>
 * Image context and/or feature-specific parameters.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p4beta1.ImageContext}
 */
public final class ImageContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p4beta1.ImageContext)
    ImageContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImageContext.newBuilder() to construct.
  private ImageContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImageContext() {
    languageHints_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImageContext();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImageContext(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.vision.v1p4beta1.LatLongRect.Builder subBuilder = null;
              if (latLongRect_ != null) {
                subBuilder = latLongRect_.toBuilder();
              }
              latLongRect_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p4beta1.LatLongRect.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(latLongRect_);
                latLongRect_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                languageHints_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              languageHints_.add(s);
              break;
            }
          case 34:
            {
              com.google.cloud.vision.v1p4beta1.CropHintsParams.Builder subBuilder = null;
              if (cropHintsParams_ != null) {
                subBuilder = cropHintsParams_.toBuilder();
              }
              cropHintsParams_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p4beta1.CropHintsParams.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(cropHintsParams_);
                cropHintsParams_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.vision.v1p4beta1.ProductSearchParams.Builder subBuilder = null;
              if (productSearchParams_ != null) {
                subBuilder = productSearchParams_.toBuilder();
              }
              productSearchParams_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p4beta1.ProductSearchParams.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(productSearchParams_);
                productSearchParams_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.cloud.vision.v1p4beta1.WebDetectionParams.Builder subBuilder = null;
              if (webDetectionParams_ != null) {
                subBuilder = webDetectionParams_.toBuilder();
              }
              webDetectionParams_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p4beta1.WebDetectionParams.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(webDetectionParams_);
                webDetectionParams_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.Builder subBuilder = null;
              if (faceRecognitionParams_ != null) {
                subBuilder = faceRecognitionParams_.toBuilder();
              }
              faceRecognitionParams_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(faceRecognitionParams_);
                faceRecognitionParams_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              com.google.cloud.vision.v1p4beta1.TextDetectionParams.Builder subBuilder = null;
              if (textDetectionParams_ != null) {
                subBuilder = textDetectionParams_.toBuilder();
              }
              textDetectionParams_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p4beta1.TextDetectionParams.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(textDetectionParams_);
                textDetectionParams_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        languageHints_ = languageHints_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p4beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p4beta1_ImageContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p4beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p4beta1_ImageContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p4beta1.ImageContext.class,
            com.google.cloud.vision.v1p4beta1.ImageContext.Builder.class);
  }

  public static final int LAT_LONG_RECT_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1p4beta1.LatLongRect latLongRect_;
  /**
   *
   *
   * <pre>
   * Not used.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
   *
   * @return Whether the latLongRect field is set.
   */
  @java.lang.Override
  public boolean hasLatLongRect() {
    return latLongRect_ != null;
  }
  /**
   *
   *
   * <pre>
   * Not used.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
   *
   * @return The latLongRect.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.LatLongRect getLatLongRect() {
    return latLongRect_ == null
        ? com.google.cloud.vision.v1p4beta1.LatLongRect.getDefaultInstance()
        : latLongRect_;
  }
  /**
   *
   *
   * <pre>
   * Not used.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.LatLongRectOrBuilder getLatLongRectOrBuilder() {
    return getLatLongRect();
  }

  public static final int LANGUAGE_HINTS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList languageHints_;
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @return A list containing the languageHints.
   */
  public com.google.protobuf.ProtocolStringList getLanguageHintsList() {
    return languageHints_;
  }
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @return The count of languageHints.
   */
  public int getLanguageHintsCount() {
    return languageHints_.size();
  }
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The languageHints at the given index.
   */
  public java.lang.String getLanguageHints(int index) {
    return languageHints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the languageHints at the given index.
   */
  public com.google.protobuf.ByteString getLanguageHintsBytes(int index) {
    return languageHints_.getByteString(index);
  }

  public static final int CROP_HINTS_PARAMS_FIELD_NUMBER = 4;
  private com.google.cloud.vision.v1p4beta1.CropHintsParams cropHintsParams_;
  /**
   *
   *
   * <pre>
   * Parameters for crop hints annotation request.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
   *
   * @return Whether the cropHintsParams field is set.
   */
  @java.lang.Override
  public boolean hasCropHintsParams() {
    return cropHintsParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for crop hints annotation request.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
   *
   * @return The cropHintsParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.CropHintsParams getCropHintsParams() {
    return cropHintsParams_ == null
        ? com.google.cloud.vision.v1p4beta1.CropHintsParams.getDefaultInstance()
        : cropHintsParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for crop hints annotation request.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.CropHintsParamsOrBuilder getCropHintsParamsOrBuilder() {
    return getCropHintsParams();
  }

  public static final int FACE_RECOGNITION_PARAMS_FIELD_NUMBER = 10;
  private com.google.cloud.vision.v1p4beta1.FaceRecognitionParams faceRecognitionParams_;
  /**
   *
   *
   * <pre>
   * Parameters for face recognition.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;</code>
   *
   * @return Whether the faceRecognitionParams field is set.
   */
  @java.lang.Override
  public boolean hasFaceRecognitionParams() {
    return faceRecognitionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for face recognition.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;</code>
   *
   * @return The faceRecognitionParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.FaceRecognitionParams getFaceRecognitionParams() {
    return faceRecognitionParams_ == null
        ? com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.getDefaultInstance()
        : faceRecognitionParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for face recognition.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.FaceRecognitionParamsOrBuilder
      getFaceRecognitionParamsOrBuilder() {
    return getFaceRecognitionParams();
  }

  public static final int PRODUCT_SEARCH_PARAMS_FIELD_NUMBER = 5;
  private com.google.cloud.vision.v1p4beta1.ProductSearchParams productSearchParams_;
  /**
   *
   *
   * <pre>
   * Parameters for product search.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
   *
   * @return Whether the productSearchParams field is set.
   */
  @java.lang.Override
  public boolean hasProductSearchParams() {
    return productSearchParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for product search.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
   *
   * @return The productSearchParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.ProductSearchParams getProductSearchParams() {
    return productSearchParams_ == null
        ? com.google.cloud.vision.v1p4beta1.ProductSearchParams.getDefaultInstance()
        : productSearchParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for product search.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.ProductSearchParamsOrBuilder
      getProductSearchParamsOrBuilder() {
    return getProductSearchParams();
  }

  public static final int WEB_DETECTION_PARAMS_FIELD_NUMBER = 6;
  private com.google.cloud.vision.v1p4beta1.WebDetectionParams webDetectionParams_;
  /**
   *
   *
   * <pre>
   * Parameters for web detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
   *
   * @return Whether the webDetectionParams field is set.
   */
  @java.lang.Override
  public boolean hasWebDetectionParams() {
    return webDetectionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for web detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
   *
   * @return The webDetectionParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.WebDetectionParams getWebDetectionParams() {
    return webDetectionParams_ == null
        ? com.google.cloud.vision.v1p4beta1.WebDetectionParams.getDefaultInstance()
        : webDetectionParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for web detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.WebDetectionParamsOrBuilder
      getWebDetectionParamsOrBuilder() {
    return getWebDetectionParams();
  }

  public static final int TEXT_DETECTION_PARAMS_FIELD_NUMBER = 12;
  private com.google.cloud.vision.v1p4beta1.TextDetectionParams textDetectionParams_;
  /**
   *
   *
   * <pre>
   * Parameters for text detection and document text detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
   *
   * @return Whether the textDetectionParams field is set.
   */
  @java.lang.Override
  public boolean hasTextDetectionParams() {
    return textDetectionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for text detection and document text detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
   *
   * @return The textDetectionParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.TextDetectionParams getTextDetectionParams() {
    return textDetectionParams_ == null
        ? com.google.cloud.vision.v1p4beta1.TextDetectionParams.getDefaultInstance()
        : textDetectionParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for text detection and document text detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.TextDetectionParamsOrBuilder
      getTextDetectionParamsOrBuilder() {
    return getTextDetectionParams();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (latLongRect_ != null) {
      output.writeMessage(1, getLatLongRect());
    }
    for (int i = 0; i < languageHints_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageHints_.getRaw(i));
    }
    if (cropHintsParams_ != null) {
      output.writeMessage(4, getCropHintsParams());
    }
    if (productSearchParams_ != null) {
      output.writeMessage(5, getProductSearchParams());
    }
    if (webDetectionParams_ != null) {
      output.writeMessage(6, getWebDetectionParams());
    }
    if (faceRecognitionParams_ != null) {
      output.writeMessage(10, getFaceRecognitionParams());
    }
    if (textDetectionParams_ != null) {
      output.writeMessage(12, getTextDetectionParams());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (latLongRect_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLatLongRect());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < languageHints_.size(); i++) {
        dataSize += computeStringSizeNoTag(languageHints_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLanguageHintsList().size();
    }
    if (cropHintsParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCropHintsParams());
    }
    if (productSearchParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProductSearchParams());
    }
    if (webDetectionParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getWebDetectionParams());
    }
    if (faceRecognitionParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, getFaceRecognitionParams());
    }
    if (textDetectionParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getTextDetectionParams());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p4beta1.ImageContext)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p4beta1.ImageContext other =
        (com.google.cloud.vision.v1p4beta1.ImageContext) obj;

    if (hasLatLongRect() != other.hasLatLongRect()) return false;
    if (hasLatLongRect()) {
      if (!getLatLongRect().equals(other.getLatLongRect())) return false;
    }
    if (!getLanguageHintsList().equals(other.getLanguageHintsList())) return false;
    if (hasCropHintsParams() != other.hasCropHintsParams()) return false;
    if (hasCropHintsParams()) {
      if (!getCropHintsParams().equals(other.getCropHintsParams())) return false;
    }
    if (hasFaceRecognitionParams() != other.hasFaceRecognitionParams()) return false;
    if (hasFaceRecognitionParams()) {
      if (!getFaceRecognitionParams().equals(other.getFaceRecognitionParams())) return false;
    }
    if (hasProductSearchParams() != other.hasProductSearchParams()) return false;
    if (hasProductSearchParams()) {
      if (!getProductSearchParams().equals(other.getProductSearchParams())) return false;
    }
    if (hasWebDetectionParams() != other.hasWebDetectionParams()) return false;
    if (hasWebDetectionParams()) {
      if (!getWebDetectionParams().equals(other.getWebDetectionParams())) return false;
    }
    if (hasTextDetectionParams() != other.hasTextDetectionParams()) return false;
    if (hasTextDetectionParams()) {
      if (!getTextDetectionParams().equals(other.getTextDetectionParams())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLatLongRect()) {
      hash = (37 * hash) + LAT_LONG_RECT_FIELD_NUMBER;
      hash = (53 * hash) + getLatLongRect().hashCode();
    }
    if (getLanguageHintsCount() > 0) {
      hash = (37 * hash) + LANGUAGE_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageHintsList().hashCode();
    }
    if (hasCropHintsParams()) {
      hash = (37 * hash) + CROP_HINTS_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCropHintsParams().hashCode();
    }
    if (hasFaceRecognitionParams()) {
      hash = (37 * hash) + FACE_RECOGNITION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getFaceRecognitionParams().hashCode();
    }
    if (hasProductSearchParams()) {
      hash = (37 * hash) + PRODUCT_SEARCH_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getProductSearchParams().hashCode();
    }
    if (hasWebDetectionParams()) {
      hash = (37 * hash) + WEB_DETECTION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getWebDetectionParams().hashCode();
    }
    if (hasTextDetectionParams()) {
      hash = (37 * hash) + TEXT_DETECTION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getTextDetectionParams().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p4beta1.ImageContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Image context and/or feature-specific parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p4beta1.ImageContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p4beta1.ImageContext)
      com.google.cloud.vision.v1p4beta1.ImageContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p4beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p4beta1_ImageContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p4beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p4beta1_ImageContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p4beta1.ImageContext.class,
              com.google.cloud.vision.v1p4beta1.ImageContext.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p4beta1.ImageContext.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (latLongRectBuilder_ == null) {
        latLongRect_ = null;
      } else {
        latLongRect_ = null;
        latLongRectBuilder_ = null;
      }
      languageHints_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (cropHintsParamsBuilder_ == null) {
        cropHintsParams_ = null;
      } else {
        cropHintsParams_ = null;
        cropHintsParamsBuilder_ = null;
      }
      if (faceRecognitionParamsBuilder_ == null) {
        faceRecognitionParams_ = null;
      } else {
        faceRecognitionParams_ = null;
        faceRecognitionParamsBuilder_ = null;
      }
      if (productSearchParamsBuilder_ == null) {
        productSearchParams_ = null;
      } else {
        productSearchParams_ = null;
        productSearchParamsBuilder_ = null;
      }
      if (webDetectionParamsBuilder_ == null) {
        webDetectionParams_ = null;
      } else {
        webDetectionParams_ = null;
        webDetectionParamsBuilder_ = null;
      }
      if (textDetectionParamsBuilder_ == null) {
        textDetectionParams_ = null;
      } else {
        textDetectionParams_ = null;
        textDetectionParamsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p4beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p4beta1_ImageContext_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.ImageContext getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p4beta1.ImageContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.ImageContext build() {
      com.google.cloud.vision.v1p4beta1.ImageContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.ImageContext buildPartial() {
      com.google.cloud.vision.v1p4beta1.ImageContext result =
          new com.google.cloud.vision.v1p4beta1.ImageContext(this);
      int from_bitField0_ = bitField0_;
      if (latLongRectBuilder_ == null) {
        result.latLongRect_ = latLongRect_;
      } else {
        result.latLongRect_ = latLongRectBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        languageHints_ = languageHints_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.languageHints_ = languageHints_;
      if (cropHintsParamsBuilder_ == null) {
        result.cropHintsParams_ = cropHintsParams_;
      } else {
        result.cropHintsParams_ = cropHintsParamsBuilder_.build();
      }
      if (faceRecognitionParamsBuilder_ == null) {
        result.faceRecognitionParams_ = faceRecognitionParams_;
      } else {
        result.faceRecognitionParams_ = faceRecognitionParamsBuilder_.build();
      }
      if (productSearchParamsBuilder_ == null) {
        result.productSearchParams_ = productSearchParams_;
      } else {
        result.productSearchParams_ = productSearchParamsBuilder_.build();
      }
      if (webDetectionParamsBuilder_ == null) {
        result.webDetectionParams_ = webDetectionParams_;
      } else {
        result.webDetectionParams_ = webDetectionParamsBuilder_.build();
      }
      if (textDetectionParamsBuilder_ == null) {
        result.textDetectionParams_ = textDetectionParams_;
      } else {
        result.textDetectionParams_ = textDetectionParamsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p4beta1.ImageContext) {
        return mergeFrom((com.google.cloud.vision.v1p4beta1.ImageContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p4beta1.ImageContext other) {
      if (other == com.google.cloud.vision.v1p4beta1.ImageContext.getDefaultInstance()) return this;
      if (other.hasLatLongRect()) {
        mergeLatLongRect(other.getLatLongRect());
      }
      if (!other.languageHints_.isEmpty()) {
        if (languageHints_.isEmpty()) {
          languageHints_ = other.languageHints_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureLanguageHintsIsMutable();
          languageHints_.addAll(other.languageHints_);
        }
        onChanged();
      }
      if (other.hasCropHintsParams()) {
        mergeCropHintsParams(other.getCropHintsParams());
      }
      if (other.hasFaceRecognitionParams()) {
        mergeFaceRecognitionParams(other.getFaceRecognitionParams());
      }
      if (other.hasProductSearchParams()) {
        mergeProductSearchParams(other.getProductSearchParams());
      }
      if (other.hasWebDetectionParams()) {
        mergeWebDetectionParams(other.getWebDetectionParams());
      }
      if (other.hasTextDetectionParams()) {
        mergeTextDetectionParams(other.getTextDetectionParams());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1p4beta1.ImageContext parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.vision.v1p4beta1.ImageContext) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p4beta1.LatLongRect latLongRect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.LatLongRect,
            com.google.cloud.vision.v1p4beta1.LatLongRect.Builder,
            com.google.cloud.vision.v1p4beta1.LatLongRectOrBuilder>
        latLongRectBuilder_;
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     *
     * @return Whether the latLongRect field is set.
     */
    public boolean hasLatLongRect() {
      return latLongRectBuilder_ != null || latLongRect_ != null;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     *
     * @return The latLongRect.
     */
    public com.google.cloud.vision.v1p4beta1.LatLongRect getLatLongRect() {
      if (latLongRectBuilder_ == null) {
        return latLongRect_ == null
            ? com.google.cloud.vision.v1p4beta1.LatLongRect.getDefaultInstance()
            : latLongRect_;
      } else {
        return latLongRectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder setLatLongRect(com.google.cloud.vision.v1p4beta1.LatLongRect value) {
      if (latLongRectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latLongRect_ = value;
        onChanged();
      } else {
        latLongRectBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder setLatLongRect(
        com.google.cloud.vision.v1p4beta1.LatLongRect.Builder builderForValue) {
      if (latLongRectBuilder_ == null) {
        latLongRect_ = builderForValue.build();
        onChanged();
      } else {
        latLongRectBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder mergeLatLongRect(com.google.cloud.vision.v1p4beta1.LatLongRect value) {
      if (latLongRectBuilder_ == null) {
        if (latLongRect_ != null) {
          latLongRect_ =
              com.google.cloud.vision.v1p4beta1.LatLongRect.newBuilder(latLongRect_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          latLongRect_ = value;
        }
        onChanged();
      } else {
        latLongRectBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder clearLatLongRect() {
      if (latLongRectBuilder_ == null) {
        latLongRect_ = null;
        onChanged();
      } else {
        latLongRect_ = null;
        latLongRectBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     */
    public com.google.cloud.vision.v1p4beta1.LatLongRect.Builder getLatLongRectBuilder() {

      onChanged();
      return getLatLongRectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     */
    public com.google.cloud.vision.v1p4beta1.LatLongRectOrBuilder getLatLongRectOrBuilder() {
      if (latLongRectBuilder_ != null) {
        return latLongRectBuilder_.getMessageOrBuilder();
      } else {
        return latLongRect_ == null
            ? com.google.cloud.vision.v1p4beta1.LatLongRect.getDefaultInstance()
            : latLongRect_;
      }
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.LatLongRect lat_long_rect = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.LatLongRect,
            com.google.cloud.vision.v1p4beta1.LatLongRect.Builder,
            com.google.cloud.vision.v1p4beta1.LatLongRectOrBuilder>
        getLatLongRectFieldBuilder() {
      if (latLongRectBuilder_ == null) {
        latLongRectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.LatLongRect,
                com.google.cloud.vision.v1p4beta1.LatLongRect.Builder,
                com.google.cloud.vision.v1p4beta1.LatLongRectOrBuilder>(
                getLatLongRect(), getParentForChildren(), isClean());
        latLongRect_ = null;
      }
      return latLongRectBuilder_;
    }

    private com.google.protobuf.LazyStringList languageHints_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureLanguageHintsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        languageHints_ = new com.google.protobuf.LazyStringArrayList(languageHints_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @return A list containing the languageHints.
     */
    public com.google.protobuf.ProtocolStringList getLanguageHintsList() {
      return languageHints_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @return The count of languageHints.
     */
    public int getLanguageHintsCount() {
      return languageHints_.size();
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The languageHints at the given index.
     */
    public java.lang.String getLanguageHints(int index) {
      return languageHints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageHints at the given index.
     */
    public com.google.protobuf.ByteString getLanguageHintsBytes(int index) {
      return languageHints_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The languageHints to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageHints(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageHintsIsMutable();
      languageHints_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param value The languageHints to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageHints(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageHintsIsMutable();
      languageHints_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param values The languageHints to add.
     * @return This builder for chaining.
     */
    public Builder addAllLanguageHints(java.lang.Iterable<java.lang.String> values) {
      ensureLanguageHintsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languageHints_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageHints() {
      languageHints_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param value The bytes of the languageHints to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageHintsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLanguageHintsIsMutable();
      languageHints_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloud.vision.v1p4beta1.CropHintsParams cropHintsParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.CropHintsParams,
            com.google.cloud.vision.v1p4beta1.CropHintsParams.Builder,
            com.google.cloud.vision.v1p4beta1.CropHintsParamsOrBuilder>
        cropHintsParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     *
     * @return Whether the cropHintsParams field is set.
     */
    public boolean hasCropHintsParams() {
      return cropHintsParamsBuilder_ != null || cropHintsParams_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     *
     * @return The cropHintsParams.
     */
    public com.google.cloud.vision.v1p4beta1.CropHintsParams getCropHintsParams() {
      if (cropHintsParamsBuilder_ == null) {
        return cropHintsParams_ == null
            ? com.google.cloud.vision.v1p4beta1.CropHintsParams.getDefaultInstance()
            : cropHintsParams_;
      } else {
        return cropHintsParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder setCropHintsParams(com.google.cloud.vision.v1p4beta1.CropHintsParams value) {
      if (cropHintsParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cropHintsParams_ = value;
        onChanged();
      } else {
        cropHintsParamsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder setCropHintsParams(
        com.google.cloud.vision.v1p4beta1.CropHintsParams.Builder builderForValue) {
      if (cropHintsParamsBuilder_ == null) {
        cropHintsParams_ = builderForValue.build();
        onChanged();
      } else {
        cropHintsParamsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder mergeCropHintsParams(com.google.cloud.vision.v1p4beta1.CropHintsParams value) {
      if (cropHintsParamsBuilder_ == null) {
        if (cropHintsParams_ != null) {
          cropHintsParams_ =
              com.google.cloud.vision.v1p4beta1.CropHintsParams.newBuilder(cropHintsParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          cropHintsParams_ = value;
        }
        onChanged();
      } else {
        cropHintsParamsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder clearCropHintsParams() {
      if (cropHintsParamsBuilder_ == null) {
        cropHintsParams_ = null;
        onChanged();
      } else {
        cropHintsParams_ = null;
        cropHintsParamsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     */
    public com.google.cloud.vision.v1p4beta1.CropHintsParams.Builder getCropHintsParamsBuilder() {

      onChanged();
      return getCropHintsParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     */
    public com.google.cloud.vision.v1p4beta1.CropHintsParamsOrBuilder
        getCropHintsParamsOrBuilder() {
      if (cropHintsParamsBuilder_ != null) {
        return cropHintsParamsBuilder_.getMessageOrBuilder();
      } else {
        return cropHintsParams_ == null
            ? com.google.cloud.vision.v1p4beta1.CropHintsParams.getDefaultInstance()
            : cropHintsParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.CropHintsParams crop_hints_params = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.CropHintsParams,
            com.google.cloud.vision.v1p4beta1.CropHintsParams.Builder,
            com.google.cloud.vision.v1p4beta1.CropHintsParamsOrBuilder>
        getCropHintsParamsFieldBuilder() {
      if (cropHintsParamsBuilder_ == null) {
        cropHintsParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.CropHintsParams,
                com.google.cloud.vision.v1p4beta1.CropHintsParams.Builder,
                com.google.cloud.vision.v1p4beta1.CropHintsParamsOrBuilder>(
                getCropHintsParams(), getParentForChildren(), isClean());
        cropHintsParams_ = null;
      }
      return cropHintsParamsBuilder_;
    }

    private com.google.cloud.vision.v1p4beta1.FaceRecognitionParams faceRecognitionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.FaceRecognitionParams,
            com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.Builder,
            com.google.cloud.vision.v1p4beta1.FaceRecognitionParamsOrBuilder>
        faceRecognitionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     *
     * @return Whether the faceRecognitionParams field is set.
     */
    public boolean hasFaceRecognitionParams() {
      return faceRecognitionParamsBuilder_ != null || faceRecognitionParams_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     *
     * @return The faceRecognitionParams.
     */
    public com.google.cloud.vision.v1p4beta1.FaceRecognitionParams getFaceRecognitionParams() {
      if (faceRecognitionParamsBuilder_ == null) {
        return faceRecognitionParams_ == null
            ? com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.getDefaultInstance()
            : faceRecognitionParams_;
      } else {
        return faceRecognitionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     */
    public Builder setFaceRecognitionParams(
        com.google.cloud.vision.v1p4beta1.FaceRecognitionParams value) {
      if (faceRecognitionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        faceRecognitionParams_ = value;
        onChanged();
      } else {
        faceRecognitionParamsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     */
    public Builder setFaceRecognitionParams(
        com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.Builder builderForValue) {
      if (faceRecognitionParamsBuilder_ == null) {
        faceRecognitionParams_ = builderForValue.build();
        onChanged();
      } else {
        faceRecognitionParamsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     */
    public Builder mergeFaceRecognitionParams(
        com.google.cloud.vision.v1p4beta1.FaceRecognitionParams value) {
      if (faceRecognitionParamsBuilder_ == null) {
        if (faceRecognitionParams_ != null) {
          faceRecognitionParams_ =
              com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.newBuilder(
                      faceRecognitionParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          faceRecognitionParams_ = value;
        }
        onChanged();
      } else {
        faceRecognitionParamsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     */
    public Builder clearFaceRecognitionParams() {
      if (faceRecognitionParamsBuilder_ == null) {
        faceRecognitionParams_ = null;
        onChanged();
      } else {
        faceRecognitionParams_ = null;
        faceRecognitionParamsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     */
    public com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.Builder
        getFaceRecognitionParamsBuilder() {

      onChanged();
      return getFaceRecognitionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     */
    public com.google.cloud.vision.v1p4beta1.FaceRecognitionParamsOrBuilder
        getFaceRecognitionParamsOrBuilder() {
      if (faceRecognitionParamsBuilder_ != null) {
        return faceRecognitionParamsBuilder_.getMessageOrBuilder();
      } else {
        return faceRecognitionParams_ == null
            ? com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.getDefaultInstance()
            : faceRecognitionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for face recognition.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.FaceRecognitionParams face_recognition_params = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.FaceRecognitionParams,
            com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.Builder,
            com.google.cloud.vision.v1p4beta1.FaceRecognitionParamsOrBuilder>
        getFaceRecognitionParamsFieldBuilder() {
      if (faceRecognitionParamsBuilder_ == null) {
        faceRecognitionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.FaceRecognitionParams,
                com.google.cloud.vision.v1p4beta1.FaceRecognitionParams.Builder,
                com.google.cloud.vision.v1p4beta1.FaceRecognitionParamsOrBuilder>(
                getFaceRecognitionParams(), getParentForChildren(), isClean());
        faceRecognitionParams_ = null;
      }
      return faceRecognitionParamsBuilder_;
    }

    private com.google.cloud.vision.v1p4beta1.ProductSearchParams productSearchParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.ProductSearchParams,
            com.google.cloud.vision.v1p4beta1.ProductSearchParams.Builder,
            com.google.cloud.vision.v1p4beta1.ProductSearchParamsOrBuilder>
        productSearchParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     *
     * @return Whether the productSearchParams field is set.
     */
    public boolean hasProductSearchParams() {
      return productSearchParamsBuilder_ != null || productSearchParams_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     *
     * @return The productSearchParams.
     */
    public com.google.cloud.vision.v1p4beta1.ProductSearchParams getProductSearchParams() {
      if (productSearchParamsBuilder_ == null) {
        return productSearchParams_ == null
            ? com.google.cloud.vision.v1p4beta1.ProductSearchParams.getDefaultInstance()
            : productSearchParams_;
      } else {
        return productSearchParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder setProductSearchParams(
        com.google.cloud.vision.v1p4beta1.ProductSearchParams value) {
      if (productSearchParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        productSearchParams_ = value;
        onChanged();
      } else {
        productSearchParamsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder setProductSearchParams(
        com.google.cloud.vision.v1p4beta1.ProductSearchParams.Builder builderForValue) {
      if (productSearchParamsBuilder_ == null) {
        productSearchParams_ = builderForValue.build();
        onChanged();
      } else {
        productSearchParamsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder mergeProductSearchParams(
        com.google.cloud.vision.v1p4beta1.ProductSearchParams value) {
      if (productSearchParamsBuilder_ == null) {
        if (productSearchParams_ != null) {
          productSearchParams_ =
              com.google.cloud.vision.v1p4beta1.ProductSearchParams.newBuilder(productSearchParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          productSearchParams_ = value;
        }
        onChanged();
      } else {
        productSearchParamsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder clearProductSearchParams() {
      if (productSearchParamsBuilder_ == null) {
        productSearchParams_ = null;
        onChanged();
      } else {
        productSearchParams_ = null;
        productSearchParamsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     */
    public com.google.cloud.vision.v1p4beta1.ProductSearchParams.Builder
        getProductSearchParamsBuilder() {

      onChanged();
      return getProductSearchParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     */
    public com.google.cloud.vision.v1p4beta1.ProductSearchParamsOrBuilder
        getProductSearchParamsOrBuilder() {
      if (productSearchParamsBuilder_ != null) {
        return productSearchParamsBuilder_.getMessageOrBuilder();
      } else {
        return productSearchParams_ == null
            ? com.google.cloud.vision.v1p4beta1.ProductSearchParams.getDefaultInstance()
            : productSearchParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.ProductSearchParams product_search_params = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.ProductSearchParams,
            com.google.cloud.vision.v1p4beta1.ProductSearchParams.Builder,
            com.google.cloud.vision.v1p4beta1.ProductSearchParamsOrBuilder>
        getProductSearchParamsFieldBuilder() {
      if (productSearchParamsBuilder_ == null) {
        productSearchParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.ProductSearchParams,
                com.google.cloud.vision.v1p4beta1.ProductSearchParams.Builder,
                com.google.cloud.vision.v1p4beta1.ProductSearchParamsOrBuilder>(
                getProductSearchParams(), getParentForChildren(), isClean());
        productSearchParams_ = null;
      }
      return productSearchParamsBuilder_;
    }

    private com.google.cloud.vision.v1p4beta1.WebDetectionParams webDetectionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.WebDetectionParams,
            com.google.cloud.vision.v1p4beta1.WebDetectionParams.Builder,
            com.google.cloud.vision.v1p4beta1.WebDetectionParamsOrBuilder>
        webDetectionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     *
     * @return Whether the webDetectionParams field is set.
     */
    public boolean hasWebDetectionParams() {
      return webDetectionParamsBuilder_ != null || webDetectionParams_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     *
     * @return The webDetectionParams.
     */
    public com.google.cloud.vision.v1p4beta1.WebDetectionParams getWebDetectionParams() {
      if (webDetectionParamsBuilder_ == null) {
        return webDetectionParams_ == null
            ? com.google.cloud.vision.v1p4beta1.WebDetectionParams.getDefaultInstance()
            : webDetectionParams_;
      } else {
        return webDetectionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder setWebDetectionParams(
        com.google.cloud.vision.v1p4beta1.WebDetectionParams value) {
      if (webDetectionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webDetectionParams_ = value;
        onChanged();
      } else {
        webDetectionParamsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder setWebDetectionParams(
        com.google.cloud.vision.v1p4beta1.WebDetectionParams.Builder builderForValue) {
      if (webDetectionParamsBuilder_ == null) {
        webDetectionParams_ = builderForValue.build();
        onChanged();
      } else {
        webDetectionParamsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder mergeWebDetectionParams(
        com.google.cloud.vision.v1p4beta1.WebDetectionParams value) {
      if (webDetectionParamsBuilder_ == null) {
        if (webDetectionParams_ != null) {
          webDetectionParams_ =
              com.google.cloud.vision.v1p4beta1.WebDetectionParams.newBuilder(webDetectionParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          webDetectionParams_ = value;
        }
        onChanged();
      } else {
        webDetectionParamsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder clearWebDetectionParams() {
      if (webDetectionParamsBuilder_ == null) {
        webDetectionParams_ = null;
        onChanged();
      } else {
        webDetectionParams_ = null;
        webDetectionParamsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     */
    public com.google.cloud.vision.v1p4beta1.WebDetectionParams.Builder
        getWebDetectionParamsBuilder() {

      onChanged();
      return getWebDetectionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     */
    public com.google.cloud.vision.v1p4beta1.WebDetectionParamsOrBuilder
        getWebDetectionParamsOrBuilder() {
      if (webDetectionParamsBuilder_ != null) {
        return webDetectionParamsBuilder_.getMessageOrBuilder();
      } else {
        return webDetectionParams_ == null
            ? com.google.cloud.vision.v1p4beta1.WebDetectionParams.getDefaultInstance()
            : webDetectionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.WebDetectionParams web_detection_params = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.WebDetectionParams,
            com.google.cloud.vision.v1p4beta1.WebDetectionParams.Builder,
            com.google.cloud.vision.v1p4beta1.WebDetectionParamsOrBuilder>
        getWebDetectionParamsFieldBuilder() {
      if (webDetectionParamsBuilder_ == null) {
        webDetectionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.WebDetectionParams,
                com.google.cloud.vision.v1p4beta1.WebDetectionParams.Builder,
                com.google.cloud.vision.v1p4beta1.WebDetectionParamsOrBuilder>(
                getWebDetectionParams(), getParentForChildren(), isClean());
        webDetectionParams_ = null;
      }
      return webDetectionParamsBuilder_;
    }

    private com.google.cloud.vision.v1p4beta1.TextDetectionParams textDetectionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.TextDetectionParams,
            com.google.cloud.vision.v1p4beta1.TextDetectionParams.Builder,
            com.google.cloud.vision.v1p4beta1.TextDetectionParamsOrBuilder>
        textDetectionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     *
     * @return Whether the textDetectionParams field is set.
     */
    public boolean hasTextDetectionParams() {
      return textDetectionParamsBuilder_ != null || textDetectionParams_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     *
     * @return The textDetectionParams.
     */
    public com.google.cloud.vision.v1p4beta1.TextDetectionParams getTextDetectionParams() {
      if (textDetectionParamsBuilder_ == null) {
        return textDetectionParams_ == null
            ? com.google.cloud.vision.v1p4beta1.TextDetectionParams.getDefaultInstance()
            : textDetectionParams_;
      } else {
        return textDetectionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder setTextDetectionParams(
        com.google.cloud.vision.v1p4beta1.TextDetectionParams value) {
      if (textDetectionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        textDetectionParams_ = value;
        onChanged();
      } else {
        textDetectionParamsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder setTextDetectionParams(
        com.google.cloud.vision.v1p4beta1.TextDetectionParams.Builder builderForValue) {
      if (textDetectionParamsBuilder_ == null) {
        textDetectionParams_ = builderForValue.build();
        onChanged();
      } else {
        textDetectionParamsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder mergeTextDetectionParams(
        com.google.cloud.vision.v1p4beta1.TextDetectionParams value) {
      if (textDetectionParamsBuilder_ == null) {
        if (textDetectionParams_ != null) {
          textDetectionParams_ =
              com.google.cloud.vision.v1p4beta1.TextDetectionParams.newBuilder(textDetectionParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          textDetectionParams_ = value;
        }
        onChanged();
      } else {
        textDetectionParamsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder clearTextDetectionParams() {
      if (textDetectionParamsBuilder_ == null) {
        textDetectionParams_ = null;
        onChanged();
      } else {
        textDetectionParams_ = null;
        textDetectionParamsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     */
    public com.google.cloud.vision.v1p4beta1.TextDetectionParams.Builder
        getTextDetectionParamsBuilder() {

      onChanged();
      return getTextDetectionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     */
    public com.google.cloud.vision.v1p4beta1.TextDetectionParamsOrBuilder
        getTextDetectionParamsOrBuilder() {
      if (textDetectionParamsBuilder_ != null) {
        return textDetectionParamsBuilder_.getMessageOrBuilder();
      } else {
        return textDetectionParams_ == null
            ? com.google.cloud.vision.v1p4beta1.TextDetectionParams.getDefaultInstance()
            : textDetectionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextDetectionParams text_detection_params = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.TextDetectionParams,
            com.google.cloud.vision.v1p4beta1.TextDetectionParams.Builder,
            com.google.cloud.vision.v1p4beta1.TextDetectionParamsOrBuilder>
        getTextDetectionParamsFieldBuilder() {
      if (textDetectionParamsBuilder_ == null) {
        textDetectionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.TextDetectionParams,
                com.google.cloud.vision.v1p4beta1.TextDetectionParams.Builder,
                com.google.cloud.vision.v1p4beta1.TextDetectionParamsOrBuilder>(
                getTextDetectionParams(), getParentForChildren(), isClean());
        textDetectionParams_ = null;
      }
      return textDetectionParamsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p4beta1.ImageContext)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p4beta1.ImageContext)
  private static final com.google.cloud.vision.v1p4beta1.ImageContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p4beta1.ImageContext();
  }

  public static com.google.cloud.vision.v1p4beta1.ImageContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImageContext> PARSER =
      new com.google.protobuf.AbstractParser<ImageContext>() {
        @java.lang.Override
        public ImageContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImageContext(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImageContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImageContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.ImageContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
